/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebatefeepool.utils;

import com.biz.crm.nebular.dms.rebatefeepool.RebateDetailLogReflushVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolDetailEntity;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolBpmUtil;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RebateFeePoolDetailUtil {
    public static void validate(RebateFeePoolDetailVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u65b0\u589e\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public static List<RebateFeePoolDetailEntity> calTotalForFeflush(List<RebateFeePoolDetailEntity> entities, List<RebateDetailLogReflushVo> list) {
        for (RebateFeePoolDetailEntity entity : entities) {
            BigDecimal onAccountFee = BigDecimal.ZERO;
            BigDecimal usedFee = BigDecimal.ZERO;
            BigDecimal frozenFee = BigDecimal.ZERO;
            List currentList = list.stream().filter(vo -> vo.getRebateFeePoolItemDetailCode().equals(entity.getCode())).collect(Collectors.toList());
            for (RebateDetailLogReflushVo vo2 : currentList) {
                if (RebateFeePoolBpmUtil.ApprovalEnum.PROCESSED.getState().intValue() != vo2.getBpmstate().intValue()) continue;
                if (RebateFeePoolDetailLogUtil.AdjustTypeEnum.isType(vo2.getAdjustTypeCode(), 1)) {
                    onAccountFee = onAccountFee.add(vo2.getFee());
                }
                if (RebateFeePoolDetailLogUtil.AdjustTypeEnum.isType(vo2.getAdjustTypeCode(), 0)) {
                    usedFee = usedFee.add(vo2.getFee());
                }
                if (RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode().equals(vo2.getAdjustTypeCode())) {
                    frozenFee = frozenFee.add(vo2.getFee());
                }
                if (RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode().equals(vo2.getAdjustTypeCode())) {
                    frozenFee = frozenFee.subtract(vo2.getFee());
                }
                if (!RebateFeePoolDetailLogUtil.AdjustTypeEnum.isType(vo2.getAdjustTypeCode(), 3)) continue;
                usedFee = usedFee.subtract(vo2.getFee());
            }
            entity.setItemTotalFee(onAccountFee);
            entity.setItemUsedFee(usedFee);
            entity.setItemFrozenFee(frozenFee);
            entity.setItemAvailableBalance(onAccountFee.subtract(usedFee).subtract(frozenFee));
        }
        return entities;
    }

    public static enum PayTypeEnum {
        REBATE(0, "\u6298\u6263"),
        REP(1, "\u8d27\u8865");

        private Integer code;
        private String desc;

        private PayTypeEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static String getDesc(Integer payType) {
            PayTypeEnum[] payTypeEnums;
            for (PayTypeEnum payTypeEnum : payTypeEnums = PayTypeEnum.values()) {
                if (!Objects.equals(payType, payTypeEnum.getCode())) continue;
                return payTypeEnum.getDesc();
            }
            return null;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

