/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.repfeepool.entity.RepFeePoolBpmEntity;
import com.biz.crm.repfeepool.entity.RepFeePoolEntity;
import com.biz.crm.repfeepool.entity.RepFeePoolItemDetailEntity;
import com.biz.crm.repfeepool.entity.RepFeePoolItemDetailLogEntity;
import com.biz.crm.repfeepool.entity.RepFeePoolItemEntity;
import com.biz.crm.repfeepool.service.RepFeePoolBpmService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailLogService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailService;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.repfeepool.service.RepFeePoolService;
import com.biz.crm.repfeepool.service.RepFeePoolUpdateProductService;
import com.biz.crm.repfeepool.utils.RepFeePoolBpmUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailLogUtil;
import com.biz.crm.repfeepool.vo.RepFeePoolUpdateVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"repFeePoolUpdateProductServiceExpandImpl"})
public class RepFeePoolUpdateProductServiceImpl
implements RepFeePoolUpdateProductService {
    private static final Logger log = LoggerFactory.getLogger(RepFeePoolUpdateProductServiceImpl.class);
    @Autowired
    private RepFeePoolItemService repFeePoolItemService;
    @Autowired
    private RepFeePoolService repFeePoolService;
    @Autowired
    private RepFeePoolIItemDetailService repFeePoolIItemDetailService;
    @Autowired
    private RepFeePoolIItemDetailLogService repFeePoolIItemDetailLogService;
    @Autowired
    private RepFeePoolBpmService repFeePoolBpmService;

    @Override
    public String updateProduct(RepFeePoolUpdateVo repFeePoolUpdateVo) {
        List<RepFeePoolItemEntity> items = this.getAllItemListForUsable(repFeePoolUpdateVo);
        if (CollectionUtil.listEmpty(items)) {
            throw new BusinessException(repFeePoolUpdateVo.getOldProductName() + "\u88ab\u66ff\u6362\u5546\u54c1\u5df2\u5b8c\u5168\u4f7f\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        int i = 0;
        int succeedCount = 0;
        int falseCount = 0;
        for (RepFeePoolItemEntity item : items) {
            boolean flag = this.clearAndSaveFee(item, repFeePoolUpdateVo);
            if (flag) {
                ++succeedCount;
            } else {
                ++falseCount;
            }
            ++i;
        }
        return "\u6267\u884c\u603b\u6570\uff1a" + i + "\u6761 \u6210\u529f:" + succeedCount + "\u6761 \u5931\u8d25:" + falseCount + "\u6761";
    }

    @Transactional
    boolean clearAndSaveFee(RepFeePoolItemEntity itemOld, RepFeePoolUpdateVo repFeePoolUpdateVo) {
        try {
            RepFeePoolEntity repFeePoolOld = this.repFeePoolService.getEntityByCode(itemOld.getRepFeePoolCode());
            RepFeePoolItemEntity itemNew = this.repFeePoolItemService.getEntityByFeePoolCodeAndProduct(repFeePoolOld.getCode(), repFeePoolUpdateVo.getNewProductCode());
            if (itemNew == null) {
                this.insertNewAndSave(repFeePoolUpdateVo, repFeePoolOld, itemOld);
            } else {
                this.updateNewAndSave(itemNew, repFeePoolUpdateVo, repFeePoolOld, itemOld);
            }
            this.clearOldAndSave(itemOld, repFeePoolUpdateVo, repFeePoolOld);
            return true;
        }
        catch (Exception e) {
            log.error("\u8d27\u8865\u66f4\u6362\u5546\u54c1", (Throwable)e);
            return false;
        }
    }

    @Transactional
    void clearOldAndSave(RepFeePoolItemEntity item, RepFeePoolUpdateVo repFeePoolUpdateVo, RepFeePoolEntity repFeePoolOld) {
        RepFeePoolBpmEntity bpmEntity = this.createOldBpm(item, repFeePoolOld, repFeePoolUpdateVo);
        List<RepFeePoolItemDetailEntity> list = this.repFeePoolIItemDetailService.getListByItemCode(item.getCode());
        if (CollectionUtil.listEmpty(list)) {
            throw new BusinessException("\u6570\u636e\u5f02\u5e38:" + item.getCode());
        }
        ArrayList<RepFeePoolItemDetailLogEntity> logs = new ArrayList<RepFeePoolItemDetailLogEntity>();
        for (RepFeePoolItemDetailEntity detail : list) {
            RepFeePoolItemDetailLogEntity logEntity = this.createLogOld(detail, bpmEntity.getCode(), repFeePoolUpdateVo, repFeePoolOld);
            logs.add(logEntity);
        }
        this.repFeePoolBpmService.save((Object)bpmEntity);
        this.repFeePoolIItemDetailLogService.saveBatch(logs);
        this.repFeePoolItemService.reflush(repFeePoolOld.getCusCode(), repFeePoolOld.getSaleCompanyCode(), repFeePoolUpdateVo.getOldProductCode(), bpmEntity.getCode());
    }

    @Transactional
    void updateNewAndSave(RepFeePoolItemEntity item, RepFeePoolUpdateVo repFeePoolUpdateVo, RepFeePoolEntity repFeePoolNew, RepFeePoolItemEntity oldItem) {
        RepFeePoolBpmEntity bpmEntity = this.updateNewBpm(oldItem, item, repFeePoolNew, repFeePoolUpdateVo);
        List<RepFeePoolItemDetailEntity> list = this.repFeePoolIItemDetailService.getListByItemCode(item.getCode());
        if (CollectionUtil.listEmpty(list)) {
            throw new BusinessException("\u6570\u636e\u5f02\u5e38:" + item.getCode());
        }
        ArrayList<RepFeePoolItemDetailLogEntity> logs = new ArrayList<RepFeePoolItemDetailLogEntity>();
        RepFeePoolItemDetailEntity detail = list.get(0);
        RepFeePoolItemDetailLogEntity logEntity = this.updateLogNew(detail, oldItem, bpmEntity.getCode(), repFeePoolUpdateVo, repFeePoolNew);
        logs.add(logEntity);
        this.repFeePoolBpmService.save((Object)bpmEntity);
        this.repFeePoolIItemDetailLogService.saveBatch(logs);
        this.repFeePoolItemService.reflush(repFeePoolNew.getCusCode(), repFeePoolNew.getSaleCompanyCode(), repFeePoolUpdateVo.getNewProductCode(), bpmEntity.getCode());
    }

    @Transactional
    void insertNewAndSave(RepFeePoolUpdateVo repFeePoolUpdateVo, RepFeePoolEntity repFeePoolNew, RepFeePoolItemEntity oldItem) {
        RepFeePoolItemEntity newItem = this.createNewItem(repFeePoolUpdateVo, repFeePoolNew, oldItem);
        RepFeePoolBpmEntity bpmEntity = this.updateNewBpm(oldItem, newItem, repFeePoolNew, repFeePoolUpdateVo);
        RepFeePoolItemDetailEntity detail = this.createNewDetail(newItem);
        ArrayList<RepFeePoolItemDetailLogEntity> logs = new ArrayList<RepFeePoolItemDetailLogEntity>();
        RepFeePoolItemDetailLogEntity logEntity = this.updateLogNew(detail, oldItem, bpmEntity.getCode(), repFeePoolUpdateVo, repFeePoolNew);
        logs.add(logEntity);
        this.repFeePoolBpmService.save((Object)bpmEntity);
        this.repFeePoolItemService.save((Object)newItem);
        this.repFeePoolIItemDetailService.save((Object)detail);
        this.repFeePoolIItemDetailLogService.saveBatch(logs);
        this.repFeePoolItemService.reflush(repFeePoolNew.getCusCode(), repFeePoolNew.getSaleCompanyCode(), repFeePoolUpdateVo.getNewProductCode(), bpmEntity.getCode());
    }

    private RepFeePoolItemDetailEntity createNewDetail(RepFeePoolItemEntity newItem) {
        RepFeePoolItemDetailEntity detail = new RepFeePoolItemDetailEntity();
        detail.setRepFeePoolItemCode(newItem.getCode());
        detail.setCode(CodeUtil.getCodeDefault());
        detail.setOnAccountCount(newItem.getAvailableCount());
        detail.setOnAccountFee(newItem.getAvailableFee());
        detail.setAvailableCount(newItem.getAvailableCount());
        detail.setAvailableFee(newItem.getAvailableFee());
        detail.setPayType(newItem.getPayType());
        detail.setProductCode(newItem.getProductCode());
        detail.setProductName(newItem.getProductName());
        detail.setPrice(newItem.getCostPrice());
        detail.setUnit(newItem.getUnit());
        detail.setUnitName(newItem.getUnitName());
        return detail;
    }

    private RepFeePoolItemEntity createNewItem(RepFeePoolUpdateVo repFeePoolUpdateVo, RepFeePoolEntity repFeePoolNew, RepFeePoolItemEntity oldItem) {
        RepFeePoolItemEntity newItem = new RepFeePoolItemEntity();
        BeanUtils.copyProperties((Object)((Object)oldItem), (Object)((Object)newItem));
        newItem.setId(null);
        newItem.setDelFlag(null);
        newItem.setEnableStatus(null);
        newItem.setCreateDate(null);
        newItem.setCreateDateSecond(null);
        newItem.setCreateCode(null);
        newItem.setCreateName(null);
        newItem.setCreateOrgCode(null);
        newItem.setCreateOrgName(null);
        newItem.setCreatePosCode(null);
        newItem.setCreatePosName(null);
        newItem.setUpdateDate(null);
        newItem.setUpdateDateSecond(null);
        newItem.setUpdateCode(null);
        newItem.setUpdateName(null);
        newItem.setUpdateOrgCode(null);
        newItem.setUpdateOrgName(null);
        newItem.setUpdatePosCode(null);
        newItem.setUpdatePosName(null);
        newItem.setRemarks("\u66f4\u6362\u5546\u54c1" + repFeePoolUpdateVo.getOldProductCode() + "-->" + repFeePoolUpdateVo.getNewProductCode());
        newItem.setCode(CodeUtil.getCodeDefault());
        newItem.setRepFeePoolCode(repFeePoolNew.getCode());
        newItem.setProductCode(repFeePoolUpdateVo.getNewProductCode());
        newItem.setProductName(repFeePoolUpdateVo.getNewProductName());
        newItem.setOnAccountCount(oldItem.getAvailableCount());
        newItem.setOnAccountFee(oldItem.getAvailableFee());
        newItem.setUsedCount(BigDecimal.ZERO);
        newItem.setUsedFee(BigDecimal.ZERO);
        newItem.setFrozenCount(BigDecimal.ZERO);
        newItem.setFrozenFee(BigDecimal.ZERO);
        newItem.setAvailableCount(oldItem.getAvailableCount());
        newItem.setAvailableFee(oldItem.getAvailableFee());
        return newItem;
    }

    private RepFeePoolItemDetailLogEntity createLogOld(RepFeePoolItemDetailEntity detail, String repFeePoolBpmCode, RepFeePoolUpdateVo repFeePoolUpdateVo, RepFeePoolEntity repFeePoolOld) {
        RepFeePoolItemDetailLogEntity log = new RepFeePoolItemDetailLogEntity();
        this.buildLogCommon(log, detail, repFeePoolBpmCode, repFeePoolOld, repFeePoolUpdateVo);
        log.setAdjustCount(detail.getAvailableCount());
        log.setAdjustFee(detail.getAvailableFee());
        log.setAdjustFeeType(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode());
        log.setAdjustCountType(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode());
        log.setUsedFee(detail.getAvailableFee());
        log.setUsedCount(detail.getAvailableCount());
        log.setAvailableCount(detail.getAvailableCount());
        log.setProductCode(detail.getProductCode());
        return log;
    }

    private RepFeePoolItemDetailLogEntity updateLogNew(RepFeePoolItemDetailEntity detailNew, RepFeePoolItemEntity oldItem, String repFeePoolBpmCode, RepFeePoolUpdateVo repFeePoolUpdateVo, RepFeePoolEntity repFeePool) {
        RepFeePoolItemDetailLogEntity log = new RepFeePoolItemDetailLogEntity();
        this.buildLogCommon(log, detailNew, repFeePoolBpmCode, repFeePool, repFeePoolUpdateVo);
        log.setAdjustCount(oldItem.getAvailableCount());
        log.setAdjustFee(oldItem.getAvailableFee());
        log.setAdjustFeeType(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_ADD.getCode());
        log.setAdjustCountType(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_ADD.getCode());
        log.setAvailableCount(oldItem.getAvailableCount().add(detailNew.getAvailableCount()));
        log.setOnAccountCount(oldItem.getAvailableCount());
        log.setOnAccountFee(oldItem.getAvailableFee());
        log.setProductCode(detailNew.getProductCode());
        return log;
    }

    private void buildLogCommon(RepFeePoolItemDetailLogEntity log, RepFeePoolItemDetailEntity detail, String repFeePoolBpmCode, RepFeePoolEntity repFeePool, RepFeePoolUpdateVo repFeePoolUpdateVo) {
        log.setPayType(1);
        log.setCode(CodeUtil.getCodeDefault());
        log.setAdjustReason("other_reason");
        log.setRepFeePoolItemDetailCode(detail.getCode());
        log.setRepFeePoolBpmCode(repFeePoolBpmCode);
        log.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.PROCESSED.getState());
        log.setCusCode(repFeePool.getCusCode());
        log.setSaleCompanyCode(repFeePool.getSaleCompanyCode());
        log.setUniqueDictCode(repFeePool.getUniqueDictCode());
        log.setRemarks("\u66f4\u6362\u5546\u54c1" + repFeePoolUpdateVo.getOldProductCode() + "-->" + repFeePoolUpdateVo.getNewProductCode());
    }

    private RepFeePoolBpmEntity createOldBpm(RepFeePoolItemEntity item, RepFeePoolEntity repFeePoolOld, RepFeePoolUpdateVo repFeePoolUpdateVo) {
        RepFeePoolBpmEntity bpm = new RepFeePoolBpmEntity();
        this.builldCommon(bpm, repFeePoolOld, repFeePoolUpdateVo, item);
        bpm.setAdjustCountType(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode());
        bpm.setAdjustFeeType(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode());
        bpm.setPrice(item.getCostPrice());
        bpm.setAdjustFee(item.getAvailableFee());
        bpm.setAdjustCount(item.getAvailableCount());
        bpm.setResourceCode(item.getCode());
        bpm.setBeforeAvailableFee(item.getAvailableFee());
        bpm.setBeforeAvailableCount(item.getAvailableCount());
        bpm.setSalePrice(item.getSalePrice());
        bpm.setCostPrice(item.getCostPrice());
        bpm.setRepFeePoolItemCode(item.getCode());
        return bpm;
    }

    private RepFeePoolBpmEntity updateNewBpm(RepFeePoolItemEntity itemOld, RepFeePoolItemEntity itemNew, RepFeePoolEntity repFeePool, RepFeePoolUpdateVo repFeePoolUpdateVo) {
        RepFeePoolBpmEntity bpm = new RepFeePoolBpmEntity();
        this.builldCommon(bpm, repFeePool, repFeePoolUpdateVo, itemNew);
        bpm.setAdjustCountType(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_ADD.getCode());
        bpm.setAdjustFeeType(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_ADD.getCode());
        bpm.setPrice(itemOld.getCostPrice());
        bpm.setAdjustFee(itemOld.getAvailableFee());
        bpm.setAdjustCount(itemOld.getAvailableCount());
        bpm.setResourceCode(itemOld.getCode());
        bpm.setBeforeAvailableFee(itemNew.getAvailableFee());
        bpm.setBeforeAvailableCount(itemNew.getAvailableCount());
        bpm.setSalePrice(itemOld.getSalePrice());
        bpm.setCostPrice(itemOld.getCostPrice());
        bpm.setRepFeePoolItemCode(itemNew.getCode());
        return bpm;
    }

    private void builldCommon(RepFeePoolBpmEntity bpm, RepFeePoolEntity repFeePool, RepFeePoolUpdateVo repFeePoolUpdateVo, RepFeePoolItemEntity item) {
        bpm.setCode(CodeUtil.getCodeDefault());
        bpm.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.WITHOUT_APPROVE.getState());
        bpm.setCusCode(repFeePool.getCusCode());
        bpm.setCusName(repFeePool.getCusName());
        bpm.setSaleCompanyCode(repFeePool.getSaleCompanyCode());
        bpm.setSaleCompanyName(repFeePool.getSaleCompanyName());
        bpm.setProductCode(item.getProductCode());
        bpm.setProductName(item.getProductName());
        bpm.setUnitCode(item.getUnit());
        bpm.setUnitName(item.getUnitName());
        bpm.setUniqueDictCode(repFeePool.getUniqueDictCode());
        bpm.setAdjustReason("other_reason");
        bpm.setRemarks("\u66f4\u6362\u5546\u54c1" + repFeePoolUpdateVo.getOldProductCode() + "-->" + repFeePoolUpdateVo.getNewProductCode());
    }

    private List<RepFeePoolItemEntity> getAllItemListForUsable(RepFeePoolUpdateVo repFeePoolUpdateVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"product_code", (Object)repFeePoolUpdateVo.getOldProductCode());
        queryWrapper.gt((Object)"available_count", (Object)0);
        List items = this.repFeePoolItemService.list((Wrapper)queryWrapper);
        return items;
    }
}

