/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.utils;

import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailVo;
import com.biz.crm.nebular.dms.repfeepool.RepItemDetailReflushVo;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailUtil;
import com.biz.crm.repfeepool.entity.RepFeePoolItemDetailEntity;
import com.biz.crm.repfeepool.utils.RepFeePoolBpmUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailLogUtil;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RepFeePoolItemDetailUtil {
    public static void validate(RepFeePoolItemDetailVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public static List<RepFeePoolItemDetailEntity> calTotalForFeflush(List<RepFeePoolItemDetailEntity> entities, List<RepItemDetailReflushVo> list) {
        for (RepFeePoolItemDetailEntity entity : entities) {
            BigDecimal onAccountCount = BigDecimal.ZERO;
            BigDecimal onAccountFee = BigDecimal.ZERO;
            BigDecimal usedCount = BigDecimal.ZERO;
            BigDecimal usedFee = BigDecimal.ZERO;
            BigDecimal frozenCount = BigDecimal.ZERO;
            BigDecimal frozenFee = BigDecimal.ZERO;
            BigDecimal onAccountCostFee = BigDecimal.ZERO;
            BigDecimal usedCostFee = BigDecimal.ZERO;
            BigDecimal frozenCostFee = BigDecimal.ZERO;
            List currentList = list.stream().filter(vo -> vo.getRepFeePoolItemDetailCode().equals(entity.getCode())).collect(Collectors.toList());
            for (RepItemDetailReflushVo vo2 : currentList) {
                if (!RepFeePoolBpmUtil.ApprovalEnum.PROCESSED.getState().equals(vo2.getBpmstate())) continue;
                if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.isType(vo2.getAdjustTypeCode(), 1)) {
                    onAccountCount = onAccountCount.add(vo2.getNum());
                    onAccountFee = onAccountFee.add(vo2.getFee());
                    onAccountCostFee = onAccountCostFee.add(vo2.getCostFee());
                }
                if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.isType(vo2.getAdjustTypeCode(), 0)) {
                    usedCount = usedCount.add(vo2.getNum());
                    usedFee = usedFee.add(vo2.getFee());
                    usedCostFee = usedCostFee.add(vo2.getCostFee());
                }
                if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.FROZEN.getCode().equals(vo2.getAdjustTypeCode())) {
                    frozenCount = frozenCount.add(vo2.getNum());
                    frozenFee = frozenFee.add(vo2.getFee());
                    frozenCostFee = frozenCostFee.add(vo2.getCostFee());
                }
                if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode().equals(vo2.getAdjustTypeCode())) {
                    frozenCount = frozenCount.subtract(vo2.getNum());
                    frozenFee = frozenFee.subtract(vo2.getFee());
                    frozenCostFee = frozenCostFee.subtract(vo2.getCostFee());
                }
                if (!RepFeePoolItemDetailLogUtil.AdjustTypeEnum.isType(vo2.getAdjustTypeCode(), 3)) continue;
                usedCount = usedCount.subtract(vo2.getNum());
                usedFee = usedFee.subtract(vo2.getFee());
                usedCostFee = usedCostFee.subtract(vo2.getCostFee());
            }
            entity.setOnAccountCount(onAccountCount);
            entity.setOnAccountFee(onAccountFee);
            entity.setUsedCount(usedCount);
            entity.setUsedFee(usedFee);
            entity.setFrozenCount(frozenCount);
            entity.setFrozenFee(frozenFee);
            entity.setOnAccountCostFee(onAccountCostFee);
            entity.setUsedCostFee(usedCostFee);
            entity.setFrozenCostFee(frozenCostFee);
            entity.setAvailableCount(onAccountCount.subtract(usedCount).subtract(frozenCount));
            entity.setAvailableFee(onAccountFee.subtract(usedFee).subtract(frozenFee));
            entity.setAvailableCostFee(onAccountCostFee.subtract(usedCostFee).subtract(frozenCostFee));
        }
        return entities;
    }

    public static enum PayTypeEnum {
        REBATE(0, "\u6298\u6263"),
        REP(1, "\u8d27\u8865");

        private Integer code;
        private String desc;

        private PayTypeEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static String getDesc(Integer payType) {
            RebateFeePoolDetailUtil.PayTypeEnum[] payTypeEnums;
            for (RebateFeePoolDetailUtil.PayTypeEnum payTypeEnum : payTypeEnums = RebateFeePoolDetailUtil.PayTypeEnum.values()) {
                if (!Objects.equals(payType, payTypeEnum.getCode())) continue;
                return payTypeEnum.getDesc();
            }
            return null;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

