/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.dms.LineTypeEunm;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderFullDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderReqVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.entity.OrderDetailEntity;
import com.biz.crm.order.entity.OrderEntity;
import com.biz.crm.order.mapper.OrderMapper;
import com.biz.crm.order.service.OrderDetailService;
import com.biz.crm.order.service.OrderFileService;
import com.biz.crm.order.service.OrderService;
import com.biz.crm.order.vo.OrderGroupItemSaveVo;
import com.biz.crm.order.vo.OrderItemSaveVo;
import com.biz.crm.order.vo.OrderSaveVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderServiceExpandImpl"})
@Service(value="orderService")
@Transactional
public class OrderServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<OrderMapper, OrderEntity>
implements OrderService {
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private OrderDetailService orderDetailService;
    @Resource
    private OrderFileService orderFileService;

    @Override
    public PageResult<OrderVo> list(OrderVo orderVo) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.like(!StringUtils.isEmpty((String)orderVo.getOrderCode()), (Object)"order_code", (Object)orderVo.getOrderCode());
        queryWrapper.eq(orderVo.getState() != null, (Object)"state", (Object)orderVo.getState());
        queryWrapper.eq(orderVo.getSourceCode() != null, (Object)"source_code", (Object)orderVo.getSourceCode());
        queryWrapper.like(!StringUtils.isEmpty((String)orderVo.getCusCode()), (Object)"cus_code", (Object)orderVo.getCusCode());
        queryWrapper.like(!StringUtils.isEmpty((String)orderVo.getCusName()), (Object)"cus_name", (Object)orderVo.getCusName());
        Page page = PageUtil.buildPage((Integer)orderVo.getPageNum(), (Integer)orderVo.getPageSize());
        List<OrderVo> list = this.orderMapper.list((Page<OrderVo>)page, (QueryWrapper<OrderVo>)queryWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            QueryWrapper queryWrapperDetail = new QueryWrapper();
            List orderCodes = list.stream().map(OrderVo::getOrderCode).collect(Collectors.toList());
            queryWrapperDetail.in((Object)"order_code", orderCodes);
            List orderDetailEntities = this.orderDetailService.list((Wrapper)queryWrapperDetail);
            HashMap itemsMap = new HashMap();
            orderDetailEntities.stream().collect(Collectors.groupingBy(OrderDetailEntity::getOrderCode, Collectors.toList())).forEach((parentId, listTemp) -> itemsMap.put(parentId, listTemp));
            for (OrderVo order : list) {
                if (!itemsMap.containsKey(order.getOrderCode())) continue;
                List orderDetailVos = CrmBeanUtil.copyList((List)((List)itemsMap.get(order.getOrderCode())), OrderDetailVo.class);
                order.setDetailVos(orderDetailVos);
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void cancelByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8981\u53d6\u6d88\u7684\u8ba2\u5355\uff01");
        }
        List orderEntities = this.orderMapper.selectBatchIds(ids);
        if (orderEntities.size() < ids.size()) {
            throw new BusinessException("\u90e8\u5206\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        orderEntities = orderEntities.stream().map(orderEntity -> orderEntity.setState("1")).collect(Collectors.toList());
        this.updateBatchById(orderEntities);
    }

    @Override
    public OrderFullDetailVo getByIdOrOrderCode(String id, String orderCode) {
        if (StringUtils.isEmpty((String)id) && StringUtils.isEmpty((String)orderCode)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u8ba2\u5355\uff01");
        }
        OrderEntity orderEntity = null;
        if (StringUtils.isNotEmpty((String)id)) {
            orderEntity = (OrderEntity)((Object)this.orderMapper.selectById((Serializable)((Object)id)));
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"order_code", (Object)orderCode);
            List orderEntities = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orderEntities)) {
                orderEntity = (OrderEntity)((Object)orderEntities.get(0));
            }
        }
        if (orderEntity == null) {
            throw new BusinessException("\u8981\u67e5\u770b\u7684\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        OrderFullDetailVo orderFullDetailVo = (OrderFullDetailVo)CrmBeanUtil.copy((Object)((Object)orderEntity), OrderFullDetailVo.class);
        List<OrderDetailVo> detailVos = this.orderDetailService.findProductByOrderCode(orderFullDetailVo.getOrderCode());
        HashMap groupMap = new HashMap();
        detailVos.stream().collect(Collectors.groupingBy(OrderDetailVo::getGroupCode, Collectors.toList())).forEach((groupCode, list) -> groupMap.put(groupCode, list));
        ArrayList<OrderGroupItemVo> groupItemVos = new ArrayList<OrderGroupItemVo>();
        for (Map.Entry map : groupMap.entrySet()) {
            OrderGroupItemVo orderGroupItemVo = new OrderGroupItemVo();
            List tempList = (List)map.getValue();
            HashMap lineTypeMap = new HashMap();
            tempList.stream().collect(Collectors.groupingBy(OrderDetailVo::getLineType, Collectors.toList())).forEach((lineType, list) -> lineTypeMap.put(lineType, list));
            orderGroupItemVo.setNormalList((List)lineTypeMap.get(LineTypeEunm.lineTypeEunm.NORMAL.getCode()));
            orderGroupItemVo.setBackList((List)lineTypeMap.get(LineTypeEunm.lineTypeEunm.BACK.getCode()));
            orderGroupItemVo.setGiftList((List)lineTypeMap.get(LineTypeEunm.lineTypeEunm.GIFT.getCode()));
            groupItemVos.add(orderGroupItemVo);
        }
        orderFullDetailVo.setItems(groupItemVos);
        return orderFullDetailVo;
    }

    @Override
    public PageResult<OrderVo> list(OrderReqVo orderReqVo) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.like(!StringUtils.isEmpty((String)orderReqVo.getCode()), (Object)"code", (Object)orderReqVo.getCode());
        queryWrapper.ge(!StringUtils.isEmpty((String)orderReqVo.getStartDate()), (Object)"create_date", (Object)orderReqVo.getStartDate());
        queryWrapper.le(!StringUtils.isEmpty((String)orderReqVo.getEndDate()), (Object)"create_date", (Object)orderReqVo.getEndDate());
        Page page = PageUtil.buildPage((Integer)orderReqVo.getPageNum(), (Integer)orderReqVo.getPageSize());
        List<OrderVo> list = this.orderMapper.list((Page<OrderVo>)page, (QueryWrapper<OrderVo>)queryWrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public OrderEntity saveOrder(OrderSaveVo orderVo) {
        this.checkOrder(orderVo);
        OrderEntity orderEntity = this.createOrderHead(orderVo, true);
        this.createOrderDetail(orderVo, orderEntity, true);
        this.countOrder(orderEntity);
        this.saveOrUpdateOrder(orderEntity);
        this.deductionFee(orderEntity);
        return orderEntity;
    }

    @Override
    public OrderEntity quantityOrder(OrderSaveVo orderVo) {
        OrderEntity orderEntity = this.createOrderHead(orderVo, false);
        this.createOrderDetail(orderVo, orderEntity, false);
        this.countOrder(orderEntity);
        return orderEntity;
    }

    public void checkOrder(OrderSaveVo orderVo) {
        Assert.hasText((String)orderVo.getType(), (String)"\u8bf7\u9009\u62e9\u8ba2\u5355\u7c7b\u578b");
        if (CollectionUtil.listEmpty(orderVo.getItems())) {
            throw new BusinessException("\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5546\u54c1\u6570\u636e");
        }
        for (OrderGroupItemSaveVo group : orderVo.getItems()) {
            boolean giftFlag = false;
            boolean normalFlag = false;
            boolean backFlag = false;
            if (CollectionUtil.listNotEmptyNotSizeZero(group.getNormalList())) {
                normalFlag = true;
                group.getNormalList().forEach(item -> this.commonCheck((OrderItemSaveVo)item));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(group.getGiftList())) {
                giftFlag = true;
                group.getNormalList().forEach(item -> this.commonCheck((OrderItemSaveVo)item));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(group.getBackList())) {
                backFlag = true;
                group.getNormalList().forEach(item -> this.commonCheck((OrderItemSaveVo)item));
            }
            if (!(giftFlag || normalFlag || backFlag)) {
                throw new BusinessException("\u5206\u7ec4\u6570\u636e\u4e0d\u80fd\u5168\u4e3a\u7a7a");
            }
            if ((giftFlag || normalFlag) && backFlag) {
                throw new BusinessException("\u8d27\u8865\u5206\u7ec4\u5e94\u8be5\u4e0d\u80fd\u6709\u5176\u4ed6\u5546\u54c1");
            }
            if (!giftFlag || normalFlag) continue;
            throw new BusinessException("\u8d60\u54c1\u4e0d\u80fd\u72ec\u7acb\u5b58\u5728");
        }
    }

    private void commonCheck(OrderItemSaveVo item) {
        Assert.hasText((String)item.getLineType(), (String)"\u8ba2\u5355\u884c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)item.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)item.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (item.getProductNum() == null || item.getProductNum().compareTo(BigDecimal.ZERO) == 0) {
            throw new BusinessException(item.getProductName() + ":\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        if (item.getPrice() == null) {
            throw new BusinessException(item.getProductName() + ":\u5546\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)item.getPromotionPolicyCode()) && StringUtils.isEmpty((String)item.getPromotionPolicyName())) {
            throw new BusinessException(item.getProductName() + ":\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (LineTypeEunm.lineTypeEunm.GIFT.getCode().equals(item.getLineType())) {
            throw new BusinessException("\u8d60\u54c1\u884c:" + item.getProductName() + "\u4fc3\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public OrderEntity createOrderHead(OrderSaveVo orderVo, boolean flag) {
        OrderEntity orderEntity = new OrderEntity();
        BeanUtils.copyProperties((Object)orderVo, (Object)((Object)orderEntity));
        if (flag) {
            orderEntity.setOrderCode(this.getOrderCode());
        }
        return orderEntity;
    }

    public OrderEntity createOrderDetail(OrderSaveVo orderVo, OrderEntity orderEntity, boolean flag) {
        ArrayList<OrderDetailEntity> detailEntities = new ArrayList<OrderDetailEntity>();
        for (OrderGroupItemSaveVo group : orderVo.getItems()) {
            String groupCode = UUID.randomUUID().toString().replaceAll("-", "");
            if (CollectionUtil.listNotEmptyNotSizeZero(group.getNormalList())) {
                group.getNormalList().forEach(item -> {
                    OrderDetailEntity detailEntity = this.comCreateDetail((OrderItemSaveVo)item, orderVo, orderEntity, groupCode, flag);
                    detailEntities.add(detailEntity);
                });
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(group.getGiftList())) {
                group.getGiftList().forEach(item -> {
                    OrderDetailEntity detailEntity = this.comCreateDetail((OrderItemSaveVo)item, orderVo, orderEntity, groupCode, flag);
                    detailEntities.add(detailEntity);
                });
            }
            if (!CollectionUtil.listNotEmptyNotSizeZero(group.getBackList())) continue;
            group.getBackList().forEach(item -> {
                OrderDetailEntity detailEntity = this.comCreateDetail((OrderItemSaveVo)item, orderVo, orderEntity, groupCode, flag);
                detailEntities.add(detailEntity);
            });
        }
        orderEntity.setDetails(detailEntities);
        return orderEntity;
    }

    private OrderDetailEntity comCreateDetail(OrderItemSaveVo detaiVo, OrderSaveVo orderVo, OrderEntity orderEntity, String groupCode, boolean flag) {
        OrderDetailEntity detailEntity = new OrderDetailEntity();
        BeanUtils.copyProperties((Object)detaiVo, (Object)((Object)detailEntity));
        detailEntity.setOrderCode(orderEntity.getOrderCode());
        if (flag) {
            detailEntity.setLineNo(CodeUtil.getCodeDefault());
        }
        detailEntity.setGroupCode(groupCode);
        return detailEntity;
    }

    public String getOrderCode() {
        return CodeUtil.getCodeDefault();
    }

    public void saveOrUpdateOrder(OrderEntity orderEntity) {
        this.save((Object)orderEntity);
        this.orderDetailService.saveBatch(orderEntity.getDetails());
    }

    public void countOrder(OrderEntity orderEntity) {
        BigDecimal productNum = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal repAmount = BigDecimal.ZERO;
        BigDecimal promotionAmount = BigDecimal.ZERO;
        for (OrderDetailEntity item : orderEntity.getDetails()) {
            BigDecimal priceTemp = item.getPrice() == null ? BigDecimal.ZERO : item.getPrice();
            BigDecimal productNumTemp = item.getProductNum() == null ? BigDecimal.ZERO : item.getProductNum();
            item.setAmount(priceTemp.multiply(productNumTemp));
            amount = amount.add(item.getAmount());
            productNum = productNum.add(productNumTemp);
            if (LineTypeEunm.lineTypeEunm.BACK.getCode().equals(item.getLineType())) {
                repAmount = repAmount.add(item.getAmount());
            }
            if (!LineTypeEunm.lineTypeEunm.GIFT.getCode().equals(item.getLineType())) continue;
            promotionAmount = promotionAmount.add(item.getAmount());
        }
        BigDecimal actualAmount = amount.subtract(repAmount).subtract(promotionAmount);
        BigDecimal discountAmount = orderEntity.getDiscountAmount() == null ? BigDecimal.ZERO : orderEntity.getDiscountAmount();
        orderEntity.setAmount(amount);
        orderEntity.setProductNum(productNum);
        orderEntity.setRepAmount(repAmount);
        orderEntity.setPromotionAmount(promotionAmount);
        orderEntity.setActualAmount(actualAmount);
        orderEntity.setDiscountAmount(discountAmount);
    }

    public void deductionFee(OrderEntity orderEntity) {
    }
}

