/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.dms.FromTypeEunm;
import com.biz.crm.nebular.dms.order.OrderFullDetailVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.entity.OrderEntity;
import com.biz.crm.order.service.OrderService;
import com.biz.crm.order.vo.OrderSaveVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7ba1\u7406\u7aef-\u8ba2\u5355", tags={"\u7ba1\u7406\u7aef-\u8ba2\u5355"})
@RestController
@RequestMapping(value={"/m/order"})
public class OrdermController {
    @Resource
    private OrderService orderService;

    @CrmLog
    @ApiOperation(value="\u5206\u9875\u641c\u7d22\u8ba2\u5355")
    @PostMapping(value={"list"})
    public Result<PageResult<OrderVo>> list(@RequestBody OrderVo orderVo) {
        return Result.ok(this.orderService.list(orderVo));
    }

    @CrmLog
    @ApiOperation(value="\u53d6\u6d88")
    @PostMapping(value={"cancelByIds"})
    public Result cancelByIds(@RequestBody ArrayList<String> ids) {
        this.orderService.cancelByIds(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u67e5\u770b\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"getById/{id}"})
    public Result<OrderFullDetailVo> getById(@PathVariable(value="id") String id) {
        return Result.ok((Object)this.orderService.getByIdOrOrderCode(id, null));
    }

    @CrmLog
    @ApiOperation(value="\u540e\u53f0\u8ba2\u5355\u4fdd\u5b58")
    @PostMapping(value={"saveOrder"})
    public Result<OrderEntity> saveOrder(@RequestBody OrderSaveVo orderVo) {
        orderVo.setFromType(FromTypeEunm.fromTypeEunm.BACKGROUND.getCode());
        OrderEntity orderEntity = this.orderService.saveOrder(orderVo);
        return Result.ok((Object)((Object)orderEntity));
    }

    @CrmLog
    @ApiOperation(value="\u8ba2\u5355\u8ba1\u7b97")
    @PostMapping(value={"quantityOrder"})
    public Result<OrderEntity> quantityOrder(@RequestBody OrderSaveVo orderVo) {
        OrderEntity orderEntity = this.orderService.quantityOrder(orderVo);
        return Result.ok((Object)((Object)orderEntity));
    }
}

