/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salegoal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.dms.SaleGoalEunm;
import com.biz.crm.nebular.dms.salegoal.SaleGoalItemVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalVo;
import com.biz.crm.salegoal.entity.SaleGoalEntity;
import com.biz.crm.salegoal.mapper.SaleGoalMapper;
import com.biz.crm.salegoal.service.SaleGoalItemService;
import com.biz.crm.salegoal.service.SaleGoalService;
import com.biz.crm.salegoal.utils.SaleGoalItemUtil;
import com.biz.crm.salegoal.utils.SaleGoalUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"saleGoalServiceImpl"})
@Service(value="saleGoalService")
public class SaleGoalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SaleGoalMapper, SaleGoalEntity>
implements SaleGoalService {
    @Resource
    private SaleGoalMapper saleGoalMapper;
    @Resource
    private SaleGoalItemService saleGoalItemService;

    @Override
    @Transactional
    public void addBatch(List<SaleGoalVo> saleGoalVos) {
        this.validateForAddBatch(saleGoalVos);
        HashMap<String, SaleGoalItemVo> saleGoalItemMap = new HashMap<String, SaleGoalItemVo>(saleGoalVos.size());
        ArrayList<SaleGoalEntity> entities = new ArrayList<SaleGoalEntity>(saleGoalVos.size());
        for (SaleGoalVo vo : saleGoalVos) {
            SaleGoalItemVo goalItemVo = vo.getSaleGoalItemVo();
            ValidateUtils.validate((Object)goalItemVo, (String)"\u76ee\u6807\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            SaleGoalEntity entity = SaleGoalUtil.packageEntityForAdd(vo);
            goalItemVo.setSaleGoalId(entity.getId());
            goalItemVo.setTaskType(entity.getTaskType());
            entities.add(entity);
            saleGoalItemMap.put(entity.getId(), goalItemVo);
        }
        ArrayList<SaleGoalEntity> currentEntities = new ArrayList<SaleGoalEntity>();
        ArrayList<SaleGoalItemVo> currentItemVos = new ArrayList<SaleGoalItemVo>(saleGoalVos.size());
        int entityI = 0;
        for (SaleGoalEntity entity : entities) {
            currentEntities.add(entity);
            currentItemVos.add((SaleGoalItemVo)saleGoalItemMap.get(entity.getId()));
            if (currentEntities.size() != 500 && ++entityI != entities.size()) continue;
            this.saveBatch(currentEntities);
            this.saleGoalItemService.addBatch(currentItemVos);
            currentEntities.clear();
            currentItemVos.clear();
        }
    }

    private void validateForAddBatch(List<SaleGoalVo> saleGoalVos) {
        SaleGoalUtil.validateParamForAddBatch(saleGoalVos);
        SaleGoalUtil.buildOnlyKey(saleGoalVos);
        List params = saleGoalVos.stream().map(SaleGoalVo::getOnlyKey).collect(Collectors.toList());
        ArrayList<String> currentParam = new ArrayList<String>();
        ArrayList exsits = new ArrayList();
        int i = 0;
        Integer type2 = saleGoalVos.get(0).getType();
        Integer objectType = saleGoalVos.get(0).getObjectType();
        for (Object param : params) {
            currentParam.add((String)param);
            if (currentParam.size() != 500 && ++i != params.size()) continue;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"only_key", currentParam);
            List entities = this.saleGoalMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)entities)) {
                exsits.addAll(entities);
            }
            currentParam.clear();
        }
        if (!CollectionUtils.isEmpty(exsits)) {
            StringBuilder stb = new StringBuilder();
            for (SaleGoalEntity entity : exsits) {
                if (SaleGoalEunm.ObjectType.CUSTOMER.getCode().equals(objectType)) {
                    stb.append(entity.getCusName()).append("-");
                } else if (SaleGoalEunm.ObjectType.ORGANIZATION.getCode().equals(objectType)) {
                    stb.append(entity.getOrgName()).append("-");
                } else if (SaleGoalEunm.ObjectType.TERMINAL.getCode().equals(objectType)) {
                    stb.append(entity.getTerminalName()).append("-");
                }
                if (type2.intValue() == SaleGoalEunm.goalType.GOODS.getCode().intValue()) {
                    stb.append(entity.getGoodsName()).append("-").append(entity.getTargetYear()).append(";");
                    continue;
                }
                if (type2.intValue() == SaleGoalEunm.goalType.PRODUCTLQVEL.getCode().intValue()) {
                    stb.append(entity.getProductLevelName()).append("-").append(entity.getTargetYear()).append(";");
                    continue;
                }
                stb.append(entity.getTargetYear()).append(";");
            }
            StringBuilder msgPre = new StringBuilder("\u9500\u91cf\u76ee\u6807\u5df2\u7ecf\u5b58\u5728,\u5e74\u4efd\u4e3a\uff1a");
            if (type2.intValue() != SaleGoalEunm.goalType.ROUTINE.getCode().intValue()) {
                msgPre = new StringBuilder("\u9500\u91cf\u76ee\u6807\u5df2\u7ecf\u5b58\u5728,\u4ea7\u54c1/\u4ea7\u54c1\u5c42\u7ea7\u548c\u5e74\u4efd\u4e3a: ");
            }
            throw new BusinessException(msgPre.append((CharSequence)stb).toString());
        }
    }

    @Override
    @Transactional
    public void edit(SaleGoalVo saleGoalVo) {
        ValidateUtils.validate((Object)saleGoalVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807!");
        SaleGoalEntity entity = (SaleGoalEntity)((Object)this.saleGoalMapper.selectById((Serializable)((Object)saleGoalVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        entity.setTargetNum(SaleGoalItemUtil.sumSingleItem(saleGoalVo.getSaleGoalItemVo()).getYearlySum());
        entity.setName(saleGoalVo.getName());
        this.saleGoalMapper.updateById((Object)entity);
        this.saleGoalItemService.update(saleGoalVo.getSaleGoalItemVo());
    }

    @Override
    @CrmDictMethod
    public SaleGoalVo findById(String id) {
        SaleGoalVo vo = null;
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u9500\u552e\u76ee\u6807\uff01");
        SaleGoalEntity entity = (SaleGoalEntity)((Object)this.saleGoalMapper.selectById((Serializable)((Object)id)));
        if (null == entity) {
            return vo;
        }
        vo = new SaleGoalVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
        vo.setSaleGoalItemVo(this.saleGoalItemService.findBySaleGoalId(vo.getId()));
        return vo;
    }

    @Override
    @CrmDictMethod
    public PageResult<SaleGoalVo> list(SaleGoalVo saleGoalVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)saleGoalVo.getCusName()), (Object)"cus_name", (Object)saleGoalVo.getCusName())).like(!StringUtils.isEmpty((Object)saleGoalVo.getCusCode()), (Object)"cus_code", (Object)saleGoalVo.getCusCode())).like(!StringUtils.isEmpty((Object)saleGoalVo.getCusOrgName()), (Object)"cus_org_name", (Object)saleGoalVo.getCusOrgName())).like(!StringUtils.isEmpty((Object)saleGoalVo.getCusOrgCode()), (Object)"cus_org_code", (Object)saleGoalVo.getCusOrgCode())).like(!StringUtils.isEmpty((Object)saleGoalVo.getCusChannelName()), (Object)"cus_channel_name", (Object)saleGoalVo.getCusChannelName())).eq(!StringUtils.isEmpty((Object)saleGoalVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)saleGoalVo.getCusChannelCode())).eq(null != saleGoalVo.getType(), (Object)"type", (Object)saleGoalVo.getType())).eq(null != saleGoalVo.getTargetYear(), (Object)"target_year", (Object)saleGoalVo.getTargetYear())).eq(!StringUtils.isEmpty((Object)saleGoalVo.getName()), (Object)"name", (Object)saleGoalVo.getName())).like(!StringUtils.isEmpty((Object)saleGoalVo.getGoodsName()), (Object)"goods_name", (Object)saleGoalVo.getGoodsName())).eq(!StringUtils.isEmpty((Object)saleGoalVo.getGoodsCode()), (Object)"goods_code", (Object)saleGoalVo.getGoodsCode())).like(!StringUtils.isEmpty((Object)saleGoalVo.getProductLevelName()), (Object)"product_level_name", (Object)saleGoalVo.getProductLevelName())).eq(!StringUtils.isEmpty((Object)saleGoalVo.getProductLevelCode()), (Object)"product_level_code", (Object)saleGoalVo.getProductLevelCode())).like(!StringUtils.isEmpty((Object)saleGoalVo.getOrgCode()), (Object)"org_code", (Object)saleGoalVo.getOrgCode())).like(!StringUtils.isEmpty((Object)saleGoalVo.getOrgName()), (Object)"org_name", (Object)saleGoalVo.getOrgName())).eq(!Objects.isNull(saleGoalVo.getObjectType()), (Object)"object_type", (Object)saleGoalVo.getObjectType())).eq(!Objects.isNull(saleGoalVo.getTaskType()), (Object)"task_type", (Object)saleGoalVo.getTaskType())).like(!StringUtils.isEmpty((Object)saleGoalVo.getTerminalCode()), (Object)"terminal_code", (Object)saleGoalVo.getTerminalCode())).like(!StringUtils.isEmpty((Object)saleGoalVo.getTerminalName()), (Object)"terminal_name", (Object)saleGoalVo.getTerminalName())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)saleGoalVo.getPageNum(), (Integer)saleGoalVo.getPageSize());
        List<SaleGoalVo> list = this.saleGoalMapper.list(page, (QueryWrapper<SaleGoalVo>)wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, SaleGoalItemVo> detailMap = this.saleGoalItemService.findBySaleGoalIds(list.stream().map(UuidVo::getId).collect(Collectors.toList()));
            for (SaleGoalVo vo : list) {
                vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
                vo.setSaleGoalItemVo(detailMap.get(vo.getId()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.saleGoalMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional
    public void delByParam(SaleGoalVo saleGoalVo) {
        if (null == saleGoalVo) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6!");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)saleGoalVo.getCusName()), (Object)"cus_name", (Object)saleGoalVo.getCusName())).eq(!StringUtils.isEmpty((Object)saleGoalVo.getCusCode()), (Object)"cus_code", (Object)saleGoalVo.getCusCode())).like(!StringUtils.isEmpty((Object)saleGoalVo.getCusOrgName()), (Object)"cus_org_name", (Object)saleGoalVo.getCusOrgName())).eq(!StringUtils.isEmpty((Object)saleGoalVo.getCusOrgCode()), (Object)"cus_org_code", (Object)saleGoalVo.getCusOrgCode())).like(!StringUtils.isEmpty((Object)saleGoalVo.getCusChannelName()), (Object)"cus_channel_name", (Object)saleGoalVo.getCusChannelName())).eq(!StringUtils.isEmpty((Object)saleGoalVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)saleGoalVo.getCusChannelCode())).eq(null != saleGoalVo.getType(), (Object)"type", (Object)saleGoalVo.getType())).eq(null != saleGoalVo.getTargetYear(), (Object)"target_year", (Object)saleGoalVo.getTargetYear())).like(!StringUtils.isEmpty((Object)saleGoalVo.getGoodsName()), (Object)"goods_name", (Object)saleGoalVo.getGoodsName())).eq(!StringUtils.isEmpty((Object)saleGoalVo.getGoodsCode()), (Object)"goods_code", (Object)saleGoalVo.getGoodsCode())).like(!StringUtils.isEmpty((Object)saleGoalVo.getProductLevelName()), (Object)"product_level_name", (Object)saleGoalVo.getProductLevelName())).eq(!StringUtils.isEmpty((Object)saleGoalVo.getProductLevelCode()), (Object)"product_level_code", (Object)saleGoalVo.getProductLevelCode());
        this.saleGoalMapper.delete((Wrapper)wrapper);
    }
}

