/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salegoal.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.dms.SaleGoalEunm;
import com.biz.crm.nebular.dms.salegoal.SaleGoalVo;
import com.biz.crm.salegoal.entity.SaleGoalEntity;
import com.biz.crm.salegoal.utils.SaleGoalItemUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class SaleGoalUtil {
    private static final Map<Integer, List<String>> OBJECT_TYPE_FILED_MAP = Maps.newHashMap();
    private static final Map<Integer, List<String>> GOAL_TYPE_FILED_MAP = Maps.newHashMap();

    public static void validateAddParam(SaleGoalVo saleGoalVo) {
        ValidateUtils.validate((Object)saleGoalVo.getTargetYear(), (String)"\u76ee\u6807\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)saleGoalVo.getType(), (String)"\u9500\u91cf\u76ee\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        if (saleGoalVo.getType().intValue() == SaleGoalEunm.goalType.PRODUCTLQVEL.getCode().intValue()) {
            ValidateUtils.validate((Object)saleGoalVo.getProductLevelCode(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)saleGoalVo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (saleGoalVo.getType().intValue() == SaleGoalEunm.goalType.GOODS.getCode().intValue()) {
            ValidateUtils.validate((Object)saleGoalVo.getGoodsCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)saleGoalVo.getGoodsName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    public static void validateParamForAddBatch(List<SaleGoalVo> saleGoalVos) {
        if (CollectionUtils.isEmpty(saleGoalVos)) {
            return;
        }
        Integer type2 = saleGoalVos.get(0).getType();
        if (!CollectionUtils.isEmpty((Collection)saleGoalVos.stream().filter(vo -> type2.intValue() != vo.getType().intValue()).collect(Collectors.toList()))) {
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u8de8\u76ee\u6807\u7c7b\u578b\u6279\u91cf\u64cd\u4f5c\uff01");
        }
        Set objectTypes = saleGoalVos.stream().map(SaleGoalVo::getObjectType).collect(Collectors.toSet());
        ValidateUtils.isTrue((objectTypes.size() == 1 ? 1 : 0) != 0, (String)"\u6682\u65f6\u4ec5\u652f\u6301\u540c\u4e00\u4e2a\u5bf9\u8c61\u7ef4\u5ea6\u6279\u91cf\u64cd\u4f5c", (Object[])new Object[0]);
        switch (SaleGoalEunm.getObjectTypeByCode((Integer)((Integer)objectTypes.iterator().next()))) {
            case CUSTOMER: {
                Set cusCodes = saleGoalVos.stream().map(SaleGoalVo::getCusCode).collect(Collectors.toSet());
                ValidateUtils.isTrue((cusCodes.size() == 1 ? 1 : 0) != 0, (String)"\u6682\u65f6\u4ec5\u652f\u6301\u540c\u4e00\u5ba2\u6237\u6279\u91cf\u64cd\u4f5c", (Object[])new Object[0]);
                ValidateUtils.validate(cusCodes.iterator().next(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case ORGANIZATION: {
                Set orgCodes = saleGoalVos.stream().map(SaleGoalVo::getOrgCode).collect(Collectors.toSet());
                ValidateUtils.isTrue((orgCodes.size() == 1 ? 1 : 0) != 0, (String)"\u6682\u65f6\u4ec5\u652f\u6301\u540c\u4e00\u7ec4\u7ec7\u6279\u91cf\u64cd\u4f5c", (Object[])new Object[0]);
                ValidateUtils.validate(orgCodes.iterator().next(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case TERMINAL: {
                Set terminalCodes = saleGoalVos.stream().map(SaleGoalVo::getTerminalCode).collect(Collectors.toSet());
                ValidateUtils.isTrue((terminalCodes.size() == 1 ? 1 : 0) != 0, (String)"\u6682\u65f6\u4ec5\u652f\u6301\u540c\u4e00\u7ec4\u7ec7\u6279\u91cf\u64cd\u4f5c", (Object[])new Object[0]);
                ValidateUtils.validate(terminalCodes.iterator().next(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        for (SaleGoalVo vo2 : saleGoalVos) {
            SaleGoalUtil.validateAddParam(vo2);
        }
        HashMap<String, String> map = new HashMap<String, String>(saleGoalVos.size());
        for (SaleGoalVo vo3 : saleGoalVos) {
            String key = "";
            String repeat = "";
            if (vo3.getType().intValue() == SaleGoalEunm.goalType.GOODS.getCode().intValue()) {
                key = vo3.getGoodsCode() + vo3.getTargetYear();
                repeat = vo3.getGoodsName();
            } else if (vo3.getType().intValue() == SaleGoalEunm.goalType.PRODUCTLQVEL.getCode().intValue()) {
                key = vo3.getProductLevelCode() + vo3.getTargetYear();
                repeat = vo3.getProductLevelName();
            } else {
                key = vo3.getTargetYear().toString();
            }
            if (map.get(key) != null) {
                StringBuilder msg = new StringBuilder("\u76ee\u6807\u91cd\u590d");
                if (!StringUtils.isEmpty((String)repeat)) {
                    msg.append(",\u4ea7\u54c1/\u4ea7\u54c1\u5c42\u7ea7:").append(repeat);
                }
                msg.append(",\u76ee\u6807\u5e74\u4efd:").append(vo3.getTargetYear());
                throw new BusinessException(msg.toString());
            }
            map.put(key, key);
        }
    }

    public static SaleGoalEntity packageEntityForAdd(SaleGoalVo vo) {
        SaleGoalEntity entity = new SaleGoalEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
        entity.setId(UUIDGenerator.generate());
        if (vo.getType().intValue() == SaleGoalEunm.goalType.PRODUCTLQVEL.getCode().intValue()) {
            entity.setGoodsCode(null);
            entity.setGoodsName(null);
            entity.setProductSpec(null);
            entity.setOnlyKey(vo.getProductLevelCode() + "," + vo.getTargetYear());
        }
        if (vo.getType().intValue() == SaleGoalEunm.goalType.ROUTINE.getCode().intValue()) {
            entity.setGoodsCode(null);
            entity.setGoodsName(null);
            entity.setProductSpec(null);
            entity.setProductLevelCode(null);
            entity.setProductLevelName(null);
            entity.setOnlyKey(vo.getTargetYear().toString());
        }
        if (vo.getType().intValue() == SaleGoalEunm.goalType.GOODS.getCode().intValue()) {
            entity.setOnlyKey(vo.getGoodsCode() + "," + vo.getTargetYear());
        }
        entity.setTargetNum(SaleGoalItemUtil.sumSingleItem(vo.getSaleGoalItemVo()).getYearlySum());
        return entity;
    }

    public static void buildOnlyKey(List<SaleGoalVo> saleGoalVos) {
        if (CollectionUtil.listEmpty(saleGoalVos)) {
            return;
        }
        saleGoalVos.forEach(sale -> SaleGoalUtil.buildOnlyKey(sale));
    }

    private static void buildOnlyKey(SaleGoalVo sale) {
        if (sale == null) {
            return;
        }
        ArrayList filedNames = Lists.newArrayList();
        filedNames.addAll((Collection)OBJECT_TYPE_FILED_MAP.get(sale.getObjectType()));
        filedNames.addAll((Collection)GOAL_TYPE_FILED_MAP.get(sale.getType()));
        filedNames.add("targetYear");
        Map<String, Object> valueMap = FieldHandleUtil.fieldsValue(sale, filedNames.toArray(new String[filedNames.size()]));
        Collection<Object> valueList = valueMap.values();
        String onlyKey = String.join((CharSequence)",", valueList.toArray(new String[valueList.size()]));
        sale.setOnlyKey(onlyKey);
    }

    static {
        ArrayList fieldList = Lists.newArrayList((Object[])new String[]{"cusCode"});
        OBJECT_TYPE_FILED_MAP.put(SaleGoalEunm.ObjectType.CUSTOMER.getCode(), fieldList);
        fieldList = Lists.newArrayList((Object[])new String[]{"orgCode"});
        OBJECT_TYPE_FILED_MAP.put(SaleGoalEunm.ObjectType.ORGANIZATION.getCode(), fieldList);
        fieldList = Lists.newArrayList((Object[])new String[]{"terminalCode"});
        OBJECT_TYPE_FILED_MAP.put(SaleGoalEunm.ObjectType.TERMINAL.getCode(), fieldList);
        GOAL_TYPE_FILED_MAP.put(SaleGoalEunm.goalType.ROUTINE.getCode(), Lists.newArrayList());
        fieldList = Lists.newArrayList((Object[])new String[]{"goodsCode"});
        GOAL_TYPE_FILED_MAP.put(SaleGoalEunm.goalType.GOODS.getCode(), fieldList);
        fieldList = Lists.newArrayList((Object[])new String[]{"productLevelCode"});
        GOAL_TYPE_FILED_MAP.put(SaleGoalEunm.goalType.PRODUCTLQVEL.getCode(), fieldList);
    }
}

