/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salegoal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.salegoal.SaleGoalItemVo;
import com.biz.crm.salegoal.entity.SaleGoalItemEntity;
import com.biz.crm.salegoal.mapper.SaleGoalItemMapper;
import com.biz.crm.salegoal.service.SaleGoalItemService;
import com.biz.crm.salegoal.utils.SaleGoalItemUtil;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"saleGoalItemServiceImpl"})
@Service(value="saleGoalItemService")
public class SaleGoalItemServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SaleGoalItemMapper, SaleGoalItemEntity>
implements SaleGoalItemService {
    @Resource
    private SaleGoalItemMapper saleGoalItemMapper;

    @Override
    public void addBatch(List<SaleGoalItemVo> saleGoalItemVos) {
        if (CollectionUtils.isEmpty(saleGoalItemVos)) {
            return;
        }
        ArrayList<SaleGoalItemEntity> entities = new ArrayList<SaleGoalItemEntity>(saleGoalItemVos.size());
        for (SaleGoalItemVo vo : saleGoalItemVos) {
            if (vo == null) {
                throw new BusinessException("\u6708\u76ee\u6807\u8be6\u60c5\u5fc5\u586b\uff01");
            }
            entities.add(SaleGoalItemUtil.packageEntityForAddBatch(vo));
        }
        this.saveBatch(entities);
    }

    @Override
    public void update(SaleGoalItemVo saleGoalItemVo) {
        ValidateUtils.validate((Object)saleGoalItemVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807\u660e\u7ec6!");
        SaleGoalItemEntity entity = (SaleGoalItemEntity)((Object)this.saleGoalItemMapper.selectById((Serializable)((Object)saleGoalItemVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807\u660e\u7ec6\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        SaleGoalItemEntity currentEntity = SaleGoalItemUtil.packageEntityForUpdate(saleGoalItemVo);
        this.saleGoalItemMapper.updateById((Object)currentEntity);
    }

    @Override
    public SaleGoalItemVo findBySaleGoalId(String salesTargetId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"sale_goal_id", (Object)salesTargetId);
        List saleGoalItemEntityList = this.saleGoalItemMapper.selectList((Wrapper)wrapper);
        SaleGoalItemVo vo = new SaleGoalItemVo();
        BeanUtils.copyProperties(saleGoalItemEntityList.get(0), (Object)vo);
        SaleGoalItemUtil.salesTargetToStr(vo);
        return vo;
    }

    @Override
    public Map<String, SaleGoalItemVo> findBySaleGoalIds(List<String> saleGoalIds) {
        HashMap<String, SaleGoalItemVo> reMap = new HashMap<String, SaleGoalItemVo>();
        if (CollectionUtils.isEmpty(saleGoalIds)) {
            return reMap;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"sale_goal_id", saleGoalIds);
        List monthTargetEntities = this.saleGoalItemMapper.selectList((Wrapper)wrapper);
        Map<Object, Object> entityMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)monthTargetEntities)) {
            entityMap = monthTargetEntities.stream().collect(Collectors.toMap(SaleGoalItemEntity::getSaleGoalId, a -> a, (k1, k2) -> k1));
        }
        for (String str : saleGoalIds) {
            SaleGoalItemVo vo = null;
            SaleGoalItemEntity entity = (SaleGoalItemEntity)((Object)entityMap.get(str));
            if (null != entity) {
                vo = new SaleGoalItemVo();
                BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            }
            reMap.put(str, vo);
        }
        return reMap;
    }
}

