/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablegoods.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablegoods.entity.AvailableGoodsEntity;
import com.biz.crm.availablegoods.mapper.AvailableGoodsMapper;
import com.biz.crm.availablegoods.service.AvailableGoodsService;
import com.biz.crm.nebular.dms.availablegoods.AvailableGoodsListVo;
import com.biz.crm.nebular.dms.availablegoods.AvailableGoodsVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="availableGoodsService")
@ConditionalOnMissingBean(name={"availableGoodsServiceImpl"})
public class AvailableGoodsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<AvailableGoodsMapper, AvailableGoodsEntity>
implements AvailableGoodsService {
    @Resource
    private AvailableGoodsMapper goodsMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AvailableGoodsListVo replace(AvailableGoodsListVo voList) {
        this.validateReplace(voList);
        String saleContractCode = voList.getSaleContractCode();
        this.goodsMapper.delete((Wrapper)new QueryWrapper().eq((Object)"sale_contract_code", (Object)saleContractCode));
        voList.getVoList().forEach(goodsVo -> {
            AvailableGoodsEntity entity = (AvailableGoodsEntity)((Object)((Object)CrmBeanUtil.copy((Object)goodsVo, AvailableGoodsEntity.class)));
            entity.setSaleContractCode(saleContractCode);
            boolean addResult = this.save((Object)entity);
            ValidateUtils.isTrue((boolean)addResult, (String)"\u64cd\u4f5c\u5931\u8d25", (Object[])new Object[0]);
        });
        return voList;
    }

    @Override
    public AvailableGoodsListVo listAvailableGoods(AvailableGoodsListVo voList) {
        this.validateReplace(voList);
        String saleContractCode = voList.getSaleContractCode();
        List goodsEntityList = this.goodsMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"sale_contract_code", (Object)saleContractCode));
        ArrayList goodsVoList = new ArrayList(goodsEntityList.size());
        goodsEntityList.forEach(entity -> {
            AvailableGoodsVo vo = (AvailableGoodsVo)CrmBeanUtil.copy((Object)entity, AvailableGoodsVo.class);
            goodsVoList.add(vo);
        });
        voList.setVoList(goodsVoList);
        return voList;
    }

    private void validateReplace(AvailableGoodsListVo voList) {
        ValidateUtils.validate((Object)voList, (String)"\u53ef\u8d2d\u5546\u54c1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)voList.getSaleContractCode(), (String)"\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

