/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salecontract.ContractTemplateVo;
import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import com.biz.crm.salecontract.entity.ContractTemplateEntity;
import com.biz.crm.salecontract.mapper.ContractTemplateMapper;
import com.biz.crm.salecontract.service.ContractTemplateService;
import com.biz.crm.salecontract.service.ContractTemplateTupleMappingService;
import com.biz.crm.salecontract.util.ContractTemplateUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"contractTemplateServiceImpl"})
@Service(value="contractTemplateService")
public class ContractTemplateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ContractTemplateMapper, ContractTemplateEntity>
implements ContractTemplateService {
    @Resource
    private ContractTemplateMapper contractTemplateMapper;
    @Resource
    private ContractTemplateTupleMappingService contractTemplateTupleMappingService;

    @Override
    @Transactional
    public ContractTemplateVo add(ContractTemplateVo contractTemplateVo) {
        ContractTemplateUtil.validateAdd(contractTemplateVo);
        contractTemplateVo.setCode(CodeUtil.generateCode());
        ContractTemplateEntity entity = (ContractTemplateEntity)((Object)CrmBeanUtil.copy((Object)contractTemplateVo, ContractTemplateEntity.class));
        this.contractTemplateMapper.insert((Object)entity);
        contractTemplateVo.setId(entity.getId());
        this.contractTemplateTupleMappingService.replace(contractTemplateVo.getTuples(), contractTemplateVo.getCode());
        return contractTemplateVo;
    }

    @Override
    @Transactional
    public ContractTemplateVo edit(ContractTemplateVo contractTemplateVo) {
        ContractTemplateUtil.validateEdit(contractTemplateVo);
        ContractTemplateEntity entity = (ContractTemplateEntity)((Object)CrmBeanUtil.copy((Object)contractTemplateVo, ContractTemplateEntity.class));
        boolean editResult = this.updateById((Object)entity);
        ValidateUtils.isTrue((boolean)editResult, (String)"\u7f16\u8f91\u6a21\u677f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5id\u662f\u5426\u6b63\u786e\u4f20\u5165", (Object[])new Object[0]);
        this.contractTemplateTupleMappingService.replace(contractTemplateVo.getTuples(), contractTemplateVo.getCode());
        return contractTemplateVo;
    }

    @Override
    public ContractTemplateVo findByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)code);
        ContractTemplateEntity entity = (ContractTemplateEntity)((Object)this.contractTemplateMapper.selectOne((Wrapper)wrapper));
        return (ContractTemplateVo)CrmBeanUtil.copy((Object)((Object)entity), ContractTemplateVo.class);
    }

    @Override
    public PageResult<ContractTemplateVo> findPageByConditions(ContractTemplateVo contractTemplateVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!Objects.isNull(contractTemplateVo.getContractType()), (Object)"contract_type", (Object)contractTemplateVo.getContractType())).like(StringUtils.isNotEmpty((String)contractTemplateVo.getName()), (Object)"name", (Object)contractTemplateVo.getName())).like(StringUtils.isNotEmpty((String)contractTemplateVo.getEnableStatus()), (Object)"enable_status", (Object)contractTemplateVo.getEnableStatus())).like(StringUtils.isNotEmpty((String)contractTemplateVo.getOrgCode()), (Object)"org_code", (Object)contractTemplateVo.getOrgCode())).like(StringUtils.isNotEmpty((String)contractTemplateVo.getOrgName()), (Object)"org_name", (Object)contractTemplateVo.getOrgName());
        Page page = new Page((long)contractTemplateVo.getPageNum().intValue(), (long)contractTemplateVo.getPageSize().intValue());
        List<ContractTemplateVo> pageList = this.contractTemplateMapper.findPageByConditions((Page<ContractTemplateVo>)page, wrapper);
        return PageResult.builder().data(pageList).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public ContractTemplateVo findDetailsByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)code);
        ContractTemplateEntity entity = (ContractTemplateEntity)((Object)this.getOne((Wrapper)wrapper));
        ContractTemplateVo vo = (ContractTemplateVo)CrmBeanUtil.copy((Object)((Object)entity), ContractTemplateVo.class);
        if (vo == null) {
            return null;
        }
        List<ContractTupleVo> tupleVos = this.contractTemplateTupleMappingService.findTupleByTemplateCode(code);
        vo.setTuples(tupleVos);
        return vo;
    }
}

