/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.NoticeEunm;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.dms.notice.ListReq;
import com.biz.crm.nebular.dms.notice.ListRes;
import com.biz.crm.nebular.dms.notice.NoticeAreaVo;
import com.biz.crm.nebular.dms.notice.NoticeFileVo;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.notice.entity.NoticeEntity;
import com.biz.crm.notice.mapper.NoticeMapper;
import com.biz.crm.notice.service.NoticeAreaService;
import com.biz.crm.notice.service.NoticeFileService;
import com.biz.crm.notice.service.NoticeService;
import com.biz.crm.notice.utils.NoticeAreaUtil;
import com.biz.crm.notice.utils.NoticeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.TimeUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"noticeServiceExpandImpl"})
@Service(value="noticeService")
public class NoticeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<NoticeMapper, NoticeEntity>
implements NoticeService {
    @Autowired
    private NoticeMapper noticeMapper;
    @Resource
    private NoticeFileService noticeFileService;
    @Resource
    private NoticeAreaService noticeAreaService;
    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Override
    @Transactional
    public void add(NoticeVo noticeVo) {
        ValidateUtils.validate((Object)noticeVo.getTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)noticeVo.getType(), (String)"\u8bf7\u6307\u5b9a\u7c7b\u578b!");
        ValidateUtils.validate((Object)noticeVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5!");
        ValidateUtils.validate((Object)noticeVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5!");
        NoticeEntity entity = new NoticeEntity();
        BeanUtils.copyProperties((Object)noticeVo, (Object)((Object)entity));
        UserRedis userRedis = UserUtils.getUser();
        entity.setPublishOrgCode(userRedis.getOrgcode());
        entity.setPublishOrgName(userRedis.getOrgname());
        entity.setVisitNum(0);
        this.noticeMapper.insert((Object)entity);
        this.noticeFileService.replace(entity, noticeVo.getFiles());
        this.noticeAreaService.replace(entity, NoticeAreaUtil.addAllAreas(noticeVo));
    }

    @Override
    @Transactional
    public void edit(NoticeVo noticeVo) {
        ValidateUtils.validate((Object)noticeVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u8d44\u6599!");
        ValidateUtils.validate((Object)noticeVo.getTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)noticeVo.getType(), (String)"\u8bf7\u6307\u5b9a\u7c7b\u578b!");
        ValidateUtils.validate((Object)noticeVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5!");
        ValidateUtils.validate((Object)noticeVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5!");
        NoticeEntity entity = (NoticeEntity)((Object)this.noticeMapper.selectById((Serializable)((Object)noticeVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        BeanUtils.copyProperties((Object)noticeVo, (Object)((Object)entity));
        UserRedis userRedis = UserUtils.getUser();
        entity.setPublishOrgCode(userRedis.getOrgcode());
        entity.setPublishOrgName(userRedis.getOrgname());
        this.noticeMapper.updateById((Object)entity);
        this.noticeFileService.replace(entity, noticeVo.getFiles());
        this.noticeAreaService.replace(entity, NoticeAreaUtil.addAllAreas(noticeVo));
    }

    @Override
    @CrmDictMethod
    public NoticeVo findById(String id) {
        NoticeVo vo = null;
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u8d44\u6599\uff01");
        NoticeEntity entity = (NoticeEntity)((Object)this.noticeMapper.selectById((Serializable)((Object)id)));
        if (null == entity) {
            return vo;
        }
        vo = new NoticeVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setFiles(this.noticeFileService.findByNoticeId(id));
        Map<String, List<NoticeAreaVo>> areaMap = NoticeAreaUtil.distArea(this.noticeAreaService.findByNoticeId(id));
        vo.setOrgs(areaMap.get("org"));
        vo.setNonOrgs(areaMap.get("nonOrg"));
        vo.setCustomers(areaMap.get("customer"));
        vo.setNonCustomers(areaMap.get("nonCustomer"));
        vo.setNoticeState(Integer.valueOf(NoticeUtil.transState(vo.getStartTime(), vo.getEndTime())));
        return vo;
    }

    @Override
    @CrmDictMethod
    public PageResult<NoticeVo> list(NoticeVo noticeVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)noticeVo.getTitle()), (Object)"title", (Object)noticeVo.getTitle())).eq(null != noticeVo.getType(), (Object)"type", (Object)noticeVo.getType())).eq(!StringUtils.isEmpty((Object)noticeVo.getPublishOrgCode()), (Object)"publish_org_code", (Object)noticeVo.getPublishOrgCode())).like(!StringUtils.isEmpty((Object)noticeVo.getPublishOrgName()), (Object)"publish_org_name", (Object)noticeVo.getPublishOrgName());
        if (null != noticeVo.getNoticeState()) {
            String now = DateUtil.date2Str((Date)DateUtil.getDate(), (SimpleDateFormat)DateUtil.datetimeFormat);
            if (noticeVo.getNoticeState().intValue() == NoticeEunm.NoticeStateEunm.TOBEGIN.getCode().intValue()) {
                wrapper.gt((Object)"start_time", (Object)now);
            } else if (noticeVo.getNoticeState().intValue() == NoticeEunm.NoticeStateEunm.ONGOING.getCode().intValue()) {
                wrapper.lt((Object)"start_time", (Object)now);
                wrapper.gt((Object)"end_time", (Object)now);
            } else {
                wrapper.lt((Object)"end_time", (Object)now);
            }
        }
        wrapper.orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)noticeVo.getPageNum(), (Integer)noticeVo.getPageSize());
        List<NoticeVo> list = this.noticeMapper.list(page, (QueryWrapper<NoticeVo>)wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            for (NoticeVo vo : list) {
                vo.setNoticeState(Integer.valueOf(NoticeUtil.transState(vo.getStartTime(), vo.getEndTime())));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public PageResult<ListRes> listByUser(ListReq listReq, List<String> orgCodes) {
        List<ListRes> list;
        Page page = PageUtil.buildPage((Integer)listReq.getPageNum(), (Integer)listReq.getPageSize());
        List<String> orgList = this.findParentOrgs(orgCodes);
        if (!CollectionUtil.listEmpty(orgCodes) && !CollectionUtil.listEmpty(orgList)) {
            orgList.addAll(orgCodes);
        }
        if (!CollectionUtils.isEmpty(list = this.noticeMapper.listByUser(page, listReq, DateUtil.getDate((String)"yyyy-MM-dd"), YesNoEnum.YesNoCodeNumberEnum.NO.getCode(), YesNoEnum.YesNoCodeNumberEnum.YES.getCode(), YesNoEnum.YesNoCodeNumberEnum.NO.getCode(), orgList))) {
            Map<String, List<NoticeFileVo>> fileMap = this.noticeFileService.findByNoticeIds(list.stream().map(UuidVo::getId).collect(Collectors.toList()));
            for (ListRes listRes : list) {
                listRes.setNoticeState(Integer.valueOf(NoticeUtil.transState(listRes.getStartTime(), listRes.getEndTime())));
                listRes.setMsgState(Integer.valueOf(StringUtils.isEmpty((Object)listRes.getNoticeLogId()) ? 0 : 1));
                listRes.setFiles(fileMap.get(listRes.getId()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private List<String> findParentOrgs(List<String> orgCodes) {
        if (CollectionUtil.listEmpty(orgCodes)) {
            return Lists.newArrayList();
        }
        ArrayList orgList = Lists.newArrayList();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        orgCodes.forEach(code -> {
            mdmOrgReqVo.setOrgCode(code);
            List parentList = (List)this.mdmOrgFeign.findAllParentOrgList(mdmOrgReqVo).getResult();
            if (!CollectionUtil.listEmpty((List)parentList)) {
                parentList.forEach(parent -> orgList.add(parent.getOrgCode()));
            }
        });
        return orgList;
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ids.forEach(id -> {
            NoticeVo vo = this.findById((String)id);
            ValidateUtils.validate((Object)vo, (String)"\u5220\u9664\u516c\u544a\u3010%s\u3011\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55", (Object[])new Object[]{id});
            this.validateTime(vo);
        });
        this.noticeMapper.deleteBatchIds(ids);
        this.noticeFileService.delByNoticeIds(ids);
        this.noticeAreaService.delByNoticeIds(ids);
    }

    private void validateTime(NoticeVo vo) {
        if (StringUtils.isEmpty((Object)vo.getStartTime()) || StringUtils.isEmpty((Object)vo.getEndTime())) {
            return;
        }
        try {
            Date startTime = DateUtils.parseDate((String)vo.getStartTime(), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"});
            ValidateUtils.isTrue((boolean)TimeUtil.bigThan(startTime, new Date()), (String)"\u8fdb\u884c\u4e2d\u548c\u5df2\u7ed3\u675f\u7684\u516c\u544a\u3010%s\u3011\u4e0d\u53ef\u5220\u9664", (Object[])new Object[]{vo.getTitle()});
        }
        catch (ParseException e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void delByParam(NoticeVo noticeVo) {
        if (null == noticeVo) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6!");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)noticeVo.getTitle()), (Object)"title", (Object)noticeVo.getTitle())).eq(null != noticeVo.getType(), (Object)"type", (Object)noticeVo.getType())).eq(!StringUtils.isEmpty((Object)noticeVo.getPublishOrgCode()), (Object)"publish_org_code", (Object)noticeVo.getPublishOrgCode());
        List entities = this.noticeMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        List<String> ids = entities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        this.noticeMapper.delete((Wrapper)wrapper);
        this.noticeFileService.delByNoticeIds(ids);
        this.noticeAreaService.delByNoticeIds(ids);
    }

    @Override
    @Klock(keys={"NOTICELOGLOCK", "#noticeId"}, waitTime=10L, leaseTime=5L)
    @Transactional
    public void updateVisitNum(String noticeId) {
        NoticeEntity entity = (NoticeEntity)((Object)this.noticeMapper.selectById((Serializable)((Object)noticeId)));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u8be5\u516c\u544a\u5df2\u88ab\u5220\u9664!");
        entity.setVisitNum(entity.getVisitNum() + 1);
        this.noticeMapper.updateById((Object)entity);
    }
}

