/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleSelectionVo;
import com.biz.crm.promotion.entity.PromotionPolicyEntity;
import com.biz.crm.promotion.entity.PromotionPolicyTemplateEntity;
import com.biz.crm.promotion.entity.PromotionPolicyTemplateRuleEntity;
import com.biz.crm.promotion.entity.PromotionRuleEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyTemplateMapper;
import com.biz.crm.promotion.mapper.PromotionPolicyTemplateRuleMapper;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.promotion.service.PromotionPolicyTemplateRuleService;
import com.biz.crm.promotion.service.PromotionPolicyTemplateService;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyTemplateServiceExpandImpl"})
@Service(value="promotionPolicyTemplateService")
public class PromotionPolicyTemplateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyTemplateMapper, PromotionPolicyTemplateEntity>
implements PromotionPolicyTemplateService {
    @Resource
    private PromotionPolicyTemplateMapper promotionPolicyTemplateMapper;
    @Resource
    private PromotionPolicyTemplateRuleService promotionPolicyTemplateRuleService;
    @Resource
    private PromotionPolicyTemplateRuleMapper promotionPolicyTemplateRuleMapper;
    @Resource
    private PromotionRuleService promotionRuleService;
    @Resource
    private PromotionPolicyService promotionPolicyService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    @Transactional
    public void addOrUpdate(PromotionPolicyTemplateEditVo vo) {
        this.checkParams(vo);
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"template_code", (Object)vo.getTemplateCode());
            if (this.promotionPolicyTemplateMapper.selectCount((Wrapper)wrapper) > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u6a21\u677f\u7f16\u7801[" + vo.getTemplateCode() + "]\u3002");
            }
            PromotionPolicyTemplateEntity newTemplate = (PromotionPolicyTemplateEntity)((Object)CrmBeanUtil.copy((Object)vo, PromotionPolicyTemplateEntity.class));
            this.promotionPolicyTemplateMapper.insert((Object)newTemplate);
            this.crmLogSendUtil.sendForAdd(ThreadLocalUtil.getObj((String)"menuCode").toString(), vo.getId(), null, (Object)vo);
            vo.setId(newTemplate.getId());
        } else {
            if (null == this.promotionPolicyTemplateMapper.selectById((Serializable)((Object)vo.getId()))) {
                throw new BusinessException("\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728,ID=[" + vo.getId() + "]");
            }
            PromotionPolicyTemplateEntity oldEntity = (PromotionPolicyTemplateEntity)((Object)this.getById((Serializable)((Object)vo.getId())));
            PromotionPolicyTemplateEditVo oldobj = (PromotionPolicyTemplateEditVo)CrmBeanUtil.copy((Object)((Object)oldEntity), PromotionPolicyTemplateEditVo.class);
            this.updateCheck(Lists.newArrayList((Object[])new String[]{vo.getTemplateCode()}));
            this.promotionPolicyTemplateMapper.updateById(CrmBeanUtil.copy((Object)vo, PromotionPolicyTemplateEntity.class));
            this.crmLogSendUtil.sendForUpdate(ThreadLocalUtil.getObj((String)"menuCode").toString(), vo.getId(), null, (Object)oldobj, (Object)vo);
        }
        this.refreshTemplateRule(vo);
    }

    @Override
    public PromotionPolicyTemplateEditVo loadTemplateEditVo(String templateId, String promotionType) {
        PromotionPolicyTemplateEditVo templateEditVo;
        if (StringUtils.isNotBlank((CharSequence)templateId)) {
            PromotionPolicyTemplateEntity entity = (PromotionPolicyTemplateEntity)((Object)this.promotionPolicyTemplateMapper.selectById((Serializable)((Object)templateId)));
            AssertUtils.isNotNull((Object)((Object)entity), (String)"\u672a\u52a0\u8f7d\u5230\u6a21\u677f\u6570\u636e");
            templateEditVo = (PromotionPolicyTemplateEditVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionPolicyTemplateEditVo.class);
        } else {
            AssertUtils.isNotEmpty((String)promotionType, (String)"\u8bf7\u6307\u5b9a\u6a21\u677f\u4fc3\u9500\u7c7b\u578b");
            templateEditVo = new PromotionPolicyTemplateEditVo();
            templateEditVo.setPromotionType(promotionType);
        }
        this.promotionRuleService.loadTemplateRuleGroupByRuleType(templateEditVo, true);
        return templateEditVo;
    }

    @Override
    public PromotionPolicyTemplateEditVo loadTemplateInfo(String templateId) {
        PromotionPolicyTemplateEntity entity = (PromotionPolicyTemplateEntity)((Object)this.promotionPolicyTemplateMapper.selectById((Serializable)((Object)templateId)));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u672a\u52a0\u8f7d\u5230\u6a21\u677f\u6570\u636e");
        PromotionPolicyTemplateEditVo templateEditVo = (PromotionPolicyTemplateEditVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionPolicyTemplateEditVo.class);
        this.promotionRuleService.loadTemplateRuleGroupByRuleType(templateEditVo, false);
        return templateEditVo;
    }

    private void refreshTemplateRule(PromotionPolicyTemplateEditVo vo) {
        Map<String, PromotionRuleEntity> ruleMapping;
        if (StringUtils.isNotBlank((CharSequence)vo.getTemplateCode())) {
            this.delTemplateRule(null, Lists.newArrayList((Object[])new String[]{vo.getTemplateCode()}));
        }
        if (null == (ruleMapping = this.loadPromotionRule(vo))) {
            return;
        }
        List<PromotionPolicyTemplateRuleEntity> templateRuleEntities = this.buildTemplateRuleEntitys(ruleMapping, vo);
        this.promotionPolicyTemplateRuleService.saveList(templateRuleEntities);
    }

    private List<PromotionPolicyTemplateRuleEntity> buildTemplateRuleEntitys(Map<String, PromotionRuleEntity> ruleMapping, PromotionPolicyTemplateEditVo vo) {
        List all = vo.takeAllRule();
        ArrayList templateRuleEntities = Lists.newArrayList();
        for (PromotionRuleSelectionVo ruleSelectionVo : all) {
            if (ruleMapping.containsKey(ruleSelectionVo.getId())) {
                PromotionRuleEntity promotionRuleEntity = ruleMapping.get(ruleSelectionVo.getId());
                PromotionPolicyTemplateRuleEntity temp = (PromotionPolicyTemplateRuleEntity)((Object)CrmBeanUtil.copy((Object)((Object)promotionRuleEntity), PromotionPolicyTemplateRuleEntity.class));
                temp.setPromotionRuleId(promotionRuleEntity.getId());
                temp.setPromotionPolicyTemplateId(vo.getId());
                temp.setPromotionPolicyTemplateCode(vo.getTemplateCode());
                temp.setRuleCode(promotionRuleEntity.getRuleCode());
                temp.setRuleType(promotionRuleEntity.getRuleType());
                temp.setPromotionType(promotionRuleEntity.getPromotionType());
                temp.setId(null);
                templateRuleEntities.add(temp);
                continue;
            }
            throw new BusinessException("\u89c4\u5219ID[" + ruleSelectionVo.getId() + "]\u4e0d\u5b58\u5728\u3002");
        }
        return templateRuleEntities;
    }

    private Map<String, PromotionRuleEntity> loadPromotionRule(PromotionPolicyTemplateEditVo vo) {
        List all = vo.takeAllRule();
        HashSet ids = Sets.newHashSet();
        if (null != all) {
            ids.addAll(all.stream().map(PromotionRuleSelectionVo::getId).collect(Collectors.toSet()));
        }
        if (ids.size() == 0) {
            return null;
        }
        return this.promotionRuleService.getListByIds(ids).stream().collect(Collectors.toMap(BaseIdEntity::getId, v -> v, (t, t2) -> t2));
    }

    @Override
    public PageResult<PromotionPolicyTemplateVo> getPageList(PromotionPolicyTemplateQueryVo vo) {
        Page page = PageUtil.buildPage((Integer)vo.getPageNum(), (Integer)vo.getPageSize());
        List<PromotionPolicyTemplateVo> list = this.promotionPolicyTemplateMapper.findList((Page<PromotionPolicyTemplateQueryVo>)page, vo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void del(List<String> templateIds) {
        this.updateCheck(templateIds);
        this.delTemplateRule(templateIds, null);
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", templateIds);
        for (String id : templateIds) {
            PromotionPolicyTemplateEntity promotionPolicyTemplateEntity = (PromotionPolicyTemplateEntity)((Object)this.getById((Serializable)((Object)id)));
            PromotionPolicyTemplateVo promotionPolicyTemplateVo = (PromotionPolicyTemplateVo)CrmBeanUtil.copy((Object)((Object)promotionPolicyTemplateEntity), PromotionPolicyTemplateVo.class);
            this.crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj((String)"menuCode").toString(), promotionPolicyTemplateVo.getId(), null, (Object)promotionPolicyTemplateVo);
        }
        this.promotionPolicyTemplateMapper.delete((Wrapper)wrapper);
    }

    private void delTemplateRule(List<String> templateIds, List<String> templateCodes) {
        QueryWrapper rulleWrapper = Wrappers.query();
        if (!CollectionUtils.isEmpty(templateIds)) {
            rulleWrapper.in((Object)"promotion_Policy_Template_id", templateIds);
        } else if (!CollectionUtils.isEmpty(templateCodes)) {
            rulleWrapper.in((Object)"promotion_Policy_Template_code", templateCodes);
        }
        this.promotionPolicyTemplateRuleMapper.delete((Wrapper)rulleWrapper);
    }

    @Override
    @Transactional
    public void enable(List<String> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return;
        }
        this.updateStatus(templateIds, CrmEnableStatusEnum.ENABLE);
    }

    private void updateStatus(List<String> templateIds, CrmEnableStatusEnum statusEnum) {
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", templateIds);
        PromotionPolicyTemplateEntity entity = new PromotionPolicyTemplateEntity();
        entity.setEnableStatus(statusEnum.getCode());
        this.promotionPolicyTemplateMapper.update((Object)entity, (Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void disable(List<String> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return;
        }
        this.updateStatus(templateIds, CrmEnableStatusEnum.DISABLE);
    }

    private void updateCheck(List<String> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return;
        }
        for (String templateId : templateIds) {
            List<PromotionPolicyEntity> list = this.promotionPolicyService.getListByTemplate(templateId, null);
            if (CollectionUtils.isEmpty(list)) continue;
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6a21\u677f[" + list.get(0).getTemplateCode() + "]\u5df2\u6709\u5173\u8054\u653f\u7b56");
        }
    }

    private void checkParams(PromotionPolicyTemplateEditVo vo) {
        AssertUtils.isNotNull((Object)vo, (String)"\u65e0\u6548\u53c2\u6570\uff0c\u8bf7\u91cd\u8bd5");
        AssertUtils.isNotEmpty((String)vo.getPromotionProduct(), (String)"\u4fc3\u9500\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getPromotionType(), (String)"\u4fc3\u9500\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getTemplateCode(), (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
    }
}

