/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.dms.salecontract.ContractTemplateTupleMappingVo;
import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import com.biz.crm.salecontract.entity.ContractTemplateTupleMappingEntity;
import com.biz.crm.salecontract.mapper.ContractTemplateTupleMappingMapper;
import com.biz.crm.salecontract.service.ContractTemplateTupleMappingService;
import com.biz.crm.salecontract.util.ContractTemplateUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"contractTemplateTupleMappingServiceImpl"})
@Service(value="contractTemplateTupleMappingService")
public class ContractTemplateTupleMappingServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ContractTemplateTupleMappingMapper, ContractTemplateTupleMappingEntity>
implements ContractTemplateTupleMappingService {
    @Resource
    private ContractTemplateTupleMappingMapper contractTemplateTupleMappingMapper;

    @Override
    @Transactional
    public List<ContractTemplateTupleMappingVo> replace(List<ContractTupleVo> tupleVos, String templateCode) {
        ValidateUtils.validate((Object)templateCode, (String)"\u65b0\u589e/\u66f4\u65b0\u6a21\u677f\u5143\u7ec4\u6620\u5c04\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtil.listEmpty(tupleVos)) {
            return Lists.newArrayList();
        }
        List<ContractTemplateTupleMappingVo> mappingVos = ContractTemplateUtil.buildTemplateTupleMappingVo(tupleVos, templateCode);
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"template_code", (Object)templateCode);
        this.contractTemplateTupleMappingMapper.delete((Wrapper)wrapper);
        List entities = CrmBeanUtil.copyList(mappingVos, ContractTemplateTupleMappingEntity.class);
        boolean saveResult = this.saveBatch(entities);
        ValidateUtils.isTrue((boolean)saveResult, (String)"\u4fdd\u5b58\u6a21\u677f\u5143\u7ec4\u6620\u5c04\u5931\u8d25", (Object[])new Object[0]);
        return CrmBeanUtil.copyList((List)entities, ContractTemplateTupleMappingVo.class);
    }

    @Override
    public List<ContractTupleVo> findTupleByTemplateCode(String templateCode) {
        if (StringUtils.isEmpty((String)templateCode)) {
            return Lists.newArrayList();
        }
        List<ContractTupleVo> contractTupleVos = this.contractTemplateTupleMappingMapper.findTupleByTemplateCode(templateCode);
        return contractTupleVos;
    }

    @Override
    public List<ContractTemplateTupleMappingVo> findMappingByTemplateCode(String templateCode) {
        if (StringUtils.isEmpty((String)templateCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"template_code", (Object)templateCode);
        List entities = this.contractTemplateTupleMappingMapper.selectList((Wrapper)wrapper);
        return CrmBeanUtil.copyList((List)entities, ContractTemplateTupleMappingVo.class);
    }
}

