/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salesarea.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.dms.salesarea.SalesAreaVo;
import com.biz.crm.salesarea.entity.SalesAreaEntity;
import com.biz.crm.salesarea.mapper.SalesAreaMapper;
import com.biz.crm.salesarea.service.SalesAreaService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="salesAreaService")
@ConditionalOnMissingBean(name={"salesAreaServiceImpl"})
public class SalesAreaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SalesAreaMapper, SalesAreaEntity>
implements SalesAreaService {
    @Resource
    private SalesAreaMapper salesAreaMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SalesAreaVo replaceSalesArea(SalesAreaVo salesAreaVo) {
        this.validateAdd(salesAreaVo);
        SalesAreaEntity entity = (SalesAreaEntity)((Object)CrmBeanUtil.copy((Object)salesAreaVo, SalesAreaEntity.class));
        this.salesAreaMapper.delete((Wrapper)new QueryWrapper().eq((Object)"sale_contract_code", (Object)entity.getSaleContractCode()));
        boolean addResult = this.save((Object)entity);
        ValidateUtils.isTrue((boolean)addResult, (String)"\u64cd\u4f5c\u5931\u8d25", (Object[])new Object[0]);
        return salesAreaVo;
    }

    @Override
    public SalesAreaVo listSalesArea(String saleContractCode) {
        ValidateUtils.validate((Object)saleContractCode, (String)"\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        List entityList = this.salesAreaMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"sale_contract_code", (Object)saleContractCode));
        ArrayList voList = new ArrayList(entityList.size());
        entityList.forEach(entity -> {
            SalesAreaVo vo = (SalesAreaVo)CrmBeanUtil.copy((Object)entity, SalesAreaVo.class);
            voList.add(vo);
        });
        SalesAreaVo salesAreaVo = new SalesAreaVo();
        salesAreaVo.setVoList(voList);
        return salesAreaVo;
    }

    private void validateAdd(SalesAreaVo salesAreaVo) {
        ValidateUtils.validate((Object)salesAreaVo, (String)"\u4e0a\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)salesAreaVo.getSaleContractCode(), (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)salesAreaVo.getProvince(), (String)"\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)salesAreaVo.getCity(), (String)"\u57ce\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)salesAreaVo.getDistrict(), (String)"\u533a\u53bf\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)salesAreaVo.getVillage(), (String)"\u4e61\u9547\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)salesAreaVo.getStreet(), (String)"\u8857\u9053\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

