/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salestarget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.dms.SalesTargetEunm;
import com.biz.crm.nebular.dms.salestarget.SalesMonthTargetVo;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;
import com.biz.crm.salestarget.entity.SalesTargetEntity;
import com.biz.crm.salestarget.mapper.SalesTargetMapper;
import com.biz.crm.salestarget.service.SalesMonthTargetService;
import com.biz.crm.salestarget.service.SalesTargetService;
import com.biz.crm.salestarget.utils.SalesMonthTargetUtil;
import com.biz.crm.salestarget.utils.SalesTargetUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"salesTargetServiceExpandImpl"})
@Service(value="salesTargetService")
public class SalesTargetServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SalesTargetMapper, SalesTargetEntity>
implements SalesTargetService {
    @Resource
    private SalesTargetMapper salesTargetMapper;
    @Resource
    private SalesMonthTargetService salesMonthTargetService;

    @Override
    @Transactional
    public void addBatch(List<SalesTargetVo> salesTargetVos) {
        this.validateForAddBatch(salesTargetVos);
        HashMap<String, SalesMonthTargetVo> monthTatgetMap = new HashMap<String, SalesMonthTargetVo>(salesTargetVos.size());
        ArrayList<SalesTargetEntity> entities = new ArrayList<SalesTargetEntity>(salesTargetVos.size());
        for (SalesTargetVo vo : salesTargetVos) {
            SalesMonthTargetVo monthTarget = vo.getSalesMonthTargetVo();
            if (null == monthTarget) {
                throw new BusinessException("\u6708\u4efd\u76ee\u6807\u5fc5\u586b!");
            }
            SalesTargetEntity entity = SalesTargetUtil.packageEntityForAdd(vo);
            monthTarget.setSalesTargetId(entity.getId());
            entities.add(entity);
            monthTatgetMap.put(entity.getId(), monthTarget);
        }
        ArrayList<SalesTargetEntity> currentEntities = new ArrayList<SalesTargetEntity>();
        ArrayList<SalesMonthTargetVo> currentMonthTargets = new ArrayList<SalesMonthTargetVo>(salesTargetVos.size());
        int entityI = 0;
        for (SalesTargetEntity entity : entities) {
            currentEntities.add(entity);
            currentMonthTargets.add((SalesMonthTargetVo)monthTatgetMap.get(entity.getId()));
            if (currentEntities.size() != 500 && ++entityI != entities.size()) continue;
            this.saveBatch(currentEntities);
            this.salesMonthTargetService.addBatch(currentMonthTargets);
            currentEntities.clear();
            currentMonthTargets.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateForAddBatch(List<SalesTargetVo> salesTargetVos) {
        SalesTargetUtil.validateParamForAddBatch(salesTargetVos);
        ArrayList<String> params = new ArrayList<String>(salesTargetVos.size());
        for (SalesTargetVo vo : salesTargetVos) {
            if (vo.getType().intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()) {
                params.add(vo.getGoodsCode() + "," + vo.getTargetYear());
                continue;
            }
            if (vo.getType().intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()) {
                params.add(vo.getProductLevelCode() + "," + vo.getTargetYear());
                continue;
            }
            params.add(vo.getTargetYear().toString());
        }
        ArrayList<String> currentParam = new ArrayList<String>();
        ArrayList exsits = new ArrayList();
        int i = 0;
        Integer type2 = salesTargetVos.get(0).getType();
        for (String string : params) {
            currentParam.add(string);
            if (currentParam.size() != 500 && ++i != params.size()) continue;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"only_key", currentParam);
            List entities = this.salesTargetMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)entities)) {
                exsits.addAll(entities);
            }
            currentParam.clear();
        }
        if (!CollectionUtils.isEmpty(exsits)) {
            void var8_12;
            StringBuilder stb = new StringBuilder();
            for (SalesTargetEntity entity : exsits) {
                if (type2.intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()) {
                    stb.append(entity.getGoodsName()).append("-").append(entity.getTargetYear()).append(";");
                    continue;
                }
                if (type2.intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()) {
                    stb.append(entity.getProductLevelName()).append("-").append(entity.getTargetYear()).append(";");
                    continue;
                }
                stb.append(entity.getTargetYear()).append(";");
            }
            StringBuilder stringBuilder = new StringBuilder("\u9500\u91cf\u76ee\u6807\u5df2\u7ecf\u5b58\u5728,\u5e74\u4efd\u4e3a\uff1a");
            if (type2.intValue() != SalesTargetEunm.type.ROUTINE.getCode().intValue()) {
                StringBuilder stringBuilder2 = new StringBuilder("\u9500\u91cf\u76ee\u6807\u5df2\u7ecf\u5b58\u5728,\u4ea7\u54c1/\u4ea7\u54c1\u5c42\u7ea7\u548c\u5e74\u4efd\u4e3a: ");
            }
            throw new BusinessException(var8_12.append((CharSequence)stb).toString());
        }
    }

    @Override
    @Transactional
    public void edit(SalesTargetVo salesTargetVo) {
        ValidateUtils.validate((Object)salesTargetVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807!");
        SalesTargetEntity entity = (SalesTargetEntity)((Object)this.salesTargetMapper.selectById((Serializable)((Object)salesTargetVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        entity.setTargetNum(SalesMonthTargetUtil.countTargetNum(salesTargetVo.getSalesMonthTargetVo()));
        entity.setName(salesTargetVo.getName());
        this.salesTargetMapper.updateById((Object)entity);
        this.salesMonthTargetService.update(salesTargetVo.getSalesMonthTargetVo());
    }

    @Override
    @CrmDictMethod
    public SalesTargetVo findById(String id) {
        SalesTargetVo vo = null;
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u9500\u552e\u76ee\u6807\uff01");
        SalesTargetEntity entity = (SalesTargetEntity)((Object)this.salesTargetMapper.selectById((Serializable)((Object)id)));
        if (null == entity) {
            return vo;
        }
        vo = new SalesTargetVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
        vo.setSalesMonthTargetVo(this.salesMonthTargetService.findBySalesTargetId(vo.getId()));
        return vo;
    }

    @Override
    @CrmDictMethod
    public PageResult<SalesTargetVo> list(SalesTargetVo salesTargetVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)salesTargetVo.getCusName()), (Object)"cus_name", (Object)salesTargetVo.getCusName())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusCode()), (Object)"cus_code", (Object)salesTargetVo.getCusCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusOrgName()), (Object)"cus_org_name", (Object)salesTargetVo.getCusOrgName())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusOrgCode()), (Object)"cus_org_code", (Object)salesTargetVo.getCusOrgCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusChannelName()), (Object)"cus_channel_name", (Object)salesTargetVo.getCusChannelName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)salesTargetVo.getCusChannelCode())).eq(null != salesTargetVo.getType(), (Object)"type", (Object)salesTargetVo.getType())).eq(null != salesTargetVo.getTargetYear(), (Object)"target_year", (Object)salesTargetVo.getTargetYear())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getName()), (Object)"name", (Object)salesTargetVo.getName())).like(!StringUtils.isEmpty((Object)salesTargetVo.getGoodsName()), (Object)"goods_name", (Object)salesTargetVo.getGoodsName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getGoodsCode()), (Object)"goods_code", (Object)salesTargetVo.getGoodsCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getProductLevelName()), (Object)"product_level_name", (Object)salesTargetVo.getProductLevelName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getProductLevelCode()), (Object)"product_level_code", (Object)salesTargetVo.getProductLevelCode())).in(!CollectionUtil.listEmpty((List)salesTargetVo.getOfficeCodes()), (Object)"ext33", (Collection)salesTargetVo.getOfficeCodes())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)salesTargetVo.getPageNum(), (Integer)salesTargetVo.getPageSize());
        List<SalesTargetVo> list = this.salesTargetMapper.list(page, (QueryWrapper<SalesTargetVo>)wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, SalesMonthTargetVo> detailMap = this.salesMonthTargetService.findBySalesTargetIds(list.stream().map(UuidVo::getId).collect(Collectors.toList()));
            for (SalesTargetVo vo : list) {
                vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
                vo.setSalesMonthTargetVo(detailMap.get(vo.getId()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.salesTargetMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional
    public void delByParam(SalesTargetVo salesTargetVo) {
        if (null == salesTargetVo) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6!");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)salesTargetVo.getCusName()), (Object)"cus_name", (Object)salesTargetVo.getCusName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusCode()), (Object)"cus_code", (Object)salesTargetVo.getCusCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusOrgName()), (Object)"cus_org_name", (Object)salesTargetVo.getCusOrgName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusOrgCode()), (Object)"cus_org_code", (Object)salesTargetVo.getCusOrgCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusChannelName()), (Object)"cus_channel_name", (Object)salesTargetVo.getCusChannelName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)salesTargetVo.getCusChannelCode())).eq(null != salesTargetVo.getType(), (Object)"type", (Object)salesTargetVo.getType())).eq(null != salesTargetVo.getTargetYear(), (Object)"target_year", (Object)salesTargetVo.getTargetYear())).like(!StringUtils.isEmpty((Object)salesTargetVo.getGoodsName()), (Object)"goods_name", (Object)salesTargetVo.getGoodsName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getGoodsCode()), (Object)"goods_code", (Object)salesTargetVo.getGoodsCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getProductLevelName()), (Object)"product_level_name", (Object)salesTargetVo.getProductLevelName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getProductLevelCode()), (Object)"product_level_code", (Object)salesTargetVo.getProductLevelCode());
        this.salesTargetMapper.delete((Wrapper)wrapper);
    }
}

