/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import com.biz.crm.salecontract.entity.ContractTupleEntity;
import com.biz.crm.salecontract.mapper.ContractTupleMapper;
import com.biz.crm.salecontract.service.ContractTupleService;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.salecontract.util.ContractTupleUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"contractTupleServiceImpl"})
@Service(value="contractTupleService")
public class ContractTupleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ContractTupleMapper, ContractTupleEntity>
implements ContractTupleService {
    @Resource
    private ContractTupleMapper contractTupleMapper;
    @Resource
    private ApplicationContext applicationContext;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    @Transactional
    public ContractTupleVo add(ContractTupleVo contractTupleVo) {
        ContractTupleUtil.validateAdd(contractTupleVo);
        ValidateUtils.validate((Object)this.getTupleBean(contractTupleVo.getBeanName()), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u540d\u79f0\u4e3a%s\u7684bean\u5bf9\u8c61", (Object[])new Object[]{contractTupleVo.getBeanName()});
        List entities = this.contractTupleMapper.selectList((Wrapper)Wrappers.query().eq((Object)"json_name", (Object)contractTupleVo.getJsonName()));
        ValidateUtils.isTrue((boolean)CollectionUtil.listEmpty((List)entities), (String)"\u6a21\u5757\u5b57\u6bb5\u540d%s\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (Object[])new Object[]{contractTupleVo.getJsonName()});
        contractTupleVo.setCode(CodeUtil.generateCode());
        ContractTupleEntity entity = (ContractTupleEntity)((Object)CrmBeanUtil.copy((Object)contractTupleVo, ContractTupleEntity.class));
        this.contractTupleMapper.insert((Object)entity);
        contractTupleVo.setId(entity.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), contractTupleVo.getId(), contractTupleVo.getCode(), (Object)this.findByCode(contractTupleVo.getCode()));
        return contractTupleVo;
    }

    @Override
    @Transactional
    public ContractTupleVo edit(ContractTupleVo contractTupleVo) {
        ContractTupleUtil.validateEdit(contractTupleVo);
        ValidateUtils.validate((Object)this.getTupleBean(contractTupleVo.getBeanName()), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u540d\u79f0\u4e3a%s\u7684bean\u5bf9\u8c61", (Object[])new Object[]{contractTupleVo.getBeanName()});
        ContractTupleVo dbVo = this.findByCode(contractTupleVo.getCode());
        ContractTupleVo oldObject = this.findByCode(contractTupleVo.getCode());
        ValidateUtils.validate((Object)dbVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55\uff0c\u4e0d\u80fd\u7f16\u8f91");
        ContractTupleEntity entity = (ContractTupleEntity)((Object)CrmBeanUtil.copy((Object)contractTupleVo, ContractTupleEntity.class));
        this.contractTupleMapper.updateById((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        ContractTupleVo newObject = this.findByCode(contractTupleVo.getCode());
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), contractTupleVo.getId(), contractTupleVo.getCode(), (Object)oldObject, (Object)newObject);
        return contractTupleVo;
    }

    @Override
    public ContractTupleVo findByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        ContractTupleEntity entity = (ContractTupleEntity)((Object)this.contractTupleMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"code", (Object)code)));
        return (ContractTupleVo)CrmBeanUtil.copy((Object)((Object)entity), ContractTupleVo.class);
    }

    @Override
    public PageResult<ContractTupleVo> findPageByConditions(ContractTupleVo contractTupleVo) {
        Page page = new Page((long)contractTupleVo.getPageNum().intValue(), (long)contractTupleVo.getPageSize().intValue());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(StringUtils.isNotEmpty((String)contractTupleVo.getCode()), (Object)"code", (Object)contractTupleVo.getCode())).like(StringUtils.isNotEmpty((String)contractTupleVo.getName()), (Object)"name", (Object)contractTupleVo.getName())).like(StringUtils.isNotEmpty((String)contractTupleVo.getRelativePath()), (Object)"relative_path", (Object)contractTupleVo.getRelativePath())).like(StringUtils.isNotEmpty((String)contractTupleVo.getRouterPath()), (Object)"router_path", (Object)contractTupleVo.getRouterPath());
        List<ContractTupleVo> pageList = this.contractTupleMapper.findPageByConditions((Page<ContractTupleVo>)page, wrapper);
        return PageResult.builder().data(pageList).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public AbstractContractModelListener getTupleBean(String beanName) {
        AbstractContractModelListener contractListenerService;
        ValidateUtils.validate((Object)beanName, (String)"bean\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            contractListenerService = (AbstractContractModelListener)this.applicationContext.getBean(beanName, AbstractContractModelListener.class);
        }
        catch (Exception e) {
            throw new BusinessException("\u6ca1\u6709\u83b7\u53d6\u5230\u540d\u79f0\u4e3a".concat(beanName).concat("bean\u5bf9\u8c61"), (Throwable)e);
        }
        return contractListenerService;
    }
}

