/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablegoods.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablegoods.entity.AvailableGoodsEntity;
import com.biz.crm.availablegoods.mapper.AvailableGoodsMapper;
import com.biz.crm.availablegoods.service.AvailableGoodsService;
import com.biz.crm.nebular.dms.availablegoods.AvailableGoodsVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="availableGoodsService")
@ConditionalOnMissingBean(name={"availableGoodsServiceImpl"})
public class AvailableGoodsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<AvailableGoodsMapper, AvailableGoodsEntity>
implements AvailableGoodsService {
    @Resource
    private AvailableGoodsMapper goodsMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<AvailableGoodsVo> replace(List<AvailableGoodsVo> vos, String contractCode) {
        this.validateReplace(vos);
        vos.forEach(vo -> vo.setSaleContractCode(contractCode));
        this.goodsMapper.delete((Wrapper)new QueryWrapper().eq((Object)"sale_contract_code", (Object)contractCode));
        return vos;
    }

    @Override
    public AvailableGoodsVo listAvailableGoods(String saleContractCode) {
        ValidateUtils.validate((Object)saleContractCode, (String)"\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        List goodsEntityList = this.goodsMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"sale_contract_code", (Object)saleContractCode));
        ArrayList goodsVoList = new ArrayList(goodsEntityList.size());
        AvailableGoodsVo voList = new AvailableGoodsVo();
        goodsEntityList.forEach(entity -> {
            AvailableGoodsVo vo = (AvailableGoodsVo)CrmBeanUtil.copy((Object)entity, AvailableGoodsVo.class);
            goodsVoList.add(vo);
        });
        voList.setVoList(goodsVoList);
        return voList;
    }

    private void validateReplace(List<AvailableGoodsVo> voList) {
        ValidateUtils.notEmpty(voList, (String)"\u4e0a\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
    }
}

