/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.validator.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProduct;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProductEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRule;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.ProductPriceMatcher;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import com.biz.crm.promotion.service.component.validator.PromotionPolicyEditValidator;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="promotionPolicyEditFeeRateLadderValidator")
@Order(value=2)
public class PromotionPolicyEditFeeRateLadderValidator
implements PromotionPolicyEditValidator {
    private static final Logger log = LoggerFactory.getLogger(PromotionPolicyEditFeeRateLadderValidator.class);
    @Resource
    private ProductPriceMatcher productPriceMatcher;
    @Resource
    private LadderResolverHelper ladderResolverHelper;

    @Override
    public void validate(PromotionPolicyEditReqVo vo) throws BusinessException {
        BigDecimal feeRate = vo.getFeeRate();
        if (null == feeRate) {
            return;
        }
        PromotionPolicyRuleEditVo ruleEditVo = this.getConditionRuleConfigVo(vo);
        if (null == ruleEditVo) {
            return;
        }
        FeeRateLadderValidatorContext context = this.priceMatch(vo);
        if (null == context) {
            return;
        }
        Map<String, BigDecimal> priceMap = context.getPriceMap();
        Set<String> productCodesCurrentY = context.getProductCodesCurrentY();
        Set<String> productCodesCurrentN = context.getProductCodesCurrentN();
        List controlRows = ruleEditVo.getControlRows();
        for (PromotionRuleEditVo.ControlRow controlRow : controlRows) {
            BigDecimal valueAsProductCurrentY = this.ladderResolverHelper.valueAsProductCurrentY(ruleEditVo, controlRow);
            BigDecimal valueAsProductCurrentN = this.ladderResolverHelper.valueAsProductCurrentN(ruleEditVo, controlRow);
            BigDecimal amountAsCurrentY = priceMap.get(productCodesCurrentY.iterator().next()).multiply(valueAsProductCurrentY);
            BigDecimal amountAsCurrentN = priceMap.get(productCodesCurrentN.iterator().next()).multiply(valueAsProductCurrentN);
            int compareTo = amountAsCurrentN.divide(amountAsCurrentY, 4, RoundingMode.HALF_UP).compareTo(feeRate.divide(new BigDecimal(100)));
            if (compareTo <= 0) continue;
            throw new BusinessException("\u5f53\u524d\u4fc3\u9500\u89c4\u5219\u8d39\u7387\u5927\u4e8e\u653f\u7b56\u6700\u5927\u53ef\u7528\u8d39\u7387\uff08\u4e0d\u53ef\u8bbe\u7f6e\uff09\u3002");
        }
    }

    private FeeRateLadderValidatorContext priceMatch(PromotionPolicyEditReqVo vo) {
        this.check(vo);
        HashSet productCodesCurrentY = Sets.newHashSet();
        HashSet productCodesCurrentN = Sets.newHashSet();
        this.resolveProductCodes(vo, productCodesCurrentY, productCodesCurrentN);
        if (CollectionUtils.isEmpty((Collection)productCodesCurrentY) || CollectionUtils.isEmpty((Collection)productCodesCurrentN)) {
            return null;
        }
        HashSet productCodes = Sets.newHashSet();
        productCodes.addAll(productCodesCurrentY);
        productCodes.addAll(productCodesCurrentN);
        ProductPriceMatcher.PriceMatchParam priceMatchParam = new ProductPriceMatcher.PriceMatchParam();
        priceMatchParam.setChanelCode(vo.getChanel());
        priceMatchParam.setSaleCompanyCode(vo.getSaleCompanyCode());
        priceMatchParam.setActPlanNo(vo.getActPlanNo());
        HashMap priceMap = Maps.newHashMap();
        for (String productCode : productCodes) {
            priceMatchParam.setProductCode(productCode);
            BigDecimal price = this.productPriceMatcher.priceMatch(priceMatchParam);
            if (null == price) {
                throw new BusinessException("\u9879\u76ee\u8be2\u4ef7\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
            priceMap.put(productCode, price);
        }
        FeeRateLadderValidatorContext context = new FeeRateLadderValidatorContext();
        context.setPriceMap(priceMap);
        context.setProductCodesCurrentN(productCodesCurrentN);
        context.setProductCodesCurrentY(productCodesCurrentY);
        return context;
    }

    private void resolveProductCodes(PromotionPolicyEditReqVo vo, Set<String> productCodesCurrentY, Set<String> productCodesCurrentN) {
        PromotionPolicyProduct promotionPolicyProduct = vo.getPromotionPolicyProduct();
        if (null == promotionPolicyProduct) {
            return;
        }
        List productsCurrentY = promotionPolicyProduct.getProductsCurrentY();
        List productsCurrentN = promotionPolicyProduct.getProductsCurrentN();
        if (CollectionUtils.isEmpty((Collection)productsCurrentY)) {
            return;
        }
        for (PromotionPolicyProductEditVo promotionPolicyProductEditVo : productsCurrentY) {
            productCodesCurrentY.add(promotionPolicyProductEditVo.getProductCode());
            if (!StringUtils.isNotBlank((CharSequence)promotionPolicyProductEditVo.getProductCodeGift())) continue;
            productCodesCurrentN.add(promotionPolicyProductEditVo.getProductCodeGift());
        }
        if (productsCurrentY.size() > 1) {
            throw new BusinessException("\u6700\u591a\u53ea\u80fd\u914d\u7f6e\u4e00\u4e2a\u672c\u54c1\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)productsCurrentN)) {
            if (productsCurrentN.size() > 1) {
                throw new BusinessException("\u6700\u591a\u53ea\u80fd\u914d\u7f6e\u4e00\u4e2a\u8d60\u54c1\uff01");
            }
            for (PromotionPolicyProductEditVo promotionPolicyProductEditVo : productsCurrentN) {
                productCodesCurrentN.add(promotionPolicyProductEditVo.getProductCode());
            }
        }
    }

    private void check(PromotionPolicyEditReqVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getSaleCompanyCode())) {
            throw new BusinessException("\u9500\u552e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)vo.getChanel())) {
            throw new BusinessException("\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private PromotionPolicyRuleEditVo getConditionRuleConfigVo(PromotionPolicyEditReqVo vo) {
        PromotionPolicyRule promotionPolicyRule = vo.getPromotionPolicyRule();
        if (null == promotionPolicyRule) {
            return null;
        }
        List rulesAsCondition = promotionPolicyRule.getRulesAsCondition();
        if (CollectionUtils.isEmpty((Collection)rulesAsCondition)) {
            return null;
        }
        PromotionPolicyRuleEditVo ruleEditVo = (PromotionPolicyRuleEditVo)rulesAsCondition.get(0);
        if (null == ruleEditVo) {
            return null;
        }
        return ruleEditVo;
    }

    public static class FeeRateLadderValidatorContext {
        private Map<String, BigDecimal> priceMap;
        private Set<String> productCodesCurrentY;
        private Set<String> productCodesCurrentN;

        public Map<String, BigDecimal> getPriceMap() {
            return this.priceMap;
        }

        public Set<String> getProductCodesCurrentY() {
            return this.productCodesCurrentY;
        }

        public Set<String> getProductCodesCurrentN() {
            return this.productCodesCurrentN;
        }

        public void setPriceMap(Map<String, BigDecimal> priceMap) {
            this.priceMap = priceMap;
        }

        public void setProductCodesCurrentY(Set<String> productCodesCurrentY) {
            this.productCodesCurrentY = productCodesCurrentY;
        }

        public void setProductCodesCurrentN(Set<String> productCodesCurrentN) {
            this.productCodesCurrentN = productCodesCurrentN;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeeRateLadderValidatorContext)) {
                return false;
            }
            FeeRateLadderValidatorContext other = (FeeRateLadderValidatorContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, BigDecimal> this$priceMap = this.getPriceMap();
            Map<String, BigDecimal> other$priceMap = other.getPriceMap();
            if (this$priceMap == null ? other$priceMap != null : !((Object)this$priceMap).equals(other$priceMap)) {
                return false;
            }
            Set<String> this$productCodesCurrentY = this.getProductCodesCurrentY();
            Set<String> other$productCodesCurrentY = other.getProductCodesCurrentY();
            if (this$productCodesCurrentY == null ? other$productCodesCurrentY != null : !((Object)this$productCodesCurrentY).equals(other$productCodesCurrentY)) {
                return false;
            }
            Set<String> this$productCodesCurrentN = this.getProductCodesCurrentN();
            Set<String> other$productCodesCurrentN = other.getProductCodesCurrentN();
            return !(this$productCodesCurrentN == null ? other$productCodesCurrentN != null : !((Object)this$productCodesCurrentN).equals(other$productCodesCurrentN));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FeeRateLadderValidatorContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, BigDecimal> $priceMap = this.getPriceMap();
            result = result * 59 + ($priceMap == null ? 43 : ((Object)$priceMap).hashCode());
            Set<String> $productCodesCurrentY = this.getProductCodesCurrentY();
            result = result * 59 + ($productCodesCurrentY == null ? 43 : ((Object)$productCodesCurrentY).hashCode());
            Set<String> $productCodesCurrentN = this.getProductCodesCurrentN();
            result = result * 59 + ($productCodesCurrentN == null ? 43 : ((Object)$productCodesCurrentN).hashCode());
            return result;
        }

        public String toString() {
            return "PromotionPolicyEditFeeRateLadderValidator.FeeRateLadderValidatorContext(priceMap=" + this.getPriceMap() + ", productCodesCurrentY=" + this.getProductCodesCurrentY() + ", productCodesCurrentN=" + this.getProductCodesCurrentN() + ")";
        }
    }
}

