/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanCopyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanCopyUtil.class);

    public static <T> T copyBen(Object source, Class<T> cls) {
        if (source == null) {
            return null;
        }
        T target = null;
        try {
            target = cls.newInstance();
            BeanUtils.copyProperties((Object)source, target);
        }
        catch (InstantiationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        ValidateUtils.validate(target, (String)"\u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25");
        return target;
    }

    public static <T> List<T> copyList(Collection source, Class<T> cls) {
        if (!CollectionUtil.collectionNotEmpty((Collection)source)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        source.forEach(f -> list.add(BeanCopyUtil.copyBen(f, cls)));
        return list;
    }

    public static <T> Set<T> copySet(Collection source, Class<T> cls) {
        if (!CollectionUtil.collectionNotEmpty((Collection)source)) {
            return Sets.newHashSet();
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        source.forEach(f -> set.add(BeanCopyUtil.copyBen(f, cls)));
        return set;
    }

    public static Map<String, Object> objToMap(Object o) {
        TreeMap result = Maps.newTreeMap();
        try {
            Class<?> c = o.getClass();
            for (Field field : c.getDeclaredFields()) {
                field.setAccessible(true);
                result.put(field.getName(), field.get(o));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Maps.newHashMap();
        }
        return result;
    }

    public static <T> T parseByJSONObject(JSONObject jsonObject, Class<T> cls) {
        if (jsonObject == null) {
            return null;
        }
        Object object = jsonObject.toJavaObject(cls);
        return (T)object;
    }

    public static <T> List<T> parseByJSONArray(JSONArray jsonArray, Class<T> cls) {
        if (jsonArray == null || jsonArray.size() == 0) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        jsonArray.forEach(json -> result.add(BeanCopyUtil.parseByJSONObject((JSONObject)json, cls)));
        return result;
    }
}

