/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.listener.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.contractbase.service.ContractBaseService;
import com.biz.crm.nebular.dms.contractbase.ContractBaseVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service(value="contractBaseListener")
@ConditionalOnMissingBean(name={"contractBaseListenerExtend"})
public class ContractBaseListener
implements AbstractContractModelListener {
    @Resource
    private ContractBaseService contractBaseService;

    @Override
    public JSONArray add(JSONArray data, String contractCode, String jsonName) {
        List<ContractBaseVo> contractBaseVos = BeanCopyUtil.parseByJSONArray(data, ContractBaseVo.class);
        ValidateUtils.isTrue((CollectionUtil.listNotEmpty(contractBaseVos) && contractBaseVos.size() == 1 ? 1 : 0) != 0, (String)"\u5408\u540c\u57fa\u7840\u4fe1\u606f\u5e94\u8be5\u6709\u4e14\u4ec5\u6709\u4e00\u6761", (Object[])new Object[0]);
        contractBaseVos.get(0).setSaleContractCode(contractCode);
        ContractBaseVo result = this.contractBaseService.add(contractBaseVos.get(0));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)result);
        return jsonArray;
    }

    @Override
    public JSONArray edit(JSONArray data, String contractCode, String jsonName) {
        List<ContractBaseVo> vos = BeanCopyUtil.parseByJSONArray(data, ContractBaseVo.class);
        ValidateUtils.isTrue((CollectionUtil.listNotEmpty(vos) && vos.size() == 1 ? 1 : 0) != 0, (String)"\u5408\u540c\u57fa\u7840\u4fe1\u606f\u5e94\u8be5\u6709\u4e14\u4ec5\u6709\u4e00\u6761", (Object[])new Object[0]);
        vos.get(0).setSaleContractCode(contractCode);
        ContractBaseVo result = this.contractBaseService.edit(vos.get(0));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)result);
        return jsonArray;
    }

    @Override
    public JSONArray findByContractCode(String contractCode, String jsonName) {
        ContractBaseVo vo = new ContractBaseVo();
        vo.setSaleContractCode(contractCode);
        ContractBaseVo result = this.contractBaseService.findByContractCode(vo);
        JSONArray jsonArray = BeanCopyUtil.formatJSONArray(Lists.newArrayList((Object[])new ContractBaseVo[]{result}));
        return jsonArray;
    }
}

