/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salesarea.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.dms.salesarea.SalesAreaVo;
import com.biz.crm.salesarea.entity.SalesAreaEntity;
import com.biz.crm.salesarea.mapper.SalesAreaMapper;
import com.biz.crm.salesarea.service.SalesAreaService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="salesAreaService")
@ConditionalOnMissingBean(name={"salesAreaServiceImpl"})
public class SalesAreaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SalesAreaMapper, SalesAreaEntity>
implements SalesAreaService {
    @Resource
    private SalesAreaMapper salesAreaMapper;

    @Override
    @Transactional
    public List<SalesAreaVo> replaceSalesArea(List<SalesAreaVo> vos, String contractCode) {
        this.validateAdd(vos);
        vos.forEach(vo -> vo.setSaleContractCode(contractCode));
        List entities = CrmBeanUtil.copyList(vos, SalesAreaEntity.class);
        this.salesAreaMapper.delete((Wrapper)new QueryWrapper().eq((Object)"sale_contract_code", (Object)contractCode));
        boolean addResult = this.saveBatch(entities);
        ValidateUtils.isTrue((boolean)addResult, (String)"\u64cd\u4f5c\u5931\u8d25", (Object[])new Object[0]);
        return CrmBeanUtil.copyList((List)entities, SalesAreaVo.class);
    }

    @Override
    public SalesAreaVo listSalesArea(String saleContractCode) {
        ValidateUtils.validate((Object)saleContractCode, (String)"\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        List entityList = this.salesAreaMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"sale_contract_code", (Object)saleContractCode));
        ArrayList voList = new ArrayList(entityList.size());
        entityList.forEach(entity -> {
            SalesAreaVo vo = (SalesAreaVo)CrmBeanUtil.copy((Object)entity, SalesAreaVo.class);
            voList.add(vo);
        });
        SalesAreaVo salesAreaVo = new SalesAreaVo();
        salesAreaVo.setVoList(voList);
        return salesAreaVo;
    }

    private void validateAdd(List<SalesAreaVo> vos) {
        ValidateUtils.isTrue((boolean)CollectionUtil.listNotEmpty(vos), (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

