/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.listener.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.availablegoods.service.AvailableGoodsService;
import com.biz.crm.nebular.dms.availablegoods.AvailableGoodsVo;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="contractAvailableGoodsListener")
@ConditionalOnMissingBean(name={"contractAvailableGoodsListenerExtend"})
public class ContractAvailableGoodsListener
implements AbstractContractModelListener {
    @Resource
    private AvailableGoodsService availableGoodsService;

    @Override
    @Transactional
    public JSONArray add(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        if (CollectionUtil.jsonArrayEmpty((JSONArray)data)) {
            return new JSONArray();
        }
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)saleContractVo, (String)"\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a");
        return this.edit(data, contractCode, jsonName, saleContractVo, indexCode);
    }

    @Override
    @Transactional
    public JSONArray edit(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)saleContractVo, (String)"\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a");
        List<AvailableGoodsVo> vos = BeanCopyUtil.parseByJSONArray(data, AvailableGoodsVo.class);
        List<AvailableGoodsVo> result = this.availableGoodsService.replace(vos, contractCode);
        JSONArray jsonArray = BeanCopyUtil.formatJSONArray(result);
        return jsonArray;
    }

    @Override
    public JSONArray findByContractCode(String contractCode, String jsonName, String indexCode) {
        AvailableGoodsVo result = this.availableGoodsService.listAvailableGoods(contractCode);
        return BeanCopyUtil.formatJSONArray(Lists.newArrayList((Object[])new AvailableGoodsVo[]{result}));
    }
}

