/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.minbuynumofproduct.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.minbuynumofproduct.entity.MinBuyNumOfProductEntity;
import com.biz.crm.minbuynumofproduct.repositories.MinBuyNumOfProductRepositories;
import com.biz.crm.minbuynumofproduct.service.MinBuyNumOfProductService;
import com.biz.crm.minbuynumofproduct.utils.MinBuyNumOfProductUtil;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.EsUtil;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"MinBuyNumOfProductServiceExpandImpl"})
@Service(value="minBuyNumOfProductService")
public class MinBuyNumOfProductServiceImpl
implements MinBuyNumOfProductService {
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private RedissonUtil redissonUtil;
    @Resource
    private MinBuyNumOfProductRepositories minOrderRepositories;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    @Transactional
    public void add(ArrayList<MinBuyNumOfProductVo> minBuyNumOfProductVos) {
        if (CollectionUtils.isEmpty(minBuyNumOfProductVos)) {
            return;
        }
        MinBuyNumOfProductUtil.validParamBatch(minBuyNumOfProductVos);
        List<MinBuyNumOfProductEntity> minBuyNumOfProductEntities = MinBuyNumOfProductUtil.assembleEntities(minBuyNumOfProductVos);
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, MinBuyNumOfProductEntity.class, (RedissonUtil)this.redissonUtil)) {
            this.minOrderRepositories.saveAll(minBuyNumOfProductEntities);
            this.elasticsearchTemplate.refresh("minbuynumofproductindex");
            return;
        }
        List<String> onlyKeys = minBuyNumOfProductEntities.stream().map(MinBuyNumOfProductEntity::getOnlyKey).collect(Collectors.toList());
        this.minOrderRepositories.deleteAllByOnlyKeyIn(onlyKeys);
        this.minOrderRepositories.saveAll(minBuyNumOfProductEntities);
        this.elasticsearchTemplate.refresh("minbuynumofproductindex");
        List logVos = CrmBeanUtil.copyList(minBuyNumOfProductEntities, MinBuyNumOfProductVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (MinBuyNumOfProductVo vo : logVos) {
            this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), vo.getId(), vo.getId(), (Object)vo);
        }
    }

    @Override
    @Transactional
    public void update(MinBuyNumOfProductVo minBuyNumOfProductVo) {
        if (minBuyNumOfProductVo == null) {
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, MinBuyNumOfProductEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        MinBuyNumOfProductUtil.validParam(minBuyNumOfProductVo);
        MinBuyNumOfProductEntity minBuyNumOfProductEntity = this.minOrderRepositories.findAllById(minBuyNumOfProductVo.getId());
        ValidateUtils.validate((Object)((Object)minBuyNumOfProductEntity), (String)"\u8981\u4fee\u6539\u7684\u8d77\u8ba2\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5220\u9664\uff01");
        MinBuyNumOfProductEntity oldObject = this.minOrderRepositories.findAllById(minBuyNumOfProductVo.getId());
        this.minOrderRepositories.save(CrmBeanUtil.copy((Object)minBuyNumOfProductVo, MinBuyNumOfProductEntity.class));
        this.elasticsearchTemplate.refresh("minbuynumofproductindex");
        MinBuyNumOfProductEntity newObject = this.minOrderRepositories.findAllById(minBuyNumOfProductVo.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newObject.getId(), newObject.getId(), (Object)oldObject, (Object)newObject);
    }

    @Override
    public PageResult<MinBuyNumOfProductVo> list(MinBuyNumOfProductVo minBuyNumOfProductVo) {
        PageResult pageResult = PageResult.builder().data(new ArrayList()).count(Long.valueOf(Long.parseLong("0"))).build();
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, MinBuyNumOfProductEntity.class, (RedissonUtil)this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = MinBuyNumOfProductUtil.buildQuery(minBuyNumOfProductVo);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"minbuynumofproductindex"}).withQuery((QueryBuilder)boolQueryBuilder).withSort(SortBuilders.fieldSort((String)"operationTimeNum").unmappedType("keyword").order(SortOrder.DESC)).withPageable((Pageable)PageRequest.of((int)(minBuyNumOfProductVo.getPageNum() - 1), (int)minBuyNumOfProductVo.getPageSize())).build();
        AggregatedPage scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, MinBuyNumOfProductEntity.class);
        List minBuyNumOfProductEntities = scroll.getContent();
        if (CollectionUtils.isEmpty((Collection)minBuyNumOfProductEntities)) {
            return pageResult;
        }
        return PageResult.builder().data(CrmBeanUtil.copyList((List)minBuyNumOfProductEntities, MinBuyNumOfProductVo.class)).count(Long.valueOf(scroll.getTotalElements())).build();
    }

    @Override
    @Transactional
    public void updateEffectiveFlag(ArrayList<String> ids, Integer code) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8981\u64cd\u4f5c\u7684\u8d77\u8ba2\u91cf\uff01");
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, MinBuyNumOfProductEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        List<MinBuyNumOfProductEntity> minBuyNumOfProductEntities = this.minOrderRepositories.findAllByIdIn(ids);
        if (CollectionUtils.isEmpty(minBuyNumOfProductEntities) || minBuyNumOfProductEntities.size() < ids.size()) {
            throw new BusinessException("\u90e8\u5206\u8d77\u8ba2\u91cf\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        minBuyNumOfProductEntities = minBuyNumOfProductEntities.stream().map(minBuyNumOfProductEntity -> minBuyNumOfProductEntity.setEffectiveFlag(code)).collect(Collectors.toList());
        this.minOrderRepositories.saveAll(minBuyNumOfProductEntities);
        this.elasticsearchTemplate.refresh("minbuynumofproductindex");
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8981\u5220\u9664\u7684\u8d77\u8ba2\u91cf\uff01");
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, MinBuyNumOfProductEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        List<MinBuyNumOfProductEntity> entities = this.minOrderRepositories.findAllByIdIn(ids);
        this.minOrderRepositories.deleteAllByIdIn(ids);
        this.elasticsearchTemplate.refresh("minbuynumofproductindex");
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List logVos = CrmBeanUtil.copyList(entities, MinBuyNumOfProductVo.class);
        for (MinBuyNumOfProductVo vo : logVos) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), vo.getId(), vo.getId(), (Object)vo);
        }
    }
}

