/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.DmsPromotionPolicyOrderDetailEntity;
import com.biz.crm.promotion.service.IDmsPromotionPolicyOrderDetailService;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.promotion.service.component.ProductPriceMatcher;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.RuleExecutor;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.LimitedRuleParam;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="defaultRuleExecutor")
public class DefaultRuleExecutor
implements RuleExecutor<CalculateRuleResponse> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRuleExecutor.class);
    @Resource
    private PromotionPolicyService promotionPolicyService;
    @Resource
    private IDmsPromotionPolicyOrderDetailService iDmsPromotionPolicyOrderDetailService;
    @Resource
    private ProductPriceMatcher productPriceMatcher;
    @Value(value="${promotion.rounding:1}")
    private Integer rounding;

    @Override
    public CalculateRuleResponse execute(RuleExecuteParam ruleExecuteParam) {
        RuleFunction ruleFunction;
        this.checkParam(ruleExecuteParam);
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = ruleExecuteParam.getPromotionPolicyConfigInfo();
        ValidateUtils.validate((Object)promotionPolicyConfigInfo, (String)"\u4fc3\u9500\u653f\u7b56\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        PromotionPolicyRuleVo condition = promotionPolicyConfigInfo.getCondition();
        PromotionPolicyRuleVo calculate = promotionPolicyConfigInfo.getCalculate();
        try {
            ruleFunction = (RuleFunction)SpringApplicationContextUtil.getApplicationContext().getBean(calculate.getFuncBody(), RuleFunction.class);
        }
        catch (BeansException e) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u8ba1\u7b97\u89c4\u5219[" + calculate.getRuleCode() + "]\u8ba1\u7b97\u5931\u8d25, \u672a\u67e5\u627e\u5230\u8be5\u89c4\u5219\u7684\u8ba1\u7b97\u5b9e\u4f8b", (Throwable)e);
        }
        CalculateRuleParam calculateRuleParam = new CalculateRuleParam();
        calculateRuleParam.setLadderList(JsonPropertyUtil.toArray((String)condition.getParams(), PromotionRuleEditVo.ControlRow.class));
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = ruleExecuteParam.getProductOrderBuy();
        calculateRuleParam.setProductOrderBuy(productOrderBuy);
        calculateRuleParam.setConditionRuleFunctionBeanName(condition.getFuncBody());
        this.computePromotionVariable(condition.getPromotionPolicyId(), ruleExecuteParam, calculateRuleParam);
        CalculateRuleResponse calculateRuleResponse = (CalculateRuleResponse)ruleFunction.apply(calculateRuleParam);
        BigDecimal resultData = calculateRuleResponse.getResultData();
        if (YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(this.rounding) && resultData != null) {
            resultData = resultData.setScale(0, 1);
        }
        calculateRuleResponse.setResultData(resultData);
        calculateRuleResponse = this.calculateRuleExecuted(ruleExecuteParam, calculateRuleResponse);
        if (null == calculateRuleResponse) {
            throw new BusinessException("\u8ba1\u7b97\u89c4\u5219\u7ed3\u679c\u6269\u5c55\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002");
        }
        this.doLimited(ruleExecuteParam, calculateRuleResponse);
        return calculateRuleResponse;
    }

    private void computePromotionVariable(String promotionPolicyId, RuleExecuteParam ruleExecuteParam, CalculateRuleParam calculateRuleParam) {
        Map<Object, Object> prices;
        ProductPriceMatcher.PriceMatchParam priceMatchParam = new ProductPriceMatcher.PriceMatchParam();
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = ruleExecuteParam.getPromotionPolicyConfigInfo();
        ValidateUtils.validate((Object)promotionPolicyConfigInfo, (String)"\u653f\u7b56\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        PromotionPolicyInfoDataVo promotionPolicyInfoVo = promotionPolicyConfigInfo.getPromotionPolicyInfoVo();
        ValidateUtils.validate((Object)promotionPolicyInfoVo, (String)"\u4fc3\u9500\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a");
        priceMatchParam.setChanelCode(promotionPolicyInfoVo.getChanel());
        priceMatchParam.setSaleCompanyCode(promotionPolicyInfoVo.getSaleCompanyCode());
        priceMatchParam.setCusCode(ruleExecuteParam.getCusCode());
        priceMatchParam.setCusTypeCode(ruleExecuteParam.getCusTypeCode());
        priceMatchParam.setCusOrgCode(ruleExecuteParam.getCusOrgCode());
        if (CollectionUtil.listEmpty((List)promotionPolicyConfigInfo.getProductsGift())) {
            return;
        }
        if (CollectionUtil.mapNotEmpty(ruleExecuteParam.getPrices())) {
            prices = ruleExecuteParam.getPrices();
        } else {
            prices = Maps.newHashMap();
            promotionPolicyConfigInfo.getProductsGift().forEach(product -> {
                priceMatchParam.setProductCode(product.getProductCode());
                BigDecimal price = this.productPriceMatcher.priceMatch(priceMatchParam);
                ValidateUtils.validate((Object)price, (String)"\u83b7\u53d6\u4ef7\u683c\u5f02\u5e38\uff0c\u5165\u53c2\uff1a\u6e20\u9053-%s\uff0c\u9500\u552e\u516c\u5f0f-%s\uff0c\u5546\u54c1-%s", (Object[])new Object[]{priceMatchParam.getChanelCode(), priceMatchParam.getSaleCompanyCode(), priceMatchParam.getProductCode()});
                prices.put(product.getProductCode(), price);
            });
        }
        calculateRuleParam.setPrices((Map<String, BigDecimal>)prices);
        if (StringUtils.isBlank((CharSequence)promotionPolicyId)) {
            return;
        }
        PromotionPolicyVo promotionPolicyVo = this.promotionPolicyService.findById(promotionPolicyId);
        if (promotionPolicyVo == null) {
            return;
        }
        List dmsPromotionPolicyOrderDetailRespVos = this.iDmsPromotionPolicyOrderDetailService.list((Wrapper)Wrappers.query().eq((Object)"promotion_policy_id", (Object)promotionPolicyId));
        if (CollectionUtil.listEmpty((List)dmsPromotionPolicyOrderDetailRespVos)) {
            calculateRuleParam.setVariable(promotionPolicyVo.getUsedQtyUpper());
            return;
        }
        BigDecimal useQtyUpper = promotionPolicyVo.getUsedQtyUpper();
        if (useQtyUpper == null) {
            return;
        }
        for (DmsPromotionPolicyOrderDetailEntity entity : dmsPromotionPolicyOrderDetailRespVos) {
            BigDecimal usedAmount = CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode().equals(entity.getUsedQtyType()) ? ((BigDecimal)prices.entrySet().iterator().next().getValue()).multiply(entity.getUsedQty()) : entity.getUsedQty();
            useQtyUpper = useQtyUpper.subtract(usedAmount);
        }
        calculateRuleParam.setVariable(useQtyUpper);
    }

    protected void doLimited(RuleExecuteParam ruleExecuteParam, CalculateRuleResponse calculateRuleResponse) {
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = ruleExecuteParam.getPromotionPolicyConfigInfo();
        ValidateUtils.validate((Object)promotionPolicyConfigInfo, (String)"\u4fc3\u9500\u653f\u7b56\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        List limited = promotionPolicyConfigInfo.getLimited();
        if (CollectionUtils.isEmpty((Collection)limited)) {
            return;
        }
        LimitedRuleParam limitedRuleParam = new LimitedRuleParam();
        for (PromotionPolicyRuleVo ruleVo : limited) {
            RuleFunction ruleFunction;
            PromotionRuleEditVo.KeyValParamControl keyValParamControl = this.limitedKeyValParam(ruleVo.getParams());
            Object limitedConfigStr = keyValParamControl.getValue();
            if (!Objects.isNull(limitedConfigStr)) {
                limitedRuleParam.setLimitedConfig(new BigDecimal(limitedConfigStr.toString()));
            }
            limitedRuleParam.setGift(calculateRuleResponse.getResultData());
            try {
                ruleFunction = (RuleFunction)SpringApplicationContextUtil.getApplicationContext().getBean(ruleVo.getFuncBody(), RuleFunction.class);
            }
            catch (BeansException e) {
                throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u9650\u91cf\u89c4\u5219[" + ruleVo.getRuleCode() + "]\u8ba1\u7b97\u5931\u8d25, \u672a\u67e5\u627e\u5230\u8be5\u89c4\u5219\u7684\u8ba1\u7b97\u5b9e\u4f8b", (Throwable)e);
            }
            BigDecimal result = (BigDecimal)ruleFunction.apply(limitedRuleParam);
            if (null == result) {
                throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u9650\u91cf\u89c4\u5219[" + ruleVo.getRuleCode() + "]\u8ba1\u7b97\u5931\u8d25\uff0c \u8be5\u89c4\u5219\u672a\u8ba1\u7b97\u51fa\u53ef\u7528\u7684\u7ed3\u679c");
            }
            calculateRuleResponse.setResultData(result);
        }
    }

    protected PromotionRuleEditVo.KeyValParamControl limitedKeyValParam(String paramStr) {
        PromotionRuleEditVo.ControlRow controlRow;
        List controlRows;
        if (StringUtils.isNotBlank((CharSequence)paramStr) && !CollectionUtils.isEmpty((Collection)(controlRows = JsonPropertyUtil.toArray((String)paramStr, PromotionRuleEditVo.ControlRow.class))) && null != controlRows.get(0) && !CollectionUtils.isEmpty((Collection)(controlRow = (PromotionRuleEditVo.ControlRow)controlRows.get(0)).getControls())) {
            return (PromotionRuleEditVo.KeyValParamControl)controlRow.getControls().get(0);
        }
        return new PromotionRuleEditVo.KeyValParamControl();
    }

    protected CalculateRuleResponse calculateRuleExecuted(RuleExecuteParam ruleExecuteParam, CalculateRuleResponse calculateRuleResponse) {
        return calculateRuleResponse;
    }

    protected void checkParam(RuleExecuteParam ruleExecuteParam) {
        if (null == ruleExecuteParam) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = ruleExecuteParam.getProductOrderBuy();
        if (CollectionUtils.isEmpty(productOrderBuy)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9700\u8981\u8ba1\u7b97\u7684\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        }
        productOrderBuy.forEach(v -> {
            if (null == v.getProductBuyAmount()) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1[" + v.getProductCode() + "]\u7684\u91d1\u989d\u8d2d\u4e70\u91d1\u989d");
            }
            if (null == v.getProductBuyNo()) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1[" + v.getProductCode() + "]\u7684\u6570\u91cf\u8d2d\u4e70\u6570\u91cf");
            }
        });
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = ruleExecuteParam.getPromotionPolicyConfigInfo();
        ValidateUtils.validate((Object)promotionPolicyConfigInfo, (String)"\u4fc3\u9500\u653f\u7b56\u8be6\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        PromotionPolicyRuleVo condition = promotionPolicyConfigInfo.getCondition();
        PromotionPolicyRuleVo calculate = promotionPolicyConfigInfo.getCalculate();
        if (null == calculate) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8ba1\u7b97\u89c4\u5219");
        }
        if (StringUtils.isBlank((CharSequence)condition.getRuleCode())) {
            throw new BusinessException("\u8ba1\u7b97\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)condition.getFuncBody())) {
            throw new BusinessException("\u8ba1\u7b97\u89c4\u5219\u811a\u672c\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == condition) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6761\u4ef6\u89c4\u5219");
        }
        if (StringUtils.isBlank((CharSequence)condition.getRuleCode())) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)condition.getFuncBody())) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219\u811a\u672c\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)condition.getParams())) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219\u9636\u68af\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

