/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.entity.OrderDetailEntity;
import com.biz.crm.order.entity.OrderEntity;
import com.biz.crm.order.mapper.OrderDetailMapper;
import com.biz.crm.order.mapper.OrderDetailPromotionMapper;
import com.biz.crm.order.service.OrderDetailService;
import com.biz.crm.order.utils.OrderDetailUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"orderDetailServiceExpandImpl"})
@Service(value="orderDetailService")
public class OrderDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<OrderDetailMapper, OrderDetailEntity>
implements OrderDetailService {
    @Resource
    private OrderDetailPromotionMapper orderDetailPromotionMapper;
    @Resource
    private OrderDetailMapper orderDetailMapper;

    @Override
    @Transactional
    public void addBatch(OrderVo orderVo, OrderEntity orderEntity) {
        List<OrderDetailEntity> orderDetailEntities = OrderDetailUtil.packageOrderDetails(orderVo, orderEntity);
        this.saveBatch(orderDetailEntities);
    }

    @Override
    public List<OrderGroupItemVo> findGroupByOrderCode(String orderCode) {
        if (StringUtils.isEmpty((String)orderCode)) {
            return Lists.newArrayList();
        }
        List<OrderDetailVo> detailVos = this.findByOrderCode(orderCode);
        if (CollectionUtil.listEmpty(detailVos)) {
            return Lists.newArrayList();
        }
        return this.groupOrderDetails(detailVos);
    }

    private List<OrderGroupItemVo> groupOrderDetails(List<OrderDetailVo> detailVos) {
        if (CollectionUtil.listEmpty(detailVos)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        Map<String, List<OrderDetailVo>> groupItemMap = detailVos.stream().collect(Collectors.groupingBy(OrderDetailVo::getGroupCode));
        groupItemMap.values().forEach(details -> {
            List normalList = details.stream().filter(detail -> OrderEunm.LineTypeEnum.SOURCE_PRODUCT.getCode().equals(detail.getLineType())).collect(Collectors.toList());
            List giftList = details.stream().filter(detail -> OrderEunm.LineTypeEnum.GIFT_PRODUCT.getCode().equals(detail.getLineType())).collect(Collectors.toList());
            List backList = details.stream().filter(detail -> OrderEunm.LineTypeEnum.REP_PRODUCT.getCode().equals(detail.getLineType())).collect(Collectors.toList());
            OrderGroupItemVo groupItemVo = new OrderGroupItemVo();
            groupItemVo.setNormalList(normalList);
            groupItemVo.setGiftList(giftList);
            groupItemVo.setBackList(backList);
            result.add(groupItemVo);
        });
        return result;
    }

    @Override
    public List<OrderDetailVo> findByOrderCode(String orderCode) {
        if (StringUtils.isEmpty((String)orderCode)) {
            return Lists.newArrayList();
        }
        List entities = this.orderDetailMapper.selectList((Wrapper)Wrappers.query().eq((Object)"order_code", (Object)orderCode));
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return CrmBeanUtil.copyList((List)entities, OrderDetailVo.class);
    }
}

