/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.MinBuyNumOfProductEunm;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;
import com.biz.crm.nebular.dms.order.CalMinBuyNumDo;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToCashVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepProductVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyForOrderProductReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyForOrderReqVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.order.entity.OrderEntity;
import com.biz.crm.order.utils.OrderCodeUtil;
import com.biz.crm.orderfeerate.service.OrderFeeRateService;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderUtilExpand"})
@Component(value="orderUtil")
public class OrderUtil {
    @Resource
    private PromotionPolicyService promotionPolicyService;
    @Resource
    private OrderFeeRateService orderFeeRateService;

    public void validateForCal(OrderVo orderVo) {
        ValidateUtils.validate((Object)orderVo.getCusCode(), (String)"\u8bf7\u5148\u9009\u62e9\u7ecf\u9500\u5546!");
        if (CollectionUtils.isEmpty((Collection)orderVo.getGroupItemVos())) {
            throw new BusinessException("\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a!");
        }
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList()) && CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList()) && CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
                throw new BusinessException("\u9519\u8bef\u8ba2\u5355\uff0c\u8bf7\u68c0\u67e5!");
            }
            OrderUtil.validateForDetail(groupItemVo.getBackList());
            OrderUtil.validateForDetail(groupItemVo.getGiftList());
            OrderUtil.validateForDetail(groupItemVo.getNormalList());
        }
    }

    public static void validateForDetail(List<OrderDetailVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (OrderDetailVo item : list) {
            ValidateUtils.validate((Object)item.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)item.getProductNum(), (String)"\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a!");
        }
    }

    public static Map<String, CalMinBuyNumDo> extractProductCodes(OrderVo orderVo) {
        HashMap<String, CalMinBuyNumDo> reMap = new HashMap<String, CalMinBuyNumDo>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            CalMinBuyNumDo calMinBuyNumDo;
            if (!CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) {
                for (OrderDetailVo item : groupItemVo.getBackList()) {
                    calMinBuyNumDo = (CalMinBuyNumDo)reMap.get(item.getProductCode());
                    if (calMinBuyNumDo == null) {
                        reMap.put(item.getProductCode(), CalMinBuyNumDo.newInstance((Integer)item.getProductNum().intValue(), (Integer)0, (String)item.getProductName(), (String)item.getProductCode()));
                        continue;
                    }
                    calMinBuyNumDo.setNum(Integer.valueOf(calMinBuyNumDo.getNum() + item.getProductNum().intValue()));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) {
                for (OrderDetailVo item : groupItemVo.getGiftList()) {
                    calMinBuyNumDo = (CalMinBuyNumDo)reMap.get(item.getProductCode());
                    if (calMinBuyNumDo == null) {
                        reMap.put(item.getProductCode(), CalMinBuyNumDo.newInstance((Integer)0, (Integer)item.getProductNum().intValue(), (String)item.getProductName(), (String)item.getProductCode()));
                        continue;
                    }
                    calMinBuyNumDo.setGiftNum(Integer.valueOf(calMinBuyNumDo.getGiftNum() + item.getProductNum().intValue()));
                }
            }
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) continue;
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                calMinBuyNumDo = (CalMinBuyNumDo)reMap.get(item.getProductCode());
                if (calMinBuyNumDo == null) {
                    reMap.put(item.getProductCode(), CalMinBuyNumDo.newInstance((Integer)item.getProductNum().intValue(), (Integer)0, (String)item.getProductName(), (String)item.getProductCode()));
                    continue;
                }
                calMinBuyNumDo.setNum(Integer.valueOf(calMinBuyNumDo.getNum() + item.getProductNum().intValue()));
            }
        }
        return reMap;
    }

    public static OrderVo validateMinBuyNum(OrderVo orderVo, Map<String, CalMinBuyNumDo> productNumMap, Map<String, MinBuyNumOfProductVo> minBuyNumOfProductEntityMap) {
        for (Map.Entry<String, CalMinBuyNumDo> entry : productNumMap.entrySet()) {
            CalMinBuyNumDo calMinBuyNumDo = entry.getValue();
            MinBuyNumOfProductVo minBuyNumOfProductVo = minBuyNumOfProductEntityMap.get(entry.getKey());
            if (null == minBuyNumOfProductVo) continue;
            Integer buyNum = calMinBuyNumDo.getNum();
            if (MinBuyNumOfProductEunm.verificationModeEunm.NORMALANDGIFT.getCode().equals(minBuyNumOfProductVo.getVerificationMode())) {
                buyNum = buyNum + calMinBuyNumDo.getGiftNum();
            }
            if (new BigDecimal(buyNum).compareTo(new BigDecimal(minBuyNumOfProductVo.getMinOrderQuantity())) >= 0) continue;
            orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
            orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
            StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u5546\u54c1\u3010").append(calMinBuyNumDo.getProductName()).append("\u3011\u4e0d\u6ee1\u8db3\u8d77\u8ba2\u91cf").append(",\u8d77\u8ba2\u91cf\u4e3a:").append(minBuyNumOfProductVo.getMinOrderQuantity()).append(minBuyNumOfProductVo.getUnitName());
            orderVo.setCalSucessMsg(stb.toString());
        }
        return orderVo;
    }

    public OrderVo packageProductMsg(OrderVo orderVo, Map<String, MdmProductAdviseAndPriceRespVo> productMsp) {
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            this.packageGroup(orderVo, groupItemVo, productMsp);
        }
        return orderVo;
    }

    public void packageGroup(OrderVo orderVo, OrderGroupItemVo groupItemVo, Map<String, MdmProductAdviseAndPriceRespVo> productMsp) {
        StringBuilder stb;
        MdmProductAdviseAndPriceRespVo product;
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) {
            ArrayList<OrderDetailVo> backList = new ArrayList<OrderDetailVo>();
            for (OrderDetailVo item : groupItemVo.getBackList()) {
                product = productMsp.get(item.getProductCode());
                if (null == product) {
                    orderVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u5546\u54c1\u3010").append(item.getProductName()).append("\u3011\u5df2\u7ecf\u4e0b\u67b6\uff01");
                    item.setCalSucessMsg(stb.toString());
                } else {
                    this.packageItemVo(item, product);
                }
                backList.add(item);
            }
            groupItemVo.setBackList(backList);
        }
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) {
            ArrayList<OrderDetailVo> giftList = new ArrayList<OrderDetailVo>();
            for (OrderDetailVo item : groupItemVo.getGiftList()) {
                product = productMsp.get(item.getProductCode());
                if (null == product) {
                    orderVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u5546\u54c1\u3010").append(item.getProductName()).append("\u3011\u5df2\u7ecf\u4e0b\u67b6\uff01");
                    item.setCalSucessMsg(stb.toString());
                } else {
                    this.packageItemVo(item, product);
                }
                giftList.add(item);
            }
            groupItemVo.setGiftList(giftList);
        }
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
            ArrayList<OrderDetailVo> normalList = new ArrayList<OrderDetailVo>();
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                product = productMsp.get(item.getProductCode());
                if (null == product) {
                    orderVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u5546\u54c1\u3010").append(item.getProductName()).append("\u3011\u5df2\u7ecf\u4e0b\u67b6\uff01");
                    item.setCalSucessMsg(stb.toString());
                } else {
                    this.packageItemVo(item, product);
                }
                normalList.add(item);
            }
            groupItemVo.setNormalList(normalList);
        }
    }

    public OrderDetailVo packageItemVo(OrderDetailVo item, MdmProductAdviseAndPriceRespVo product) {
        item.setProductName(product.getProductName());
        item.setSpec(product.getSpec());
        item.setSalesUnit(product.getSaleUnit());
        item.setSalesUnitName(product.getSaleUnitName());
        item.setPrice(product.getSalePrice());
        item.setImgUrl(product.getImgUrl());
        item.setProductLevelCode(product.getProductLevelCode());
        return item;
    }

    public PromotionPolicyForOrderReqVo extractPromotion(OrderVo orderVo, String cusCode, String orgCode) {
        PromotionPolicyForOrderReqVo reVo = new PromotionPolicyForOrderReqVo();
        reVo.setCusCode(cusCode);
        reVo.setOrgCode(orgCode);
        ArrayList<PromotionPolicyForOrderProductReqVo> reList = new ArrayList<PromotionPolicyForOrderProductReqVo>();
        reVo.setPromotionList(reList);
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
                return reVo;
            }
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                if (StringUtils.isEmpty((CharSequence)item.getPromotionPolicyCode())) continue;
                reList.add(PromotionPolicyForOrderProductReqVo.newInstance((String)item.getProductCode(), (String)item.getPromotionPolicyCode()));
            }
        }
        return reVo;
    }

    public OrderVo calItemPrice(OrderVo orderVo) {
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            this.calItemPrice(orderVo, groupItemVo);
        }
        return orderVo;
    }

    public void calItemPrice(OrderVo orderVo, OrderGroupItemVo groupItemVo) {
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) {
            for (OrderDetailVo item : groupItemVo.getBackList()) {
                item.setAmount(item.getPrice().multiply(item.getProductNum()).setScale(6, 4));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) {
            ArrayList giftList = new ArrayList();
            for (OrderDetailVo item : groupItemVo.getGiftList()) {
                item.setAmount(item.getPrice().multiply(item.getProductNum()).setScale(6, 4));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
            ArrayList normalList = new ArrayList();
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                item.setAmount(item.getPrice().multiply(item.getProductNum()).setScale(6, 4));
            }
        }
    }

    public OrderVo calPromotion(OrderVo orderVo, String cusCode, String orgCode) {
        PromotionPolicyConfigInfoQueryVo promotionPolicyConfigInfoQueryVo = this.packagePromotionParm(orderVo, cusCode, orgCode);
        if (null == promotionPolicyConfigInfoQueryVo) {
            return orderVo;
        }
        Map<String, List<PromotionPolicyConfigInfo>> promotionMap = this.promotionPolicyService.loadPromotionPolicyConfigInfoForOrder(promotionPolicyConfigInfoQueryVo);
        return this.calPromotion(orderVo, promotionMap);
    }

    public OrderVo calPromotion(OrderVo orderVo, Map<String, List<PromotionPolicyConfigInfo>> promotionMap) {
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
                return orderVo;
            }
            BigDecimal promotionAmount = BigDecimal.ZERO;
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                StringBuilder stb;
                if (StringUtils.isEmpty((CharSequence)item.getPromotionPolicyCode())) continue;
                PromotionPolicyConfigInfo promotionPolicyConfigInfo = OrderUtil.findPromotionByCode(promotionMap.get(item.getProductCode()), item.getPromotionPolicyCode());
                if (null == promotionPolicyConfigInfo) {
                    orderVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb2 = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(item.getProductName()).append("\u3011\u4e0d\u53ef\u7528\uff01");
                    item.setCalSucessMsg(stb2.toString());
                    groupItemVo.setGiftList(new ArrayList());
                    continue;
                }
                CalculateRuleResponse calculateRuleResponse = promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse();
                if (null == calculateRuleResponse.getResultData()) {
                    orderVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(item.getProductName()).append("\u3011\u672c\u54c1\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff01").append(calculateRuleResponse.getNoLadderMatchMsg());
                    item.setCalSucessMsg(stb.toString());
                    item.setPromotionPolicyCode("");
                    item.setPromotionPolicyName("");
                    if (!promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())) continue;
                    groupItemVo.setGiftList(new ArrayList());
                    continue;
                }
                if (promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())) {
                    item.setAmount(item.getAmount().subtract(calculateRuleResponse.getResultData()).setScale(6, 4));
                    promotionAmount = promotionAmount.add(calculateRuleResponse.getResultData());
                    continue;
                }
                if (promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.DISCOUNT.getCode())) {
                    item.setAmount(item.getAmount().multiply(calculateRuleResponse.getResultData()).setScale(6, 4));
                    promotionAmount = promotionAmount.add(item.getAmount().multiply(BigDecimal.ONE.subtract(calculateRuleResponse.getResultData())).setScale(6, 4));
                    continue;
                }
                if (promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.SPECIALPRICE.getCode())) {
                    BigDecimal oldAmount = item.getAmount();
                    item.setAmount(item.getProductNum().multiply(calculateRuleResponse.getResultData()).setScale(6, 4));
                    promotionAmount = promotionAmount.add(oldAmount.subtract(item.getAmount()));
                    continue;
                }
                if (!promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())) continue;
                if (!this.validateGift(groupItemVo.getGiftList(), promotionPolicyConfigInfo.getProductsGift(), calculateRuleResponse)) {
                    orderVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(item.getProductName()).append("\u3011\u8d60\u54c1\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01").append(calculateRuleResponse.getNoLadderMatchMsg());
                    item.setCalSucessMsg(stb.toString());
                    item.setPromotionPolicyCode("");
                    item.setPromotionPolicyName("");
                    groupItemVo.setGiftList(new ArrayList());
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) continue;
                for (OrderDetailVo gift : groupItemVo.getGiftList()) {
                    promotionAmount = promotionAmount.add(gift.getProductNum().multiply(gift.getPrice()).setScale(6, 4));
                }
            }
            groupItemVo.setPromotionAmount(promotionAmount);
        }
        return orderVo;
    }

    public PromotionPolicyConfigInfoQueryVo packagePromotionParm(OrderVo orderVo, String cusCode, String orgCode) {
        PromotionPolicyConfigInfoQueryVo promotionPolicyConfigInfoQueryVo = new PromotionPolicyConfigInfoQueryVo();
        promotionPolicyConfigInfoQueryVo.setCustCode(cusCode);
        promotionPolicyConfigInfoQueryVo.setOrgCode(orgCode);
        ArrayList<PromotionPolicyConfigInfoQueryVo.ProductOrderInfo> orderProductInfos = new ArrayList<PromotionPolicyConfigInfoQueryVo.ProductOrderInfo>();
        promotionPolicyConfigInfoQueryVo.setOrderProductInfos(orderProductInfos);
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
                return null;
            }
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                if (StringUtils.isEmpty((CharSequence)item.getPromotionPolicyCode())) continue;
                PromotionPolicyConfigInfoQueryVo.ProductOrderInfo productOrderInfo = new PromotionPolicyConfigInfoQueryVo.ProductOrderInfo();
                productOrderInfo.setProductCode(item.getProductCode());
                productOrderInfo.setProductBuyNo(item.getProductNum());
                productOrderInfo.setProductBuyAmount(item.getAmount());
                orderProductInfos.add(productOrderInfo);
            }
        }
        if (CollectionUtils.isEmpty(orderProductInfos)) {
            return null;
        }
        return promotionPolicyConfigInfoQueryVo;
    }

    public boolean validateGift(List<OrderDetailVo> giftList, List<MdmProductRespVo> productsGift, CalculateRuleResponse calculateRuleResponse) {
        for (OrderDetailVo item : giftList) {
            MdmProductRespVo gift = OrderUtil.findGiftByProductCode(productsGift, item.getProductCode());
            if (null == gift) {
                return false;
            }
            if (!(calculateRuleResponse.getResultDataType().equals(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode()) ? item.getProductNum().intValue() != calculateRuleResponse.getResultData().intValue() : item.getAmount().compareTo(calculateRuleResponse.getResultData()) != 0)) continue;
            return false;
        }
        return true;
    }

    public static MdmProductRespVo findGiftByProductCode(List<MdmProductRespVo> productsGift, String productCode) {
        if (CollectionUtils.isEmpty(productsGift)) {
            return null;
        }
        for (MdmProductRespVo gift : productsGift) {
            if (!gift.getProductCode().equals(productCode)) continue;
            return gift;
        }
        return null;
    }

    public static PromotionPolicyConfigInfo findPromotionByCode(List<PromotionPolicyConfigInfo> promotionPolicyConfigInfos, String promotionCode) {
        if (CollectionUtils.isEmpty(promotionPolicyConfigInfos)) {
            return null;
        }
        for (PromotionPolicyConfigInfo info : promotionPolicyConfigInfos) {
            if (!info.getPromotionPolicyInfoVo().getPromotionPolicyCode().equals(promotionCode)) continue;
            return info;
        }
        return null;
    }

    public BigDecimal calNormalAndGiftTotalAmount(OrderVo orderVo) {
        BigDecimal reNum = BigDecimal.ZERO;
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (!CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
                for (OrderDetailVo item : groupItemVo.getNormalList()) {
                    reNum.add(item.getAmount());
                }
            }
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) continue;
            for (OrderDetailVo item : groupItemVo.getGiftList()) {
                reNum.add(item.getAmount());
            }
        }
        return reNum;
    }

    public static FeePoolAmountQueryReqVo packageFeeParam(OrderVo orderVo, String cusCode) {
        FeePoolAmountQueryReqVo vo = new FeePoolAmountQueryReqVo();
        vo.setCustomerCode(cusCode);
        ArrayList<String> poolCodeList = new ArrayList<String>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                poolCodeList.add(itemVo.getFeeCode());
            }
        }
        vo.setPoolCodeList(poolCodeList);
        return vo;
    }

    public OrderVo calRep(OrderVo orderVo, String cusCode, String orgCode, BigDecimal normalAndGiftTotalAmount) {
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = this.packageOrderFeeRepParam(orderVo, cusCode, orgCode, normalAndGiftTotalAmount);
        if (null == orderFeeRateCalToRepVo) {
            return orderVo;
        }
        Map<String, BigDecimal> feeMap = this.orderFeeRateService.calToRep(orderFeeRateCalToRepVo);
        Map<String, BigDecimal> useFeeMap = this.totalUseFee(orderVo);
        for (Map.Entry<String, BigDecimal> entry : useFeeMap.entrySet()) {
            String key = entry.getKey();
            String[] keys = key.split(",");
            String productCode = keys[0];
            String productName = keys[1];
            BigDecimal maxFee = feeMap.get(productCode);
            if (null == maxFee || maxFee.compareTo(entry.getValue()) >= 0) continue;
            orderVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
            orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
            StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u8d27\u8865\u5546\u54c1\u3010").append(productName).append("\u3011\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u989d\u3010").append(maxFee).append("\u5143\u3011,\u8bf7\u8c03\u6574\u6570\u91cf\u6216\u8005\u52a0\u5927\u5546\u54c1\u8d2d\u4e70\u91cf\uff01");
            orderVo.setCalSucessMsg(stb.toString());
        }
        return orderVo;
    }

    public OrderVo calRapFromFee(OrderVo orderVo, Map<String, BigDecimal> poolMap) {
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                StringBuilder stb;
                BigDecimal ableFee = poolMap.get(itemVo.getFeeCode());
                if (null == ableFee) {
                    orderVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    itemVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u8d27\u8865\u5546\u54c1\u3010").append(itemVo.getProductName()).append("\u3011\u5bf9\u5e94\u7684\u8d39\u7528\u3010").append(itemVo.getFeeName()).append("\u3011\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
                    itemVo.setCalSucessMsg(stb.toString());
                    continue;
                }
                if (itemVo.getAmount().compareTo(ableFee) <= 0) continue;
                orderVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                itemVo.setCalSucessMsg(YesNoEnum.yesNoEnum.NO.getValue());
                stb = new StringBuilder("\u63d0\u793a\uff1a\u8d27\u8865\u5546\u54c1\u3010").append(itemVo.getProductName()).append("\u3011\u5df2\u8d85\u8fc7\u8d39\u7528\u3010").append(itemVo.getFeeName()).append("\u3011\u7684\u6700\u5927\u9650\u989d").append(ableFee).append("\u5143\u3011,\u8bf7\u8c03\u6574\u6570\u91cf\u6216\u8005\u52a0\u5927\u5546\u54c1\u8d2d\u4e70\u91cf\uff01");
                itemVo.setCalSucessMsg(stb.toString());
            }
        }
        return orderVo;
    }

    public Map<String, BigDecimal> totalUseFee(OrderVo orderVo) {
        HashMap<String, BigDecimal> useFeeMap = new HashMap<String, BigDecimal>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                BigDecimal useFee = useFeeMap.get(OrderUtil.splicingProductCodeAndName(itemVo.getProductCode(), itemVo.getProductName())) == null ? BigDecimal.ZERO : (BigDecimal)useFeeMap.get(itemVo.getProductCode());
                useFeeMap.put(itemVo.getProductCode(), useFee.add(itemVo.getAmount()));
            }
        }
        return useFeeMap;
    }

    public static String splicingProductCodeAndName(String productCode, String productName) {
        return productCode + "," + productName;
    }

    public OrderFeeRateCalToRepVo packageOrderFeeRepParam(OrderVo orderVo, String cusCode, String orgCode, BigDecimal normalAndGiftTotalAmount) {
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = new OrderFeeRateCalToRepVo();
        orderFeeRateCalToRepVo.setCusCode(cusCode);
        orderFeeRateCalToRepVo.setOrgCode(orgCode);
        orderFeeRateCalToRepVo.setOrderMoney(normalAndGiftTotalAmount);
        ArrayList<OrderFeeRateCalToRepProductVo> products = new ArrayList<OrderFeeRateCalToRepProductVo>();
        orderFeeRateCalToRepVo.setProducts(products);
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                OrderFeeRateCalToRepProductVo orderFeeRateCalToRepProductVo = new OrderFeeRateCalToRepProductVo();
                orderFeeRateCalToRepProductVo.setProductCode(itemVo.getProductCode());
                orderFeeRateCalToRepProductVo.setProductLevelCode(itemVo.getProductLevelCode());
                products.add(orderFeeRateCalToRepProductVo);
            }
        }
        if (CollectionUtils.isEmpty(products)) {
            return null;
        }
        return orderFeeRateCalToRepVo;
    }

    public BigDecimal calCashFee(String cusCode, String orgCode, BigDecimal normalAndGiftTotalAmount) {
        OrderFeeRateCalToCashVo orderFeeRateCalToCashVo = new OrderFeeRateCalToCashVo();
        orderFeeRateCalToCashVo.setCusCode(cusCode);
        orderFeeRateCalToCashVo.setOrgCode(orgCode);
        orderFeeRateCalToCashVo.setOrderMoney(normalAndGiftTotalAmount);
        BigDecimal maxCashFee = this.orderFeeRateService.calToCash(orderFeeRateCalToCashVo);
        return maxCashFee;
    }

    public OrderVo calOrder(OrderVo orderVo, BigDecimal maxCashFee, BigDecimal ablecashFee) {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal promotionAmount = BigDecimal.ZERO;
        BigDecimal giftAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal repAmount = BigDecimal.ZERO;
        BigDecimal actualAmount = BigDecimal.ZERO;
        for (OrderGroupItemVo orderGroupItemVo : orderVo.getGroupItemVos()) {
            promotionAmount = promotionAmount.add(orderGroupItemVo.getPromotionAmount());
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getBackList())) {
                for (OrderDetailVo item : orderGroupItemVo.getBackList()) {
                    repAmount = repAmount.add(item.getAmount());
                    amount = amount.add(item.getAmount());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getGiftList())) {
                for (OrderDetailVo item : orderGroupItemVo.getGiftList()) {
                    amount = amount.add(item.getAmount());
                    giftAmount = giftAmount.add(item.getAmount());
                }
            }
            if (CollectionUtils.isEmpty((Collection)orderGroupItemVo.getNormalList())) continue;
            for (OrderDetailVo item : orderGroupItemVo.getNormalList()) {
                amount = amount.add(item.getAmount());
            }
        }
        amount = amount.add(promotionAmount);
        actualAmount = amount.subtract(promotionAmount).subtract(repAmount);
        ablecashFee = ablecashFee == null ? BigDecimal.ZERO : ablecashFee;
        maxCashFee = maxCashFee == null ? actualAmount : maxCashFee;
        BigDecimal bigDecimal = maxCashFee = ablecashFee.compareTo(maxCashFee) > 0 ? maxCashFee : ablecashFee;
        if (maxCashFee.compareTo(actualAmount) >= 0) {
            discountAmount = actualAmount;
            actualAmount = BigDecimal.ZERO;
        } else {
            discountAmount = maxCashFee;
            actualAmount = actualAmount.subtract(discountAmount);
        }
        orderVo.setAmount(amount.setScale(2, 4));
        orderVo.setPromotionAmount(promotionAmount.setScale(2, 4));
        orderVo.setDiscountAmount(discountAmount.setScale(2, 4));
        orderVo.setRepAmount(repAmount.setScale(2, 4));
        orderVo.setActualAmount(actualAmount.setScale(2, 4));
        return orderVo;
    }

    public OrderEntity packageOrderHead(OrderVo orderVo) {
        OrderEntity orderEntity = new OrderEntity();
        BeanUtils.copyProperties((Object)orderVo, (Object)((Object)orderEntity));
        orderEntity.setOrderCode(CodeUtil.getCodeDefault());
        return orderEntity;
    }

    public OrderVo createLineAndSort(OrderVo orderVo) {
        int groupNum = 1;
        int lineNum = 1;
        for (OrderGroupItemVo orderGroupItemVo : orderVo.getGroupItemVos()) {
            String groupCode = OrderCodeUtil.fullFour(groupNum);
            orderGroupItemVo.setGroupCode(groupCode);
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getBackList())) {
                for (OrderDetailVo item : orderGroupItemVo.getBackList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    ++lineNum;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getNormalList())) {
                for (OrderDetailVo item : orderGroupItemVo.getNormalList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    ++lineNum;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getGiftList())) {
                for (OrderDetailVo item : orderGroupItemVo.getGiftList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    ++lineNum;
                }
            }
            ++groupNum;
        }
        return OrderUtil.sort(orderVo);
    }

    public static OrderVo sort(OrderVo orderVo) {
        List groupItemVos = orderVo.getGroupItemVos();
        groupItemVos = groupItemVos.stream().sorted(Comparator.comparing(OrderGroupItemVo::getGroupCode)).collect(Collectors.toList());
        for (OrderGroupItemVo orderGroupItemVo : groupItemVos) {
            List list;
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getBackList())) {
                list = orderGroupItemVo.getBackList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
                orderGroupItemVo.setBackList(list);
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getNormalList())) {
                list = orderGroupItemVo.getNormalList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
                orderGroupItemVo.setNormalList(list);
            }
            if (CollectionUtils.isEmpty((Collection)orderGroupItemVo.getGiftList())) continue;
            list = orderGroupItemVo.getGiftList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
            orderGroupItemVo.setGiftList(list);
        }
        orderVo.setGroupItemVos(groupItemVos);
        return orderVo;
    }
}

