/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.mdm.availablelist.AvailableListFeign;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.minbuynumofproduct.service.MinBuyNumOfProductService;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;
import com.biz.crm.nebular.dms.order.CalMinBuyNumDo;
import com.biz.crm.nebular.dms.order.OrderFileVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseBackAllReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceReqVo;
import com.biz.crm.order.entity.OrderDetailEntity;
import com.biz.crm.order.entity.OrderEntity;
import com.biz.crm.order.mapper.OrderMapper;
import com.biz.crm.order.service.OrderDetailService;
import com.biz.crm.order.service.OrderFileService;
import com.biz.crm.order.service.OrderService;
import com.biz.crm.order.utils.OrderUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderServiceExpandImpl"})
@Service(value="orderService")
public class OrderServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<OrderMapper, OrderEntity>
implements OrderService {
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private OrderDetailService orderDetailService;
    @Resource
    private OrderFileService orderFileService;
    @Resource
    private OrderUtil orderUtil;
    @Resource
    private MinBuyNumOfProductService minBuyNumOfProductService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private MdmProductFeign mdmProductFeign;
    @Autowired
    private FeePoolFeign feePoolFeign;
    @Autowired
    private AvailableListFeign availableListFeign;

    @Override
    public OrderVo cal(OrderVo orderVo, boolean orderFalg) {
        Map productMap;
        Map productMsp;
        Map<String, MinBuyNumOfProductVo> minBuyNumOfProductEntityMap;
        this.orderUtil.validateForCal(orderVo);
        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
        String cusCode = orderVo.getCusCode();
        String orgCode = "";
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)this.mdmCustomerMsgFeign.query(null, cusCode).getResult();
        orderVo.setCusOrgCode(mdmCustomerMsgRespVo.getOrgCode());
        orderVo.setCusOrgName(mdmCustomerMsgRespVo.getOrgName());
        orgCode = mdmCustomerMsgRespVo.getOrgCode();
        Map<String, CalMinBuyNumDo> productNumMap = OrderUtil.extractProductCodes(orderVo);
        ArrayList<String> productCodes = new ArrayList<String>(productNumMap.keySet());
        orderVo = this.orderUtil.createLineAndSort(orderVo);
        if (orderFalg && (orderVo = OrderUtil.validateMinBuyNum(orderVo, productNumMap, minBuyNumOfProductEntityMap = this.minBuyNumOfProductService.findByCusCodeAndProductCodesToCus(cusCode, orgCode, productCodes))).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        Map<String, List<String>> productCodeMap = this.orderUtil.extractProductCodesToMap(orderVo);
        List<String> otherProductCode = productCodeMap.get("other");
        List<String> nomalProductCode = productCodeMap.get("nomal");
        if (!CollectionUtils.isEmpty(otherProductCode) && (orderVo = this.orderUtil.packageProductMsg(orderVo, productMsp = (Map)this.mdmProductFeign.queryByProductCodeAndCus(MdmProductAdviseAndPriceReqVo.newInstanceForSalePrice((String)cusCode, (String)orgCode, otherProductCode)).getResult())).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        if (!CollectionUtils.isEmpty(nomalProductCode) && (orderVo = this.orderUtil.packageProductMsgForNormal(orderVo, productMap = (Map)this.availableListFeign.findGoodsByCusAndGoodsCodes(nomalProductCode, cusCode).getResult())).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        orderVo = this.orderUtil.calItemPrice(orderVo);
        if ((orderVo = this.orderUtil.calPromotion(orderVo, cusCode, orgCode)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        BigDecimal normalAndGiftTotalAmount = this.orderUtil.calNormalAndGiftTotalAmount(orderVo);
        FeePoolAmountQueryReqVo feePoolAmountQueryReqVo = OrderUtil.packageFeeParam(orderVo, cusCode);
        FeePoolAmountQueryRespVo feePoolAmountQueryRespVo = (FeePoolAmountQueryRespVo)this.feePoolFeign.queryPoolAmount(feePoolAmountQueryReqVo).getResult();
        if ((orderVo = this.orderUtil.calRep(orderVo, cusCode, orgCode, normalAndGiftTotalAmount)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        if ((orderVo = this.orderUtil.calRapFromFee(orderVo, feePoolAmountQueryRespVo.getPoolUsableAmountMap())).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        BigDecimal maxCashFee = this.orderUtil.calCashFee(cusCode, orgCode, normalAndGiftTotalAmount);
        orderVo = this.orderUtil.calOrder(orderVo, maxCashFee, feePoolAmountQueryRespVo.getDiscountUsableAmount());
        return this.orderUtil.createLineAndSort(orderVo);
    }

    @Override
    @Transactional
    public void temporaryAdd(OrderVo orderVo) {
        this.cal(orderVo, true);
        if (orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            String msg = orderVo.getCalSucessMsg();
            if (StringUtils.isEmpty((String)orderVo.getCalSucessMsg())) {
                msg = "\u8ba2\u5355\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u68c0\u67e5\uff01";
            }
            throw new BusinessException(msg);
        }
        orderVo.setState(OrderEunm.STATE.TOSUBMIT.getCode());
        OrderEntity orderEntity = this.orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.YES.getValue());
        this.save((Object)orderEntity);
        this.orderDetailService.addBatch(orderVo, orderEntity, true);
        this.orderFileService.replace(orderEntity.getOrderCode(), orderVo.getFiles());
    }

    @Override
    public void edit(OrderVo orderVo) {
        if (StringUtils.isEmpty((String)orderVo.getId())) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderMapper.selectById((Serializable)((Object)orderVo.getId())));
        if ((orderVo = this.cal(orderVo, true)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            String msg = orderVo.getCalSucessMsg();
            if (StringUtils.isEmpty((String)orderVo.getCalSucessMsg())) {
                msg = "\u8ba2\u5355\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u68c0\u67e5\uff01";
            }
            throw new BusinessException(msg);
        }
        orderEntity = this.orderUtil.packageOrderHeadForEndit(orderVo, orderEntity);
        this.updateById((Object)orderEntity);
        this.orderDetailService.editBatch(orderVo, orderEntity, !orderVo.getTemporaryFlag().equals(YesNoEnum.yesNoEnum.YES.getValue()));
        this.orderFileService.replace(orderEntity.getOrderCode(), orderVo.getFiles());
    }

    @Override
    @Transactional
    public void add(OrderVo orderVo) {
        if (orderVo.getTemporaryFlag().equals(YesNoEnum.yesNoEnum.YES.getValue())) {
            this.delByOrderCode(orderVo.getOrderCode());
        }
        if ((orderVo = this.cal(orderVo, true)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            String msg = orderVo.getCalSucessMsg();
            if (StringUtils.isEmpty((String)orderVo.getCalSucessMsg())) {
                msg = "\u8ba2\u5355\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u8fd4\u56de\u68c0\u67e5\u8ba2\u5355\u884c\u9519\u8bef\u4fe1\u606f\uff01";
            }
            throw new BusinessException(msg);
        }
        orderVo.setState(OrderEunm.STATE.TOAPPROVAL.getCode());
        orderVo.setId("");
        OrderEntity orderEntity = this.orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.NO.getValue());
        this.save((Object)orderEntity);
        List<OrderDetailEntity> detailEntities = this.orderDetailService.addBatch(orderVo, orderEntity, true);
        this.orderFileService.replace(orderEntity.getOrderCode(), orderVo.getFiles());
        FeePoolUseReqVo feeUseParam = this.orderUtil.packageFeeUseParam(orderEntity, detailEntities);
        Result result = this.feePoolFeign.usePool(feeUseParam);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMessage());
        }
    }

    @Override
    public void delByOrderCode(String orderCode) {
        if (StringUtils.isEmpty((String)orderCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8981\u5220\u9664\u7684\u8ba2\u5355\uff01");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_code", (Object)orderCode);
        this.orderMapper.delete((Wrapper)wrapper);
        this.orderDetailService.deleByOrderCode(orderCode);
        this.orderFileService.deleByOrderCode(orderCode);
    }

    @Override
    public void cancel(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.updateStateByIds(ids, OrderEunm.STATE.CANCEL);
        List orderEntities = this.orderMapper.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)orderEntities)) {
            return;
        }
        ArrayList<FeePoolUseBackAllReqVo> params = new ArrayList<FeePoolUseBackAllReqVo>();
        for (OrderEntity order : orderEntities) {
            if (!order.getTemporaryFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) continue;
            FeePoolUseBackAllReqVo feePoolUseBackAllReqVo = new FeePoolUseBackAllReqVo();
            feePoolUseBackAllReqVo.setFromCode(order.getOrderCode());
            feePoolUseBackAllReqVo.setOperationType(FeePoolOperationTypeEnum.ORDER_BACK.getValue());
            params.add(feePoolUseBackAllReqVo);
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        if (!this.feePoolFeign.backAllUseByFromCodeBatch(params).isSuccess()) {
            throw new BusinessException("\u8d39\u7528\u56de\u9000\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u8d39\u7528\u6c60");
        }
    }

    @Override
    @Transactional
    public void updateStateByIds(List<String> ids, OrderEunm.STATE state) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.orderMapper.updateStateByIds(state.getCode(), ids);
    }

    @Override
    public OrderVo findDetailsById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        OrderEntity entity = (OrderEntity)((Object)this.orderMapper.selectById((Serializable)((Object)id)));
        OrderVo vo = (OrderVo)CrmBeanUtil.copy((Object)((Object)entity), OrderVo.class);
        if (vo == null) {
            return null;
        }
        List<OrderFileVo> files = this.orderFileService.findByOrderCode(vo.getOrderCode());
        vo.setFiles(files);
        List<OrderGroupItemVo> groupItemVos = this.orderDetailService.findGroupByOrderCode(vo.getOrderCode());
        vo.setGroupItemVos(groupItemVos);
        return this.cal(vo, false);
    }

    @Override
    public PageResult<OrderVo> listByConditions(OrderVo orderVo) {
        Page page = new Page((long)orderVo.getPageNum().intValue(), (long)orderVo.getPageSize().intValue());
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(StringUtils.isNotEmpty((String)orderVo.getOrderCode()), (Object)"order_code", (Object)orderVo.getOrderCode())).eq(StringUtils.isNotEmpty((String)orderVo.getState()), (Object)"state", (Object)orderVo.getState())).eq(StringUtils.isNotEmpty((String)orderVo.getFromType()), (Object)"from_type", (Object)orderVo.getFromType())).eq(StringUtils.isNotEmpty((String)orderVo.getCusCode()), (Object)"cus_code", (Object)orderVo.getCusCode())).like(StringUtils.isNotEmpty((String)orderVo.getCusName()), (Object)"cus_name", (Object)orderVo.getCusName())).eq(orderVo.getTemporaryFlag() != null, (Object)"temporary_flag", (Object)orderVo.getTemporaryFlag());
        queryWrapper.orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        List<OrderVo> list = this.orderMapper.list((Page<OrderVo>)page, (QueryWrapper<OrderVo>)queryWrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

