/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.function.impl;

import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.AbstractConditionRuleFunction;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import com.biz.crm.util.CommonConstant;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="conditionAmountAmount")
public class ConditionAmountAmount
extends AbstractConditionRuleFunction<ConditionRuleParam, ConditionRuleResponse> {
    public static final String FUNC_BODY = "conditionAmountAmount";
    @Resource
    private LadderResolverHelper ladderResolverHelper;

    @Override
    public ConditionRuleResponse apply(ConditionRuleParam conditionRuleParam) {
        AbstractConditionRuleLadderResolver ladderResolver = this.ladderResolverHelper.getResolverByFuncBody(FUNC_BODY);
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = conditionRuleParam.getProductOrderBuy();
        BigDecimal productBuyAmount = BigDecimal.ZERO;
        if (null != productOrderBuy) {
            for (RuleExecuteParam.ProductOrderBuy v : productOrderBuy) {
                productBuyAmount = productBuyAmount.add(v.getProductBuyAmount());
            }
        }
        Object response = this.divideAndRemainder(productBuyAmount, ladderResolver.valueAsProductCurrentY(conditionRuleParam.getLadder()));
        ((ConditionRuleResponse)response).setResultDataType(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.AMOUNT.getItemCode());
        ((ConditionRuleResponse)response).setGiftValue(ladderResolver.valueAsProductCurrentN(conditionRuleParam.getLadder()));
        return response;
    }

    @Override
    public String getConditionType() {
        return CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.AMOUNT.getItemCode();
    }
}

