/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.handler;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.MinBuyNumOfProductEunm;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.minbuynumofproduct.service.MinBuyNumOfProductService;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;
import com.biz.crm.nebular.dms.order.CalMinBuyNumDo;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderMinBuyNumHandlerExpand"})
@Component(value="orderMinBuyNumHandler")
public class OrderMinBuyNumHandler {
    @Resource
    private MinBuyNumOfProductService minBuyNumOfProductService;

    public OrderVo handle(OrderVo orderVo, String cusCode, String orgCode) {
        Map<String, CalMinBuyNumDo> productNumMap = this.extractProductCodes(orderVo);
        ArrayList<String> productCodes = new ArrayList<String>(productNumMap.keySet());
        Map<String, MinBuyNumOfProductVo> minBuyNumOfProductEntityMap = this.minBuyNumOfProductService.findByCusCodeAndProductCodesToCus(cusCode, orgCode, productCodes);
        orderVo = this.validateMinBuyNum(orderVo, productNumMap, minBuyNumOfProductEntityMap);
        return orderVo;
    }

    public OrderVo validateMinBuyNum(OrderVo orderVo, Map<String, CalMinBuyNumDo> productNumMap, Map<String, MinBuyNumOfProductVo> minBuyNumOfProductEntityMap) {
        for (Map.Entry<String, CalMinBuyNumDo> entry : productNumMap.entrySet()) {
            CalMinBuyNumDo calMinBuyNumDo = entry.getValue();
            MinBuyNumOfProductVo minBuyNumOfProductVo = minBuyNumOfProductEntityMap.get(entry.getKey());
            if (null == minBuyNumOfProductVo) continue;
            Integer buyNum = calMinBuyNumDo.getNum();
            if (MinBuyNumOfProductEunm.verificationModeEunm.NORMALANDGIFT.getCode().equals(minBuyNumOfProductVo.getVerificationMode())) {
                buyNum = buyNum + calMinBuyNumDo.getGiftNum();
            }
            if (new BigDecimal(buyNum).compareTo(new BigDecimal(minBuyNumOfProductVo.getMinOrderQuantity())) >= 0) continue;
            orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
            orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
            StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u5546\u54c1\u3010").append(calMinBuyNumDo.getProductName()).append("\u3011\u4e0d\u6ee1\u8db3\u8d77\u8ba2\u91cf").append(",\u8d77\u8ba2\u91cf\u4e3a:").append(minBuyNumOfProductVo.getMinOrderQuantity()).append(minBuyNumOfProductVo.getUnitName());
            orderVo.setCalSucessMsg(stb.toString());
        }
        return orderVo;
    }

    public Map<String, CalMinBuyNumDo> extractProductCodes(OrderVo orderVo) {
        HashMap<String, CalMinBuyNumDo> reMap = new HashMap<String, CalMinBuyNumDo>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            CalMinBuyNumDo calMinBuyNumDo;
            if (!CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) {
                for (OrderDetailVo item : groupItemVo.getBackList()) {
                    calMinBuyNumDo = (CalMinBuyNumDo)reMap.get(item.getProductCode());
                    if (calMinBuyNumDo == null) {
                        reMap.put(item.getProductCode(), CalMinBuyNumDo.newInstance((Integer)item.getProductNum().intValue(), (Integer)0, (String)item.getProductName(), (String)item.getProductCode()));
                        continue;
                    }
                    calMinBuyNumDo.setNum(Integer.valueOf(calMinBuyNumDo.getNum() + item.getProductNum().intValue()));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) {
                for (OrderDetailVo item : groupItemVo.getGiftList()) {
                    calMinBuyNumDo = (CalMinBuyNumDo)reMap.get(item.getProductCode());
                    if (calMinBuyNumDo == null) {
                        reMap.put(item.getProductCode(), CalMinBuyNumDo.newInstance((Integer)0, (Integer)item.getProductNum().intValue(), (String)item.getProductName(), (String)item.getProductCode()));
                        continue;
                    }
                    calMinBuyNumDo.setGiftNum(Integer.valueOf(calMinBuyNumDo.getGiftNum() + item.getProductNum().intValue()));
                }
            }
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) continue;
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                calMinBuyNumDo = (CalMinBuyNumDo)reMap.get(item.getProductCode());
                if (calMinBuyNumDo == null) {
                    reMap.put(item.getProductCode(), CalMinBuyNumDo.newInstance((Integer)item.getProductNum().intValue(), (Integer)0, (String)item.getProductName(), (String)item.getProductCode()));
                    continue;
                }
                calMinBuyNumDo.setNum(Integer.valueOf(calMinBuyNumDo.getNum() + item.getProductNum().intValue()));
            }
        }
        return reMap;
    }
}

