/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.strategy.calorder.impl;

import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.tools.strategy.calorder.CalOrderStrategy;
import java.math.BigDecimal;
import java.util.Collection;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"freeCalOrderStrategyExpand"})
@Component(value="freeCalOrderStrategy")
public class FreeCalOrderStrategy
implements CalOrderStrategy {
    @Override
    public OrderVo cal(OrderVo orderVo, String cusCode, String orgCode, Object ... objects) {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal repAmount = BigDecimal.ZERO;
        for (OrderGroupItemVo orderGroupItemVo : orderVo.getGroupItemVos()) {
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getBackList())) {
                for (OrderDetailVo item : orderGroupItemVo.getBackList()) {
                    repAmount = repAmount.add(item.getAmount());
                    amount = amount.add(item.getAmount());
                }
            }
            if (CollectionUtils.isEmpty((Collection)orderGroupItemVo.getNormalList())) continue;
            for (OrderDetailVo item : orderGroupItemVo.getNormalList()) {
                amount = amount.add(item.getAmount());
            }
        }
        orderVo.setAmount(amount.setScale(2, 4));
        orderVo.setDiscountAmount(BigDecimal.ZERO);
        orderVo.setPromotionAmount(BigDecimal.ZERO);
        orderVo.setRepAmount(BigDecimal.ZERO);
        orderVo.setActualAmount(BigDecimal.ZERO);
        return orderVo;
    }
}

