/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.listener.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.mdm.availablelistrule.AvailableListRuleFeign;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="contractAvailableGoodsListener")
@ConditionalOnMissingBean(name={"contractAvailableGoodsListenerExtend"})
public class ContractAvailableGoodsListener
implements AbstractContractModelListener {
    @Resource
    private AvailableListRuleFeign availableListRuleFeign;

    @Override
    @Transactional
    public JSONArray add(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)saleContractVo, (String)"\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a");
        List<AvailableListRuleVo> vos = BeanCopyUtil.parseByJSONArray(data, AvailableListRuleVo.class);
        ValidateUtils.isTrue((boolean)CollectionUtil.listNotEmpty(vos), (String)"\u53ef\u8d2d\u5546\u54c1\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        AvailableListRuleVo availableListRuleVo = vos.get(0);
        if (!StringUtils.isEmpty((String)availableListRuleVo.getId())) {
            return this.edit(data, contractCode, jsonName, saleContractVo, indexCode);
        }
        availableListRuleVo.setSourceId(contractCode);
        AvailableListRuleAreaVo areaVo = new AvailableListRuleAreaVo();
        areaVo.setCusOrgCode(saleContractVo.getOrgCode());
        areaVo.setCusOrgName(saleContractVo.getOrgName());
        areaVo.setCusCode(saleContractVo.getCusCode());
        areaVo.setCusName(saleContractVo.getCusName());
        areaVo.setCusChannelCode(saleContractVo.getChannelCode());
        areaVo.setCusChannelName(saleContractVo.getChannelName());
        ArrayList areaVos = Lists.newArrayList((Object[])new AvailableListRuleAreaVo[]{areaVo});
        availableListRuleVo.setAreaes((List)areaVos);
        Result result = this.availableListRuleFeign.addForConstract(availableListRuleVo);
        ValidateUtils.isTrue((boolean)result.isSuccess(), (String)("\u8c03\u7528\u53ef\u8d2d\u63a5\u53e3\u5931\u8d25\uff1a" + result.getMessage()), (Object[])new Object[0]);
        JSONArray jsonArray = BeanCopyUtil.formatJSONArray(Lists.newArrayList((Object[])new Result[]{result}));
        return jsonArray;
    }

    @Override
    @Transactional
    public JSONArray edit(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)saleContractVo, (String)"\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a");
        List<AvailableListRuleVo> vos = BeanCopyUtil.parseByJSONArray(data, AvailableListRuleVo.class);
        ValidateUtils.isTrue((boolean)CollectionUtil.listNotEmpty(vos), (String)"\u53ef\u8d2d\u5546\u54c1\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        AvailableListRuleVo availableListRuleVo = vos.get(0);
        if (StringUtils.isEmpty((String)availableListRuleVo.getId())) {
            return this.add(data, contractCode, jsonName, saleContractVo, indexCode);
        }
        availableListRuleVo.setSourceId(contractCode);
        AvailableListRuleAreaVo areaVo = new AvailableListRuleAreaVo();
        areaVo.setCusOrgCode(saleContractVo.getOrgCode());
        areaVo.setCusOrgName(saleContractVo.getOrgName());
        areaVo.setCusCode(saleContractVo.getCusCode());
        areaVo.setCusName(saleContractVo.getCusName());
        areaVo.setCusChannelCode(saleContractVo.getChannelCode());
        areaVo.setCusChannelName(saleContractVo.getChannelName());
        ArrayList areaVos = Lists.newArrayList((Object[])new AvailableListRuleAreaVo[]{areaVo});
        availableListRuleVo.setAreaes((List)areaVos);
        Result result = this.availableListRuleFeign.edit(availableListRuleVo);
        ValidateUtils.isTrue((boolean)result.isSuccess(), (String)("\u8c03\u7528\u53ef\u8d2d\u63a5\u53e3\u5931\u8d25\uff1a" + result.getMessage()), (Object[])new Object[0]);
        JSONArray jsonArray = BeanCopyUtil.formatJSONArray(Lists.newArrayList((Object[])new Result[]{result}));
        return jsonArray;
    }

    @Override
    public JSONArray findByContractCode(String contractCode, String jsonName, String indexCode) {
        Result result = this.availableListRuleFeign.findBySourceId(contractCode);
        return BeanCopyUtil.formatJSONArray(Lists.newArrayList((Object[])new Result[]{result}));
    }
}

