/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.strategy.validaterebate.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepProductVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.order.tools.strategy.validaterebate.ValidateRebateFeeStrategy;
import com.biz.crm.orderfeerate.service.OrderFeeRateService;
import com.biz.crm.util.Result;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"standerdOrderValidateFeeStategyExpand"})
@Component(value="standerdOrderValidateFeeStategy")
public class StanderdOrderValidateFeeStategy
implements ValidateRebateFeeStrategy {
    @Autowired
    private FeePoolFeign feePoolFeign;
    @Resource
    private OrderFeeRateService orderFeeRateService;

    @Override
    public OrderVo validate(OrderVo orderVo, String cusCode, String orgCode, Object ... objects) {
        BigDecimal normalAndGiftTotalAmount = this.calNormalAndGiftTotalAmount(orderVo);
        if ((orderVo = this.calRep(orderVo, cusCode, orgCode, normalAndGiftTotalAmount)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return orderVo;
        }
        FeePoolAmountQueryReqVo feePoolAmountQueryReqVo = this.packageFeeParam(orderVo, cusCode);
        Result result = this.feePoolFeign.queryPoolAmount(feePoolAmountQueryReqVo);
        if (!result.isSuccess()) {
            throw new BusinessException("\u8d39\u7528\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        FeePoolAmountQueryRespVo feePoolAmountQueryRespVo = (FeePoolAmountQueryRespVo)result.getResult();
        orderVo = this.calRapFromFee(orderVo, feePoolAmountQueryRespVo.getPoolUsableAmountMap());
        return orderVo;
    }

    public FeePoolAmountQueryReqVo packageFeeParam(OrderVo orderVo, String cusCode) {
        FeePoolAmountQueryReqVo vo = new FeePoolAmountQueryReqVo();
        vo.setCustomerCode(cusCode);
        ArrayList<String> poolCodeList = new ArrayList<String>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                poolCodeList.add(itemVo.getFeeCode());
            }
        }
        vo.setPoolCodeList(poolCodeList);
        return vo;
    }

    public OrderVo calRapFromFee(OrderVo orderVo, Map<String, BigDecimal> poolMap) {
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                StringBuilder stb;
                BigDecimal ableFee = poolMap.get(itemVo.getFeeCode());
                if (null == ableFee) {
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    itemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u8d27\u8865\u5546\u54c1\u3010").append(itemVo.getProductName()).append("\u3011\u5bf9\u5e94\u7684\u8d39\u7528\u3010").append(itemVo.getFeeName()).append("\u3011\u5269\u4f59\u4e3a0,\u8bf7\u91cd\u65b0\u9009\u62e9");
                    itemVo.setCalSucessMsg(stb.toString());
                    continue;
                }
                if (itemVo.getAmount().compareTo(ableFee) <= 0) continue;
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                itemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                stb = new StringBuilder("\u63d0\u793a\uff1a\u8d27\u8865\u5546\u54c1\u3010").append(itemVo.getProductName()).append("\u3011\u5df2\u8d85\u8fc7\u8d39\u7528\u3010").append(itemVo.getFeeName()).append("\u3011\u7684\u6700\u5927\u9650\u989d").append(ableFee).append("\u5143\u3011,\u8bf7\u8c03\u6574\u6570\u91cf\u6216\u8005\u52a0\u5927\u5546\u54c1\u8d2d\u4e70\u91cf\uff01");
                itemVo.setCalSucessMsg(stb.toString());
            }
        }
        return orderVo;
    }

    public OrderVo calRep(OrderVo orderVo, String cusCode, String orgCode, BigDecimal normalAndGiftTotalAmount) {
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = this.packageOrderFeeRepParam(orderVo, cusCode, orgCode, normalAndGiftTotalAmount);
        if (null == orderFeeRateCalToRepVo) {
            return orderVo;
        }
        Map<String, BigDecimal> feeMap = this.orderFeeRateService.calToRep(orderFeeRateCalToRepVo);
        Map<String, BigDecimal> useFeeMap = this.totalUseFee(orderVo);
        for (Map.Entry<String, BigDecimal> entry : useFeeMap.entrySet()) {
            String key = entry.getKey();
            String[] keys = key.split(",");
            String productCode = keys[0];
            String productName = keys[1];
            BigDecimal maxFee = feeMap.get(productCode);
            if (null == maxFee || maxFee.compareTo(entry.getValue()) >= 0) continue;
            orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
            orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
            StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u8d27\u8865\u5546\u54c1\u3010").append(productName).append("\u3011\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u989d\u3010").append(maxFee).append("\u5143\u3011,\u8bf7\u8c03\u6574\u6570\u91cf\u6216\u8005\u52a0\u5927\u5546\u54c1\u8d2d\u4e70\u91cf\uff01");
            orderVo.setCalSucessMsg(stb.toString());
        }
        return orderVo;
    }

    public Map<String, BigDecimal> totalUseFee(OrderVo orderVo) {
        HashMap<String, BigDecimal> useFeeMap = new HashMap<String, BigDecimal>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                BigDecimal useFee = useFeeMap.get(StanderdOrderValidateFeeStategy.splicingProductCodeAndName(itemVo.getProductCode(), itemVo.getProductName())) == null ? BigDecimal.ZERO : (BigDecimal)useFeeMap.get(itemVo.getProductCode());
                useFeeMap.put(StanderdOrderValidateFeeStategy.splicingProductCodeAndName(itemVo.getProductCode(), itemVo.getProductName()), useFee.add(itemVo.getAmount()));
            }
        }
        return useFeeMap;
    }

    public static String splicingProductCodeAndName(String productCode, String productName) {
        return productCode + "," + productName;
    }

    public OrderFeeRateCalToRepVo packageOrderFeeRepParam(OrderVo orderVo, String cusCode, String orgCode, BigDecimal normalAndGiftTotalAmount) {
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = new OrderFeeRateCalToRepVo();
        orderFeeRateCalToRepVo.setCusCode(cusCode);
        orderFeeRateCalToRepVo.setOrgCode(orgCode);
        orderFeeRateCalToRepVo.setOrderMoney(normalAndGiftTotalAmount);
        ArrayList<OrderFeeRateCalToRepProductVo> products = new ArrayList<OrderFeeRateCalToRepProductVo>();
        orderFeeRateCalToRepVo.setProducts(products);
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                OrderFeeRateCalToRepProductVo orderFeeRateCalToRepProductVo = new OrderFeeRateCalToRepProductVo();
                orderFeeRateCalToRepProductVo.setProductCode(itemVo.getProductCode());
                orderFeeRateCalToRepProductVo.setProductLevelCode(itemVo.getProductLevelCode());
                products.add(orderFeeRateCalToRepProductVo);
            }
        }
        if (CollectionUtils.isEmpty(products)) {
            return null;
        }
        return orderFeeRateCalToRepVo;
    }

    public BigDecimal calNormalAndGiftTotalAmount(OrderVo orderVo) {
        BigDecimal reNum = BigDecimal.ZERO;
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (!CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
                for (OrderDetailVo item : groupItemVo.getNormalList()) {
                    reNum = reNum.add(item.getAmount());
                }
            }
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) continue;
            for (OrderDetailVo item : groupItemVo.getGiftList()) {
                reNum = reNum.add(item.getAmount());
            }
        }
        return reNum;
    }
}

