/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.companyinformation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.companyinformation.entity.CompanyInformationEntity;
import com.biz.crm.companyinformation.entity.CompanyInformationFileEntity;
import com.biz.crm.companyinformation.mapper.CompanyInformationFileMapper;
import com.biz.crm.companyinformation.service.CompanyInformationFileService;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationFileVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"companyInformationFileServiceExpandImpl"})
@Service(value="companyInformationFileService")
public class CompanyInformationFileServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<CompanyInformationFileMapper, CompanyInformationFileEntity>
implements CompanyInformationFileService {
    @Autowired
    private CompanyInformationFileMapper companyInformationFileMapper;

    @Override
    @Transactional
    public void replace(final CompanyInformationEntity companyInformationEntity, List<CompanyInformationFileVo> files) {
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("information_id", companyInformationEntity.getId());
            }
        });
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        ArrayList<CompanyInformationFileEntity> entities = new ArrayList<CompanyInformationFileEntity>(files.size());
        int i = 0;
        for (CompanyInformationFileVo vo : files) {
            vo.setSortNum(Integer.valueOf(++i));
            CompanyInformationFileEntity entity = new CompanyInformationFileEntity();
            BeanUtils.copyProperties((Object)vo, (Object)entity);
            entity.setInformationId(companyInformationEntity.getId());
            entities.add(entity);
        }
        this.saveBatch(entities);
    }

    @Override
    public List<CompanyInformationFileVo> findByInformationId(String informationId) {
        if (StringUtils.isEmpty((Object)informationId)) {
            return new ArrayList<CompanyInformationFileVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"information_id", (Object)informationId);
        List fileEntities = this.companyInformationFileMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)fileEntities)) {
            return new ArrayList<CompanyInformationFileVo>();
        }
        ArrayList<CompanyInformationFileVo> reList = new ArrayList<CompanyInformationFileVo>(fileEntities.size());
        for (CompanyInformationFileEntity entity : fileEntities) {
            CompanyInformationFileVo vo = new CompanyInformationFileVo();
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            reList.add(vo);
        }
        Collections.sort(reList, (a, b) -> a.getSortNum().compareTo(b.getSortNum()));
        return reList;
    }

    @Override
    public Map<String, List<CompanyInformationFileVo>> findByInformationIds(List<String> informationIds) {
        Map<String, List<CompanyInformationFileVo>> reMap = new HashMap<String, List<CompanyInformationFileVo>>();
        if (CollectionUtils.isEmpty(informationIds)) {
            return reMap;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"information_id", informationIds);
        List fileEntities = this.companyInformationFileMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)fileEntities)) {
            return reMap;
        }
        reMap = fileEntities.stream().map(entity -> {
            CompanyInformationFileVo vo = new CompanyInformationFileVo();
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            return vo;
        }).collect(Collectors.groupingBy(CompanyInformationFileVo::getInformationId));
        for (String informationId : reMap.keySet()) {
            Collections.sort(reMap.get(informationId), (a, b) -> a.getSortNum().compareTo(b.getSortNum()));
        }
        return reMap;
    }

    @Override
    @Transactional
    public void delByInformationIds(List<String> informationIds) {
        if (CollectionUtils.isEmpty(informationIds)) {
            throw new BusinessException("\u516c\u53f8\u8d44\u6599id\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"information_id", informationIds);
        this.companyInformationFileMapper.delete((Wrapper)wrapper);
    }
}

