/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.utils;

import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.entity.OrderEntity;
import com.biz.crm.order.utils.OrderCodeUtil;
import com.biz.crm.util.CodeUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderUtilExpand"})
@Component(value="orderUtil")
public class OrderUtil {
    public OrderEntity packageOrderHead(OrderVo orderVo) {
        OrderEntity orderEntity = new OrderEntity();
        BeanUtils.copyProperties((Object)orderVo, (Object)orderEntity);
        orderEntity.setOrderCode(CodeUtil.getCodeDefault());
        return orderEntity;
    }

    public OrderEntity packageOrderHeadForEndit(OrderVo orderVo, OrderEntity orderEntity) {
        String id = orderEntity.getId();
        String orderCode = orderEntity.getOrderCode();
        BeanUtils.copyProperties((Object)orderVo, (Object)orderEntity);
        orderEntity.setId(id);
        orderEntity.setOrderCode(orderCode);
        return orderEntity;
    }

    public OrderVo createLineAndSort(OrderVo orderVo) {
        int groupNum = 1;
        int lineNum = 1;
        for (OrderGroupItemVo orderGroupItemVo : orderVo.getGroupItemVos()) {
            String groupCode = OrderCodeUtil.fullFour(groupNum);
            orderGroupItemVo.setGroupCode(groupCode);
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getBackList())) {
                for (OrderDetailVo item : orderGroupItemVo.getBackList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    ++lineNum;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getNormalList())) {
                for (OrderDetailVo item : orderGroupItemVo.getNormalList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    ++lineNum;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getGiftList())) {
                for (OrderDetailVo item : orderGroupItemVo.getGiftList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    ++lineNum;
                }
            }
            ++groupNum;
        }
        return OrderUtil.sort(orderVo);
    }

    public static OrderVo sort(OrderVo orderVo) {
        List groupItemVos = orderVo.getGroupItemVos();
        groupItemVos = groupItemVos.stream().sorted(Comparator.comparing(OrderGroupItemVo::getGroupCode)).collect(Collectors.toList());
        for (OrderGroupItemVo orderGroupItemVo : groupItemVos) {
            List list;
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getBackList())) {
                list = orderGroupItemVo.getBackList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
                orderGroupItemVo.setBackList(list);
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getNormalList())) {
                list = orderGroupItemVo.getNormalList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
                orderGroupItemVo.setNormalList(list);
            }
            if (CollectionUtils.isEmpty((Collection)orderGroupItemVo.getGiftList())) continue;
            list = orderGroupItemVo.getGiftList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
            orderGroupItemVo.setGiftList(list);
        }
        orderVo.setGroupItemVos(groupItemVos);
        return orderVo;
    }
}

