/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.function;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.List;

public abstract class AbstractConditionRuleFunction<Param extends ConditionRuleParam, Resp extends ConditionRuleResponse>
implements RuleFunction<Param, Resp> {
    protected Resp divideAndRemainder(BigDecimal productBuyAmount, BigDecimal valueAsProductCurrentY) {
        if (BigDecimal.ZERO.compareTo(productBuyAmount) == 0) {
            productBuyAmount = BigDecimal.ONE;
        }
        BigDecimal[] temp = productBuyAmount.divideAndRemainder(valueAsProductCurrentY);
        ConditionRuleResponse response = new ConditionRuleResponse();
        response.setDivide(temp[0]);
        response.setProductModulus(valueAsProductCurrentY);
        response.setRemainder(temp[1]);
        return (Resp)response;
    }

    @Override
    public Resp test(TestRuleParam ruleParam) {
        ConditionRuleParam conditionRuleParam = new ConditionRuleParam();
        PromotionRuleEditVo.TestParam testParam = ruleParam.getTestParam();
        ValidateUtils.validate((Object)testParam, (String)"\u6d4b\u8bd5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)testParam.getBizParam(), (String)"\u6d4b\u8bd5\u53c2\u6570[BizParam<k-v \u4e1a\u52a1\u53c2\u6570\u5bf9\u8c61>]\u4e0d\u80fd\u4e3a\u7a7a!");
        String productOrderBuyStr = JsonPropertyUtil.toJsonString(testParam.getBizParam().get("productOrderBuy"));
        ValidateUtils.validate((Object)productOrderBuyStr, (String)"\u6d4b\u8bd5\u53c2\u6570[BizParam.productOrderBuy<\u8ba2\u5355\u5546\u54c1\u8d2d\u4e70\u91cf\u5217\u8868>]\u4e0d\u80fd\u4e3a\u7a7a!");
        List productOrderBuy = JsonPropertyUtil.toArray((String)productOrderBuyStr, RuleExecuteParam.ProductOrderBuy.class);
        conditionRuleParam.setProductOrderBuy(productOrderBuy);
        conditionRuleParam.setLadder(testParam.getControlRow());
        conditionRuleParam.setRuleCode(ruleParam.getRuleCode());
        return (Resp)((ConditionRuleResponse)this.apply(conditionRuleParam));
    }
}

