/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.resolver.ladder;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.entity.PromotionRuleEntity;
import com.biz.crm.promotion.mapper.PromotionRuleMapper;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class LadderResolverHelper {
    public static final String LADDER_RESOLVER = "LadderResolver";
    @Resource
    private PromotionRuleMapper promotionRuleMapper;
    @Resource
    private Map<String, AbstractConditionRuleLadderResolver> ladderResolverMap;
    private Map<String, String> ruleIdMapFuncBody = Maps.newHashMap();

    public AbstractConditionRuleLadderResolver getResolver(PromotionPolicyRuleEditVo ruleEditVo) {
        String promotionRuleId = ruleEditVo.getPromotionRuleId();
        if (StringUtils.isBlank((CharSequence)promotionRuleId)) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.ruleIdMapFuncBody.containsKey(promotionRuleId)) {
            AbstractConditionRuleLadderResolver ladderResolver = this.ladderResolverMap.get(this.ruleIdMapFuncBody.get(promotionRuleId) + LADDER_RESOLVER);
            if (null == ladderResolver) {
                throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u9636\u68af\u89e3\u6790\u5668[" + this.ruleIdMapFuncBody.get(promotionRuleId) + "]");
            }
            return ladderResolver;
        }
        PromotionRuleEntity ruleEntity = (PromotionRuleEntity)this.promotionRuleMapper.selectById((Serializable)((Object)promotionRuleId));
        if (null == ruleEntity) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u6761\u4ef6\u89c4\u5219ID[" + promotionRuleId + "]");
        }
        this.ruleIdMapFuncBody.put(ruleEntity.getId(), ruleEntity.getFuncBody());
        return this.getResolverByFuncBody(ruleEntity.getFuncBody());
    }

    public AbstractConditionRuleLadderResolver getResolverByFuncBody(String funcBody) {
        AbstractConditionRuleLadderResolver ladderResolver = this.ladderResolverMap.get(funcBody + LADDER_RESOLVER);
        if (null == ladderResolver) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u9636\u68af\u89e3\u6790\u5668[" + funcBody + "]");
        }
        return ladderResolver;
    }

    public BigDecimal valueAsProductCurrentY(PromotionPolicyRuleEditVo ruleEditVo, PromotionRuleEditVo.ControlRow controlRow) {
        return this.getResolver(ruleEditVo).valueAsProductCurrentY(controlRow);
    }

    public BigDecimal valueAsProductCurrentN(PromotionPolicyRuleEditVo ruleEditVo, PromotionRuleEditVo.ControlRow controlRow) {
        return this.getResolver(ruleEditVo).valueAsProductCurrentN(controlRow);
    }
}

