/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.validator.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProduct;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRule;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScope;
import com.biz.crm.promotion.entity.PromotionPolicyTemplateEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyTemplateMapper;
import com.biz.crm.promotion.service.component.validator.PromotionPolicyEditValidator;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmDateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="promotionPolicyEditBaseValidator")
@Order(value=1)
public class PromotionPolicyEditBaseValidator
implements PromotionPolicyEditValidator {
    private static final Logger log = LoggerFactory.getLogger(PromotionPolicyEditBaseValidator.class);
    @Resource
    private PromotionPolicyTemplateMapper promotionPolicyTemplateMapper;

    @Override
    public void validate(PromotionPolicyEditReqVo vo) throws BusinessException {
        this.checkParams(vo);
    }

    protected void checkParams(PromotionPolicyEditReqVo vo) {
        AssertUtils.isNotNull((Object)vo, (String)"\u65e0\u6548\u53c2\u6570\uff0c\u8bf7\u91cd\u8bd5");
        AssertUtils.isNotEmpty((String)vo.getFirstOrder(), (String)"\u9996\u5355\u4f18\u60e0\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getBeginTime(), (String)"\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getEndTime(), (String)"\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getMultipleable(), (String)"\u662f\u5426\u6821\u9a8c\u4e0d\u80fd\u4e3a\u7a7a");
        if (vo.getBeginTime().length() == 10) {
            vo.setBeginTime(vo.getBeginTime() + " " + "00:00:00");
        }
        if (vo.getEndTime().length() == 10) {
            vo.setEndTime(vo.getEndTime() + " " + "23:59:59");
        }
        if (LocalDateTime.parse(vo.getBeginTime(), CrmDateUtils.yyyyMMddHHmmss).compareTo(LocalDateTime.parse(vo.getEndTime(), CrmDateUtils.yyyyMMddHHmmss)) > 0) {
            throw new BusinessException("\u653f\u7b56\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
        }
        AssertUtils.isNotEmpty((String)vo.getDescription(), (String)"\u4fc3\u9500\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getPromotionPolicyCode(), (String)"\u4fc3\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getPromotionPolicyName(), (String)"\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getTemplateId(), (String)"\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getTemplateCode(), (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getTemplateName(), (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        if (StringUtils.isBlank((CharSequence)vo.getChanel())) {
            vo.setChanel("ALL");
        }
        if (StringUtils.isBlank((CharSequence)vo.getSaleCompanyCode())) {
            vo.setSaleCompanyCode("ALL");
            vo.setSaleCompanyName("ALL");
        }
        this.checkProductParams(vo);
        this.checkRuleParams(vo);
        this.checkScopeParams(vo);
    }

    protected void checkRuleParams(PromotionPolicyEditReqVo vo) {
        PromotionPolicyRule rule = vo.getPromotionPolicyRule();
        AssertUtils.isNotNull((Object)rule, (String)"\u4fc3\u9500\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((Collection)rule.getRulesAsCalculate(), (String)"\u4fc3\u9500\u89c4\u5219-\u8ba1\u7b97\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((Collection)rule.getRulesAsCondition(), (String)"\u4fc3\u9500\u89c4\u5219-\u6ee1\u8db3\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        List allRules = vo.takeAllRules();
        allRules.forEach(v -> AssertUtils.isNotEmpty((String)v.getPromotionRuleId(), (String)"\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a!"));
    }

    protected void checkProductParams(PromotionPolicyEditReqVo vo) {
        PromotionPolicyProduct product = vo.getPromotionPolicyProduct();
        AssertUtils.isNotNull((Object)product, (String)"\u4fc3\u9500\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((Collection)product.getProductsCurrentY(), (String)"\u4fc3\u9500\u5546\u54c1\u672c\u54c1\u4e0d\u80fd\u4e3a\u7a7a!");
        PromotionPolicyTemplateEntity templateEntity = (PromotionPolicyTemplateEntity)this.promotionPolicyTemplateMapper.selectById((Serializable)((Object)vo.getTemplateId()));
        AssertUtils.isNotNull((Object)templateEntity, (String)("\u4e0d\u5b58\u5728\u7684\u653f\u7b56\u6a21\u677f[" + vo.getTemplateCode() + "]"));
        boolean currentRelationalGift = PromotionPolicyEunm.PromotionProductTypeEunm.CURRENT_RELATIONAL_GIFT.getCode().equals(templateEntity.getPromotionProduct());
        if (currentRelationalGift) {
            vo.getPromotionPolicyProduct().setProductsCurrentN((List)Lists.newArrayList());
        }
        List allProducts = vo.takeAllProducts();
        allProducts.forEach(v -> {
            AssertUtils.isNotEmpty((String)v.getProductCode(), (String)"\u4fc3\u9500\u5546\u54c1-\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            AssertUtils.isNotEmpty((String)v.getProductName(), (String)"\u4fc3\u9500\u5546\u54c1-\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            if (currentRelationalGift) {
                AssertUtils.isNotEmpty((String)v.getProductCodeGift(), (String)"\u4fc3\u9500\u5546\u54c1-\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
                AssertUtils.isNotEmpty((String)v.getProductNameGift(), (String)"\u4fc3\u9500\u5546\u54c1-\u8d60\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            }
        });
    }

    protected void checkScopeParams(PromotionPolicyEditReqVo vo) {
        PromotionPolicyScope product = vo.getPromotionPolicyScope();
        List allScopes = vo.takeAllScopes();
        allScopes.forEach(v -> {
            AssertUtils.isNotEmpty((String)v.getScopeCode(), (String)"\u4fc3\u9500\u8303\u56f4-\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            AssertUtils.isNotEmpty((String)v.getScopeName(), (String)"\u4fc3\u9500\u8303\u56f4-\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            AssertUtils.isNotEmpty((String)v.getScopeType(), (String)"\u4fc3\u9500\u8303\u56f4-\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        });
    }
}

