/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScope;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeGroup;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.promotion.entity.PromotionPolicyScopeEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyScopeMapper;
import com.biz.crm.promotion.service.PromotionPolicyScopeService;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyScopeServiceExpandImpl"})
@Service(value="promotionPolicyScopeService")
public class PromotionPolicyScopeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyScopeMapper, PromotionPolicyScopeEntity>
implements PromotionPolicyScopeService {
    @Resource
    private PromotionPolicyScopeMapper promotionPolicyScopeMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    public void refreshScope(PromotionPolicyEditReqVo editVo) {
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            this.doDelByPromotionPolicyIdOrCode(Lists.newArrayList((Object[])new String[]{editVo.getId()}), null);
        }
        if (CommonConstant.DMS.PROMOTION_SCOPE_HOST_TYPE.TERMINAL.getItemCode().equals(editVo.getScopeType())) {
            ValidateUtils.isTrue((editVo.getPromotionPolicyScope().getScopesAsCust() == null && editVo.getPromotionPolicyScope().getScopesAsOrg() == null ? 1 : 0) != 0, (String)"\u5f53\u8303\u56f4\u7c7b\u578b\u4e3a\u7ec8\u7aef\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u5ba2\u6237\u6216\u8005\u5ba2\u6237\u7ec4\u7ec7", (Object[])new Object[0]);
        } else {
            ValidateUtils.isTrue((editVo.getPromotionPolicyScope().getScopesAsTerminal() == null && editVo.getPromotionPolicyScope().getScopesAsTerminalOrg() == null ? 1 : 0) != 0, (String)"\u5f53\u8303\u56f4\u7c7b\u578b\u4e3a\u7ecf\u9500\u5546\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u7ec8\u7aef\u6216\u8005\u7ec8\u7aef\u7ec4\u7ec7", (Object[])new Object[0]);
        }
        List tempEditVos = editVo.takeAllScopes();
        ArrayList editVos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)tempEditVos)) {
            return;
        }
        HashSet keys = Sets.newHashSet();
        for (PromotionPolicyScopeEditVo temp : tempEditVos) {
            String key = temp.getPromotionPolicyId() + temp.getScopeCode() + temp.getScopeType() + temp.getContainable();
            if (keys.contains(key)) continue;
            temp.setId(null);
            temp.setPromotionPolicyCode(editVo.getPromotionPolicyCode());
            temp.setPromotionPolicyId(editVo.getId());
            temp.setPromotionPolicyName(editVo.getPromotionPolicyName());
            editVos.add(temp);
            keys.add(key);
        }
        if (editVo.getSaveFlag().booleanValue()) {
            this.saveBatch(CrmBeanUtil.copyList((List)editVos, PromotionPolicyScopeEntity.class));
        }
    }

    @Override
    public void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo) {
        List<PromotionPolicyScopeEntity> custY = null;
        List<PromotionPolicyScopeEntity> custN = null;
        List<PromotionPolicyScopeEntity> orgY = null;
        List<PromotionPolicyScopeEntity> orgN = null;
        List<PromotionPolicyScopeEntity> terminalY = null;
        List<PromotionPolicyScopeEntity> terminalN = null;
        List<PromotionPolicyScopeEntity> terminalOrgY = null;
        List<PromotionPolicyScopeEntity> terminalOrgN = null;
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            QueryWrapper wrapper = Wrappers.query();
            wrapper.in((Object)"promotion_policy_id", new Object[]{editVo.getId()});
            Map<String, List<PromotionPolicyScopeEntity>> groupByScopeType = this.promotionPolicyScopeMapper.selectList((Wrapper)wrapper).stream().collect(Collectors.groupingBy(v -> v.getScopeType() + v.getContainable()));
            custY = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            custN = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            orgY = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            orgN = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            terminalY = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            terminalN = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            terminalOrgY = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL_ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            terminalOrgN = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL_ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        }
        PromotionPolicyScopeGroup scopesAsOrg = new PromotionPolicyScopeGroup();
        scopesAsOrg.setContainN(CrmBeanUtil.copyList(orgN, PromotionPolicyScopeEditVo.class));
        scopesAsOrg.setContainY(CrmBeanUtil.copyList(orgY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyScopeGroup scopesAsCust = new PromotionPolicyScopeGroup();
        scopesAsCust.setContainN(CrmBeanUtil.copyList(custN, PromotionPolicyScopeEditVo.class));
        scopesAsCust.setContainY(CrmBeanUtil.copyList(custY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyScopeGroup scopesAsTerminal = new PromotionPolicyScopeGroup();
        scopesAsTerminal.setContainN(CrmBeanUtil.copyList(terminalN, PromotionPolicyScopeEditVo.class));
        scopesAsTerminal.setContainY(CrmBeanUtil.copyList(terminalY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyScopeGroup scopesAsTerminalOrg = new PromotionPolicyScopeGroup();
        scopesAsTerminalOrg.setContainN(CrmBeanUtil.copyList(terminalOrgN, PromotionPolicyScopeEditVo.class));
        scopesAsTerminalOrg.setContainY(CrmBeanUtil.copyList(terminalOrgY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyScope promotionPolicyScope = new PromotionPolicyScope();
        promotionPolicyScope.setScopesAsCust(scopesAsCust);
        promotionPolicyScope.setScopesAsOrg(scopesAsOrg);
        promotionPolicyScope.setScopesAsTerminal(scopesAsTerminal);
        promotionPolicyScope.setScopesAsTerminalOrg(scopesAsTerminalOrg);
        editVo.setPromotionPolicyScope(promotionPolicyScope);
    }

    @Override
    public void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        this.doDelByPromotionPolicyIdOrCode(promotionPolicyId, promotionPolicyCode);
    }

    @Override
    public Set<String> selectPromotionPolicyIdByScopeCode(String customerCode, Set<String> orgCodes, String searchTime, String orderCode) {
        if (null == orgCodes) {
            orgCodes = Sets.newHashSet();
        }
        HashSet matchedPromotionPolicyId = Sets.newHashSet();
        ArrayList<String> queryList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)customerCode)) {
            queryList.add(customerCode);
        }
        if (!CollectionUtils.isEmpty((Collection)orgCodes)) {
            queryList.addAll(orgCodes);
        }
        if (CollectionUtils.isEmpty(queryList)) {
            return matchedPromotionPolicyId;
        }
        if (StringUtils.isEmpty((CharSequence)searchTime)) {
            searchTime = DateUtil.dateNowHms();
        }
        List promotionPolicyIdMapScopeList = this.promotionPolicyScopeMapper.selectPromotionPolicyIdByScopeCode(queryList, orderCode, searchTime);
        Map<String, List<PromotionPolicyScopeEntity>> promotionPolicyIdMapScope = promotionPolicyIdMapScopeList.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getPromotionPolicyId));
        for (Map.Entry<String, List<PromotionPolicyScopeEntity>> entry : promotionPolicyIdMapScope.entrySet()) {
            List<PromotionPolicyScopeEntity> scopeEntities = entry.getValue();
            Map<String, List<PromotionPolicyScopeEntity>> scopeTypeMapScope = scopeEntities.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getScopeType));
            List<PromotionPolicyScopeEntity> scopeAsCustomer = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode());
            List<PromotionPolicyScopeEntity> scopeAsOrg = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode());
            boolean matchedAsCustContainableY = this.doMatchScopeContainableY(scopeAsCustomer, Sets.newHashSet((Object[])new String[]{customerCode}));
            boolean matchedAsCustContainableN = this.doMatchScopeContainableN(scopeAsCustomer, Sets.newHashSet((Object[])new String[]{customerCode}));
            boolean matchedAsOrgContainableY = this.doMatchScopeContainableY(scopeAsOrg, orgCodes);
            boolean matchedAsOrgContainableN = this.doMatchScopeContainableN(scopeAsOrg, orgCodes);
            if (!matchedAsCustContainableY && !matchedAsOrgContainableY || matchedAsCustContainableN || matchedAsOrgContainableN) continue;
            matchedPromotionPolicyId.add(entry.getKey());
        }
        return matchedPromotionPolicyId;
    }

    @Override
    public Set<String> selectPromotionPolicyIdByTerminal(String terminalCode, Set<String> orgCodes, String orderCode) {
        HashSet matchedPromotionPolicyId = Sets.newHashSet();
        ArrayList<String> queryList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)terminalCode)) {
            queryList.add(terminalCode);
        }
        if (!CollectionUtils.isEmpty(orgCodes)) {
            queryList.addAll(orgCodes);
        }
        if (CollectionUtils.isEmpty(queryList)) {
            return matchedPromotionPolicyId;
        }
        String searchTime = DateUtil.dateNowHms();
        List promotionPolicyIdList = this.promotionPolicyScopeMapper.selectPromotionPolicyIdByScopeCode(queryList, orderCode, searchTime);
        Map<String, List<PromotionPolicyScopeEntity>> promotionPolicyIdMapScope = promotionPolicyIdList.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getPromotionPolicyId));
        for (Map.Entry<String, List<PromotionPolicyScopeEntity>> entry : promotionPolicyIdMapScope.entrySet()) {
            List<PromotionPolicyScopeEntity> scopeEntities = entry.getValue();
            Map<String, List<PromotionPolicyScopeEntity>> scopeTypeMapScope = scopeEntities.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getScopeType));
            List<PromotionPolicyScopeEntity> scopeTerminal = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL.getItemCode());
            List<PromotionPolicyScopeEntity> scopeTerminalOrg = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL_ORG.getItemCode());
            boolean matchedAsCustContainableY = this.doMatchScopeContainableY(scopeTerminal, Sets.newHashSet((Object[])new String[]{terminalCode}));
            boolean matchedAsCustContainableN = this.doMatchScopeContainableN(scopeTerminal, Sets.newHashSet((Object[])new String[]{terminalCode}));
            boolean matchedAsTerminalContainableY = this.doMatchScopeContainableY(scopeTerminalOrg, Sets.newHashSet(orgCodes));
            boolean matchedAsTerminalContainableN = this.doMatchScopeContainableY(scopeTerminalOrg, Sets.newHashSet(orgCodes));
            if ((!matchedAsCustContainableY || matchedAsCustContainableN) && (!matchedAsTerminalContainableY || matchedAsTerminalContainableN)) continue;
            matchedPromotionPolicyId.add(entry.getKey());
        }
        return matchedPromotionPolicyId;
    }

    private boolean doMatchScopeContainableY(List<PromotionPolicyScopeEntity> scope, Set<String> codes) {
        if (CollectionUtils.isEmpty(scope)) {
            return false;
        }
        Map<String, List<PromotionPolicyScopeEntity>> containableMapScope = scope.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getContainable));
        List<PromotionPolicyScopeEntity> scopeAsContainableY = containableMapScope.get(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        boolean isMatch = false;
        if (null != scopeAsContainableY) {
            for (PromotionPolicyScopeEntity scopeEntity : scopeAsContainableY) {
                if (!codes.contains(scopeEntity.getScopeCode())) continue;
                isMatch = true;
            }
        }
        return isMatch;
    }

    private boolean doMatchScopeContainableN(List<PromotionPolicyScopeEntity> scope, Set<String> codes) {
        if (CollectionUtils.isEmpty(scope)) {
            return false;
        }
        Map<String, List<PromotionPolicyScopeEntity>> containableMapScope = scope.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getContainable));
        List<PromotionPolicyScopeEntity> scopeAsContainableN = containableMapScope.get(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        boolean isMatch = false;
        if (null != scopeAsContainableN) {
            for (PromotionPolicyScopeEntity scopeEntity : scopeAsContainableN) {
                if (!codes.contains(scopeEntity.getScopeCode())) continue;
                isMatch = true;
            }
        }
        return isMatch;
    }

    @Override
    public List<String> countCustCodesByPromotionPolicyId(Set<String> promotionPolicyIds) {
        Result custResult;
        CustomerCodeConditionReqVo reqVo;
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return Lists.newArrayList();
        }
        HashSet custCodes = Sets.newHashSet();
        List custCodesAsCust = this.promotionPolicyScopeMapper.selectCustCodesByPromotionPolicyId((List)Lists.newArrayList(promotionPolicyIds));
        custCodes.addAll(custCodesAsCust);
        List channelCodes = this.promotionPolicyScopeMapper.selectChannelCodesByPromotionPolicyId((List)Lists.newArrayList(promotionPolicyIds));
        List orgCodes = this.promotionPolicyScopeMapper.selectOrgCodesByPromotionPolicyId((List)Lists.newArrayList(promotionPolicyIds));
        if (!CollectionUtils.isEmpty((Collection)orgCodes)) {
            reqVo = new CustomerCodeConditionReqVo();
            reqVo.setOrgCodeList((List)Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)orgCodes)));
            custResult = this.mdmCustomerMsgFeign.findCustomerCodeConditionList(reqVo);
            List custCodesAsOrg = (List)ApiResultUtil.objResult((Result)custResult, (boolean)true);
            custCodes.addAll(custCodesAsOrg);
        }
        if (!CollectionUtils.isEmpty((Collection)channelCodes)) {
            reqVo = new CustomerCodeConditionReqVo();
            reqVo.setChannelList((List)Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)channelCodes)));
            custResult = this.mdmCustomerMsgFeign.findCustomerCodeConditionList(reqVo);
            List custCodesAsChannel = (List)ApiResultUtil.objResult((Result)custResult, (boolean)true);
            custCodes.addAll(custCodesAsChannel);
        }
        return Lists.newArrayList((Iterable)custCodes);
    }

    private void doDelByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (!CollectionUtils.isEmpty(promotionPolicyId)) {
            wrapper.in((Object)"promotion_policy_id", promotionPolicyId);
        } else if (!CollectionUtils.isEmpty(promotionPolicyCode)) {
            wrapper.in((Object)"promotion_policy_code", promotionPolicyCode);
        } else {
            return;
        }
        this.promotionPolicyScopeMapper.delete((Wrapper)wrapper);
    }
}

