/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.customer.MdmCustomerROrgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProduct;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProductEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRule;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScope;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeGroup;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleSelectionVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleVo;
import com.biz.crm.nebular.dms.promotion.param.QueryProductPolicyParamVo;
import com.biz.crm.nebular.dms.promotion.policy.PromotionImportVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.promotion.entity.PromotionPolicyEntity;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.entity.PromotionPolicyRuleEntity;
import com.biz.crm.promotion.entity.PromotionRuleEntity;
import com.biz.crm.promotion.entity.resp.PromotionPolicyPageResp;
import com.biz.crm.promotion.mapper.PromotionPolicyMapper;
import com.biz.crm.promotion.service.PromotionLoadProductInfoService;
import com.biz.crm.promotion.service.PromotionPolicyProductService;
import com.biz.crm.promotion.service.PromotionPolicyRuleService;
import com.biz.crm.promotion.service.PromotionPolicyScopeService;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.promotion.service.PromotionPolicyTemplateService;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.RuleExecutor;
import com.biz.crm.promotion.service.component.filter.AbstractFilter;
import com.biz.crm.promotion.service.component.filter.AbstractProductFilter;
import com.biz.crm.promotion.service.component.validator.PromotionPolicyEditValidator;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.util.dms.PromotionPolicyUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyServiceExpandImpl"})
@Service(value="promotionPolicyService")
public class PromotionPolicyServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyMapper, PromotionPolicyEntity>
implements PromotionPolicyService {
    @Resource
    private PromotionPolicyMapper promotionPolicyMapper;
    @Resource
    private PromotionPolicyRuleService promotionPolicyRuleService;
    @Resource
    private PromotionRuleService promotionRuleService;
    @Resource
    private PromotionPolicyScopeService promotionPolicyScopeService;
    @Resource
    private PromotionPolicyProductService promotionPolicyProductService;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private MdmCustomerROrgFeign mdmCustomerROrgFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource(name="defaultRuleExecutor")
    private RuleExecutor defaultRuleExecutor;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private PromotionPolicyTemplateService promotionPolicyTemplateService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private List<AbstractFilter> abstractFilters;
    @Resource
    private List<AbstractProductFilter> abstractProductFilters;
    @Resource
    private List<PromotionPolicyEditValidator> promotionPolicyEditValidators;
    @Resource
    private PromotionLoadProductInfoService promotionLoadProductInfoService;

    @Override
    public void addOrUpdate(PromotionPolicyEditReqVo vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getPromotionPolicyCode()) && vo.getSaveFlag().booleanValue()) {
            vo.setPromotionPolicyCode(CodeUtil.createOneCode((String)"dms_promotion_code"));
        }
        this.checkParams(vo);
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            PromotionPolicyEntity temp = (PromotionPolicyEntity)CrmBeanUtil.copy((Object)vo, PromotionPolicyEntity.class);
            if (vo.getSaveFlag().booleanValue()) {
                this.promotionPolicyMapper.insert((Object)temp);
                vo.setId(temp.getId());
                this.crmLogSendUtil.sendForAdd(ThreadLocalUtil.getObj((String)"menuCode") == null ? null : ThreadLocalUtil.getObj((String)"menuCode").toString(), vo.getId(), null, (Object)vo);
            }
        } else {
            PromotionPolicyEntity oldEntity = (PromotionPolicyEntity)this.promotionPolicyMapper.selectById((Serializable)((Object)vo.getId()));
            if (null == oldEntity) {
                throw new BusinessException("\u653f\u7b56\u6570\u636e\u4e0d\u5b58\u5728,ID=[" + vo.getId() + "]");
            }
            vo.setPromotionPolicyCode(oldEntity.getPromotionPolicyCode());
            PromotionPolicyVo oldobj = (PromotionPolicyVo)CrmBeanUtil.copy((Object)oldEntity, PromotionPolicyVo.class);
            this.doUpdate(oldEntity, vo);
            PromotionPolicyVo newEntity = this.findById(vo.getId());
            PromotionPolicyVo newobj = (PromotionPolicyVo)CrmBeanUtil.copy((Object)newEntity, PromotionPolicyVo.class);
            this.crmLogSendUtil.sendForUpdate(ThreadLocalUtil.getObj((String)"menuCode").toString(), vo.getId(), vo.getId(), (Object)oldobj, (Object)newobj);
        }
        this.promotionPolicyRuleService.refreshRule(vo);
        this.promotionPolicyScopeService.refreshScope(vo);
        this.promotionPolicyProductService.refreshProduct(vo);
        if (vo.getSaveFlag().booleanValue()) {
            this.countBeginAndEndAffectedCustoms(DateUtil.getDate((String)"yyyy-MM-dd"), Lists.newArrayList((Object[])new String[]{vo.getId()}));
        }
    }

    private void checkParams(PromotionPolicyEditReqVo vo) {
        if (CollectionUtils.isEmpty(this.promotionPolicyEditValidators)) {
            return;
        }
        for (PromotionPolicyEditValidator promotionPolicyEditValidator : this.promotionPolicyEditValidators) {
            promotionPolicyEditValidator.validate(vo);
        }
    }

    @Override
    public List<String> countBeginAndEndAffectedCustoms(String date, List<String> promotionIds) {
        if (StringUtils.isBlank((CharSequence)date)) {
            date = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        }
        String onDate = LocalDate.parse(date).minusDays(1L).format(CrmDateUtils.yyyyMMdd);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.between((Object)"begin_time", (Object)date, (Object)(date + " " + "23:59:59"))).or()).between((Object)"end_time", (Object)onDate, (Object)(onDate + " " + "23:59:59"));
        Set<String> entitieIds = this.promotionPolicyMapper.selectList((Wrapper)wrapper).stream().map(BaseIdEntity::getId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(entitieIds)) {
            return Lists.newArrayList();
        }
        if (!CollectionUtil.listNotEmpty(promotionIds)) {
            return Lists.newArrayList();
        }
        entitieIds = entitieIds.stream().filter(id -> promotionIds.contains(id)).collect(Collectors.toSet());
        List<String> custCodes = this.promotionPolicyScopeService.countCustCodesByPromotionPolicyId(entitieIds);
        if (!CollectionUtils.isEmpty(custCodes)) {
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(custCodes));
            rocketMQMessageBody.setTag("CUS_AVAILBLELIST_REFRSH_PROMOTION");
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        return custCodes;
    }

    @Override
    public List<PromotionPolicyInfoDataVo> loadPromotionPolicyInfoByCustAndProduct(String custCode, String productCode) {
        if (StringUtils.isBlank((CharSequence)custCode) || StringUtils.isBlank((CharSequence)productCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u548c\u5546\u54c1\u7f16\u7801");
        }
        QueryProductPolicyParamVo productPolicyParamVo = new QueryProductPolicyParamVo();
        productPolicyParamVo.setCustCode(custCode);
        productPolicyParamVo.setProductCode(productCode);
        productPolicyParamVo.setSearchTime(DateUtil.dateNowHms());
        return this.loadPromotionPolicyInfos(productPolicyParamVo);
    }

    private List<PromotionPolicyInfoDataVo> loadPromotionPolicyInfos(QueryProductPolicyParamVo productPolicyParamVo) {
        String customerCode = productPolicyParamVo.getCustCode();
        String productCode = productPolicyParamVo.getProductCode();
        if (StringUtils.isEmpty((CharSequence)productPolicyParamVo.getSearchTime())) {
            productPolicyParamVo.setSearchTime(DateUtil.dateNowHms());
        }
        String searchTime = productPolicyParamVo.getSearchTime();
        Set<String> orgCodes = this.buildOrgCodes(customerCode, productPolicyParamVo.getOrgCode());
        Set<String> terminalOrgCode = this.buildOrgCodesByTerminal(productPolicyParamVo.getTerminalCode(), productPolicyParamVo.getOrgCode());
        List<PromotionPolicyProductEntity> promotionPolicyProductEntityList = this.promotionPolicyProductService.selectPromotionPolicyIdByProductCode(productPolicyParamVo.getOrderCode(), productCode, searchTime);
        if (CollectionUtils.isEmpty(promotionPolicyProductEntityList)) {
            return Lists.newArrayList();
        }
        Set<String> promotionPolicyIdAsProduct = promotionPolicyProductEntityList.stream().filter(k -> CommonConstant.GLOBAL.YesOrNo.Y.getItemCode().equals(k.getCurrentProduct())).map(PromotionPolicyProductEntity::getPromotionPolicyId).collect(Collectors.toSet());
        if (promotionPolicyIdAsProduct == null || promotionPolicyIdAsProduct.size() < 1) {
            return Lists.newArrayList();
        }
        Set<String> promotionPolicyIdAsScope = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(customerCode, orgCodes, searchTime, productPolicyParamVo.getOrderCode());
        Set<String> promotionPolicyIdAsScopeTerminal = this.promotionPolicyScopeService.selectPromotionPolicyIdByTerminal(productPolicyParamVo.getTerminalCode(), terminalOrgCode, productPolicyParamVo.getOrderCode());
        promotionPolicyIdAsScope.addAll(promotionPolicyIdAsScopeTerminal);
        List<String> merged = this.merge(promotionPolicyIdAsProduct, promotionPolicyIdAsScope);
        if (CollectionUtils.isEmpty(merged)) {
            return Lists.newArrayList();
        }
        return this.selectActivities((PromotionPolicyEntity)CrmBeanUtil.copy((Object)productPolicyParamVo, PromotionPolicyEntity.class), merged, searchTime);
    }

    private Set<String> buildOrgCodesByTerminal(String terminalCode, String orgCode) {
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            return this.loadParentOrgCodes(Sets.newHashSet((Object[])new String[]{orgCode}));
        }
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return Sets.newHashSet();
        }
        MdmTerminalVo param = new MdmTerminalVo();
        param.setTerminalCodeList((List)Lists.newArrayList((Object[])new String[]{terminalCode}));
        List result = (List)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.detailBatch(param), (boolean)true);
        if (CollectionUtil.listEmpty((List)result)) {
            return Sets.newHashSet();
        }
        return result.stream().collect(Collectors.groupingBy(MdmOrgRespVo::getOrgCode)).keySet();
    }

    private List<PromotionPolicyInfoDataVo> selectActivities(PromotionPolicyEntity entity, List<String> ids, String searchTime) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isEmpty((CharSequence)searchTime)) {
            searchTime = DateUtil.dateNowHms();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PromotionPolicyEntity.class).in(BaseIdEntity::getId, ids)).eq(Objects.nonNull(entity) && StringUtils.isBlank((CharSequence)entity.getOrderCode()), CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode());
        ArrayList saleCompanyCode = Lists.newArrayList((Object[])new String[]{"ALL"});
        if (null != entity) {
            if (StringUtils.isNotBlank((CharSequence)entity.getSaleCompanyCode())) {
                saleCompanyCode.add(entity.getSaleCompanyCode());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt1())) {
                wrapper.eq(CrmExtEntity::getExt1, (Object)entity.getExt1());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt2())) {
                wrapper.eq(CrmExtEntity::getExt2, (Object)entity.getExt2());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt3())) {
                wrapper.eq(CrmExtEntity::getExt3, (Object)entity.getExt3());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt4())) {
                wrapper.eq(CrmExtEntity::getExt4, (Object)entity.getExt4());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt5())) {
                wrapper.eq(CrmExtEntity::getExt5, (Object)entity.getExt5());
            }
        }
        ((LambdaQueryWrapper)wrapper.le(PromotionPolicyEntity::getBeginTime, (Object)searchTime)).ge(PromotionPolicyEntity::getEndTime, (Object)searchTime);
        List dataVos = CrmBeanUtil.copyList((List)this.promotionPolicyMapper.selectList((Wrapper)wrapper), PromotionPolicyInfoDataVo.class);
        String hitKey = wrapper.getCustomSqlSegment();
        String hitValue = JsonPropertyUtil.toJsonString((Object)wrapper.getParamNameValuePairs());
        this.addHitDetail(dataVos, hitKey, hitValue);
        return dataVos;
    }

    private void addHitDetail(List<PromotionPolicyInfoDataVo> dataVos, String hitKey, String hitValue) {
        if (null == dataVos) {
            return;
        }
        PromotionPolicyInfoDataVo.HitDetail hitDetail = new PromotionPolicyInfoDataVo.HitDetail(hitKey, hitValue);
        dataVos.forEach(v -> v.addHitDetail(hitDetail));
    }

    private Set<String> buildOrgCodes(String customerCode, String orgCode) {
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            return this.loadParentOrgCodes(Sets.newHashSet((Object[])new String[]{orgCode}));
        }
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return Sets.newHashSet();
        }
        Result result = this.mdmCustomerMsgFeign.listByCode(customerCode);
        MdmCustomerMsgRespVo respVo = (MdmCustomerMsgRespVo)ApiResultUtil.objResult((Result)result);
        if (Objects.isNull(respVo) || StringUtils.isEmpty((CharSequence)respVo.getOrgCode())) {
            return Sets.newHashSet();
        }
        return this.loadParentOrgCodes(Sets.newHashSet((Object[])new String[]{respVo.getOrgCode()}));
    }

    private Set<String> loadParentOrgCodes(Set<String> orgCodes) {
        List parentOrgCodes = (List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.findAllParentOrgCodeExcludeSelf((List)Lists.newArrayList(orgCodes)));
        orgCodes.addAll(parentOrgCodes);
        return orgCodes;
    }

    private List<String> merge(Set<String> promotionPolicyIds, Set<String> promotionPolicyIdAsScope) {
        return promotionPolicyIds.stream().filter(v -> promotionPolicyIdAsScope.contains(v)).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<PromotionPolicyInfoVo>> loadPromotionPolicyInfoByCustAndProducts(String custCode, List<String> productCodes, String orderCode) {
        if (StringUtils.isBlank((CharSequence)custCode) || CollectionUtils.isEmpty(productCodes)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u548c\u5546\u54c1\u7f16\u7801");
        }
        productCodes = productCodes.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.toList());
        Set<String> orgCodes = this.buildOrgCodes(custCode, null);
        String searchTime = DateUtil.dateNowHms();
        Set<String> promotionPolicyIdAsScope = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(custCode, orgCodes, searchTime, orderCode);
        HashSet distinctProductCodes = Sets.newHashSet(productCodes);
        productCodes = Lists.newArrayList((Iterable)distinctProductCodes);
        List partitionList = Lists.partition((List)productCodes, (int)999);
        Map<String, List<PromotionPolicyInfoVo>> results = this.partitionListProcess(partitionList, promotionPolicyIdAsScope, searchTime, orderCode);
        for (String productCode : distinctProductCodes) {
            if (results.containsKey(productCode)) continue;
            results.put(productCode, Lists.newArrayList());
        }
        return results;
    }

    @Override
    public Map<String, Boolean> custProductsHasPromotionPolicy(String custCode, List<String> productCodes, String orderCode) {
        Map<String, List<PromotionPolicyInfoVo>> temp = this.loadPromotionPolicyInfoByCustAndProducts(custCode, productCodes, orderCode);
        HashMap data = Maps.newHashMap();
        temp.forEach((s, promotionPolicyInfoVos) -> data.put(s, !CollectionUtils.isEmpty((Collection)promotionPolicyInfoVos)));
        return data;
    }

    private Map<String, List<PromotionPolicyInfoVo>> partitionListProcess(List<List<String>> partitionList, Set<String> promotionPolicyIdAsScope, String searchTime, String orderCode) {
        HashMap results = Maps.newHashMap();
        for (List<String> list : partitionList) {
            Map productCodeMapPromotionPolicyIds;
            List<PromotionPolicyProductEntity> promotionPolicyIdAsProduct = this.promotionPolicyProductService.selectPromotionPolicyIdByProductCodes(list, searchTime, orderCode);
            if (CollectionUtils.isEmpty(promotionPolicyIdAsProduct) || (productCodeMapPromotionPolicyIds = promotionPolicyIdAsProduct.stream().collect(Collectors.groupingBy(PromotionPolicyProductEntity::getProductCode, Collectors.mapping(PromotionPolicyProductEntity::getPromotionPolicyId, Collectors.toSet())))) == null || productCodeMapPromotionPolicyIds.size() < 1) continue;
            HashMap custProductPromotionPolicyId = Maps.newHashMap();
            HashSet mergedPromotionPolicyId = Sets.newHashSet();
            for (Map.Entry entry : productCodeMapPromotionPolicyIds.entrySet()) {
                String productCode = entry.getKey();
                Set<String> promotionPolicyIds = entry.getValue();
                List<String> temp = this.merge(promotionPolicyIds, promotionPolicyIdAsScope);
                custProductPromotionPolicyId.put(productCode, temp);
                mergedPromotionPolicyId.addAll(temp);
            }
            results.putAll(this.loadPromotionPolicyInfoVo(mergedPromotionPolicyId, custProductPromotionPolicyId, searchTime));
        }
        return results;
    }

    private Map<String, List<PromotionPolicyInfoVo>> loadPromotionPolicyInfoVo(Set<String> mergedPromotionPolicyId, Map<String, List<String>> custProductPromotionPolicyId, String searchTime) {
        Map<Object, Object> infoVoMap = CollectionUtils.isEmpty(mergedPromotionPolicyId) ? Maps.newHashMap() : this.selectActivities(null, Lists.newArrayList(mergedPromotionPolicyId), searchTime).stream().collect(Collectors.toMap(UuidVo::getId, v -> v, (r, r2) -> r2));
        HashMap custProductPromotionPolicyInfoVo = Maps.newHashMap();
        for (Map.Entry<String, List<String>> entry : custProductPromotionPolicyId.entrySet()) {
            String productCode = entry.getKey();
            List<String> promotionPolicyIds = entry.getValue();
            ArrayList infoVos = Lists.newArrayList();
            promotionPolicyIds.forEach(v -> {
                if (infoVoMap.containsKey(v)) {
                    infoVos.add(infoVoMap.get(v));
                }
            });
            custProductPromotionPolicyInfoVo.put(productCode, infoVos);
        }
        return custProductPromotionPolicyInfoVo;
    }

    @Override
    public PromotionPolicyEditVo loadPolicyEditVo(String id, String templateId) {
        PromotionPolicyEditVo templateEditVo;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PromotionPolicyEntity entity = (PromotionPolicyEntity)this.promotionPolicyMapper.selectById((Serializable)((Object)id));
            AssertUtils.isNotNull((Object)entity, (String)"\u672a\u52a0\u8f7d\u5230\u653f\u7b56\u6570\u636e");
            templateEditVo = (PromotionPolicyEditVo)CrmBeanUtil.copy((Object)entity, PromotionPolicyEditVo.class);
        } else {
            AssertUtils.isNotEmpty((String)templateId, (String)"\u8bf7\u9009\u62e9\u4fc3\u9500\u653f\u7b56\u6a21\u677f");
            templateEditVo = new PromotionPolicyEditVo();
            templateEditVo.setTemplateId(templateId);
        }
        this.promotionPolicyProductService.loadListForEditPromotionPolicy(templateEditVo);
        this.promotionPolicyScopeService.loadListForEditPromotionPolicy(templateEditVo);
        this.promotionPolicyRuleService.loadListForEditPromotionPolicy(templateEditVo);
        Map map = DictUtil.getDictValueMapsByCodes((String)"promotion_policy_status");
        templateEditVo.setPromotionPolicyStatus(PromotionPolicyUtil.promotionPolicyStatus((String)templateEditVo.getEnableStatus(), (String)templateEditVo.getBeginTime(), (String)templateEditVo.getEndTime()));
        if (null == map) {
            return templateEditVo;
        }
        templateEditVo.setPromotionPolicyStatusName((String)map.get(templateEditVo.getPromotionPolicyStatus()));
        if ("ALL".equals(templateEditVo.getChanel())) {
            templateEditVo.setChanel(null);
        }
        if ("ALL".equals(templateEditVo.getSaleCompanyCode())) {
            templateEditVo.setSaleCompanyCode(null);
            templateEditVo.setSaleCompanyName(null);
        }
        return templateEditVo;
    }

    private void doUpdate(PromotionPolicyEntity oldEntity, PromotionPolicyEditReqVo vo) {
        PromotionPolicyEntity entity = (PromotionPolicyEntity)CrmBeanUtil.copy((Object)vo, PromotionPolicyEntity.class);
        String timeActive = PromotionPolicyUtil.timeActive((String)oldEntity.getBeginTime(), (String)oldEntity.getEndTime());
        if (PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode().equals(timeActive)) {
            this.promotionPolicyMapper.updateNullValById(entity);
        } else if (PromotionPolicyEunm.PromotionPolicyStatusEunm.RUNNING.getCode().equals(timeActive)) {
            long now = System.currentTimeMillis() / 1000L;
            if (now > CrmDateUtils.parseyyyyMMddHHmmss((String)vo.getEndTime()).toEpochSecond(ZoneOffset.of("+8"))) {
                throw new BusinessException("\u6267\u884c\u4e2d\u7684\u653f\u7b56\u53ea\u53ef\u7f16\u8f91\u7ed3\u675f\u65f6\u95f4\u8c03\u6574\u81f3\u5f53\u524d\u65f6\u95f4\u4e4b\u540e\u7684\u65f6\u95f4\u70b9");
            }
            entity = new PromotionPolicyEntity();
            entity.setId(vo.getId());
            entity.setEndTime(vo.getEndTime());
        } else {
            throw new BusinessException("\u8be5\u653f\u7b56\u5df2\u7ed3\u675f\uff0c\u4e0d\u53ef\u4fee\u6539\uff01");
        }
        this.promotionPolicyMapper.updateById((Object)entity);
    }

    @Override
    public PageResult<PromotionPolicyPageResp> getPageList(PromotionPolicyQueryVo vo) {
        Page page = PageUtil.buildPage((Integer)vo.getPageNum(), (Integer)vo.getPageSize());
        List list = this.promotionPolicyMapper.findList(page, vo);
        Map map = DictUtil.getDictValueMapsByCodes((String)"promotion_policy_status");
        list.forEach(v -> {
            if ("ALL".equals(v.getChanel())) {
                v.setChanel(null);
            }
            if ("ALL".equals(v.getSaleCompanyCode())) {
                v.setSaleCompanyCode(null);
                v.setSaleCompanyName(null);
            }
            v.setPromotionPolicyStatusNoEnableStatus(PromotionPolicyUtil.promotionPolicyStatusNoEnable((String)v.getBeginTime(), (String)v.getEndTime()));
            v.setPromotionPolicyStatus(PromotionPolicyUtil.promotionPolicyStatus((String)v.getEnableStatus(), (String)v.getBeginTime(), (String)v.getEndTime()));
            if (null == map) {
                return;
            }
            v.setPromotionPolicyStatusName((String)map.get(v.getPromotionPolicyStatus()));
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<PromotionPolicyEntity> getListByTemplate(String templateId, String templateCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (StringUtils.isNotBlank((CharSequence)templateId)) {
            wrapper.in((Object)"template_id", new Object[]{templateId});
        } else if (StringUtils.isNotBlank((CharSequence)templateCode)) {
            wrapper.in((Object)"template_code", new Object[]{templateCode});
        }
        return this.promotionPolicyMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public void del(List<String> promotionPolicyIds) {
        this.delCheck(promotionPolicyIds);
        this.promotionPolicyRuleService.delByPromotionPolicyIdOrCode(promotionPolicyIds, null);
        this.promotionPolicyScopeService.delByPromotionPolicyIdOrCode(promotionPolicyIds, null);
        this.promotionPolicyProductService.delByPromotionPolicyIdOrCode(promotionPolicyIds, null);
        for (String id : promotionPolicyIds) {
            PromotionPolicyVo promotionPolicyVo = this.findById(id);
            this.crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj((String)"menuCode").toString(), promotionPolicyVo.getId(), null, (Object)promotionPolicyVo);
        }
        this.promotionPolicyMapper.deleteBatchIds(promotionPolicyIds);
        this.countBeginAndEndAffectedCustoms(DateUtil.getDate((String)"yyyy-MM-dd"), promotionPolicyIds);
    }

    private void delCheck(List<String> promotionPolicyIds) {
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return;
        }
        List entities = this.promotionPolicyMapper.selectBatchIds(promotionPolicyIds);
        HashSet temp = Sets.newHashSet();
        for (PromotionPolicyEntity entity : entities) {
            String timeActive = PromotionPolicyUtil.timeActive((String)entity.getBeginTime(), (String)entity.getEndTime());
            if (PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode().equals(timeActive)) continue;
            temp.add(entity.getPromotionPolicyCode());
        }
        if (CollectionUtils.isEmpty((Collection)temp)) {
            return;
        }
        throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u653f\u7b56[" + temp.stream().collect(Collectors.joining(", ")) + "]\u4e3a\u6267\u884c\u4e2d\u6216\u5df2\u7ed3\u675f\u72b6\u6001\uff01");
    }

    @Override
    public void enable(List<String> promotionPolicyIds) {
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return;
        }
        this.updateStatus(promotionPolicyIds, CrmEnableStatusEnum.ENABLE);
        this.countBeginAndEndAffectedCustoms(DateUtil.getDate((String)"yyyy-MM-dd"), promotionPolicyIds);
    }

    @Override
    public void disable(List<String> promotionPolicyIds) {
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return;
        }
        this.updateStatus(promotionPolicyIds, CrmEnableStatusEnum.DISABLE);
        this.countBeginAndEndAffectedCustoms(DateUtil.getDate((String)"yyyy-MM-dd"), promotionPolicyIds);
    }

    private void updateStatus(List<String> promotionPolicyIds, CrmEnableStatusEnum statusEnum) {
        if (CollectionUtil.listEmpty(promotionPolicyIds) || statusEnum == null) {
            return;
        }
        UpdateWrapper wrapper = (UpdateWrapper)((UpdateWrapper)Wrappers.update().set((Object)"enable_status", (Object)statusEnum.getCode())).in((Object)"id", promotionPolicyIds);
        this.update((Wrapper)wrapper);
    }

    private LoadConfigInfoContext loadConfigInfoContext(PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        LoadConfigInfoContext loadConfigInfoContext = new LoadConfigInfoContext(configInfoQueryVo);
        String customerCode = configInfoQueryVo.getCustCode();
        String orgCode = configInfoQueryVo.getOrgCode();
        if (StringUtils.isEmpty((CharSequence)configInfoQueryVo.getSearchTime())) {
            configInfoQueryVo.setSearchTime(DateUtil.dateNowHms());
        }
        String searchTime = configInfoQueryVo.getSearchTime();
        String terminalCode = configInfoQueryVo.getTerminalCode();
        Set<String> orgCodes = this.buildOrgCodes(customerCode, orgCode);
        Set<String> terminalOrgCodes = this.buildOrgCodesByTerminal(terminalCode, orgCode);
        Set<String> promotionPolicyIdAsScope = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(customerCode, orgCodes, searchTime, configInfoQueryVo.getOrderCode());
        Set<String> promotionPolicyIdAsScopeTerminal = this.promotionPolicyScopeService.selectPromotionPolicyIdByTerminal(terminalCode, terminalOrgCodes, configInfoQueryVo.getOrderCode());
        if (promotionPolicyIdAsScopeTerminal != null && promotionPolicyIdAsScopeTerminal.size() > 0) {
            promotionPolicyIdAsScope.addAll(promotionPolicyIdAsScopeTerminal);
        }
        configInfoQueryVo.getOrderProductInfos().forEach(v -> {
            this.loadProductPromotionPolicy(loadConfigInfoContext, promotionPolicyIdAsScope, v.getProductCode());
            List<PromotionPolicyInfoDataVo> promotionPolicyInfoVos = loadConfigInfoContext.getProductMapPromotionPolicy().get(v.getProductCode());
            this.addHitDetail(promotionPolicyInfoVos, "custCode", customerCode);
            this.addHitDetail(promotionPolicyInfoVos, "orgCodes", JsonPropertyUtil.toJsonString((Object)orgCodes));
        });
        this.promotionPolicyProductService.selectGiftByPromotionPolicyId(loadConfigInfoContext, CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        this.promotionPolicyProductService.selectGiftByPromotionPolicyId(loadConfigInfoContext, CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        this.loadProductInfo(loadConfigInfoContext);
        return loadConfigInfoContext;
    }

    private void loadProductInfo(LoadConfigInfoContext loadConfigInfoContext) {
        HashMap productMap = Maps.newHashMap();
        Set<String> productCodeGiftY = loadConfigInfoContext.getCurrentProductCodesN();
        if (null != productCodeGiftY) {
            List productRespVoList = this.promotionLoadProductInfoService != null ? this.promotionLoadProductInfoService.list(Lists.newArrayList(productCodeGiftY)) : (List)ApiResultUtil.objResult((Result)this.mdmProductFeign.queryBatchByProductCodeList((List)Lists.newArrayList(productCodeGiftY)), (boolean)true);
            productRespVoList.forEach(v -> productMap.put(v.getProductCode(), v));
        }
        loadConfigInfoContext.setCurrentProductInfoNMap(productMap);
    }

    private void loadProductPromotionPolicy(LoadConfigInfoContext loadConfigInfoContext, Set<String> promotionPolicyIdAsScope, String productCode) {
        String searchTime = loadConfigInfoContext.getConfigInfoQueryVo().getSearchTime();
        List<PromotionPolicyProductEntity> promotionPolicyProductEntityList = this.promotionPolicyProductService.selectPromotionPolicyIdByProductCode(loadConfigInfoContext.getConfigInfoQueryVo().getOrderCode(), productCode, searchTime);
        if (CollectionUtils.isEmpty(promotionPolicyProductEntityList)) {
            return;
        }
        Set<String> promotionPolicyIdAsProduct = promotionPolicyProductEntityList.stream().filter(k -> CommonConstant.GLOBAL.YesOrNo.Y.getItemCode().equals(k.getCurrentProduct())).map(PromotionPolicyProductEntity::getPromotionPolicyId).collect(Collectors.toSet());
        if (promotionPolicyIdAsProduct == null || promotionPolicyIdAsProduct.size() < 1) {
            return;
        }
        List<String> merged = this.merge(promotionPolicyIdAsProduct, promotionPolicyIdAsScope);
        if (CollectionUtils.isEmpty(merged)) {
            return;
        }
        List<PromotionPolicyInfoDataVo> promotionPolicyInfoVos = this.selectActivities((PromotionPolicyEntity)CrmBeanUtil.copy((Object)loadConfigInfoContext.getConfigInfoQueryVo(), PromotionPolicyEntity.class), merged, searchTime);
        loadConfigInfoContext.putPromotionPolicyInfoVos(productCode, promotionPolicyInfoVos);
        this.addHitDetail(promotionPolicyInfoVos, "productCode", productCode);
        this.addHitDetail(promotionPolicyInfoVos, "promotionPolicyIdAsProduct", JsonPropertyUtil.toJsonString(promotionPolicyIdAsProduct));
        this.addHitDetail(promotionPolicyInfoVos, "promotionPolicyIdAsScope", JsonPropertyUtil.toJsonString(promotionPolicyIdAsScope));
    }

    private void filterPromotionPolicy(LoadConfigInfoContext context) {
        context.getProductMapPromotionPolicy().forEach((productCode, promotionPolicyInfoVos) -> {
            promotionPolicyInfoVos = promotionPolicyInfoVos.stream().filter(v -> {
                if (CollectionUtils.isEmpty(this.abstractFilters)) {
                    return true;
                }
                for (AbstractFilter filter : this.abstractFilters) {
                    if (filter.filter(v, context)) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            context.putPromotionPolicyInfoVos((String)productCode, (List<PromotionPolicyInfoDataVo>)promotionPolicyInfoVos);
        });
    }

    private List<PromotionPolicyInfoDataVo> filterPromotionProductPolicy(LoadConfigInfoContext context, List<PromotionPolicyInfoDataVo> promotionPolicyInfoVos) {
        List<PromotionPolicyInfoDataVo> promotionPolicyInfoDataVos = promotionPolicyInfoVos.stream().filter(v -> {
            if (CollectionUtils.isEmpty(this.abstractProductFilters)) {
                return true;
            }
            for (AbstractProductFilter filter : this.abstractProductFilters) {
                if (filter.filter(v, context)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        return promotionPolicyInfoDataVos;
    }

    @Override
    public Map<String, List<PromotionPolicyConfigInfo>> loadPromotionPolicyConfigInfoForOrder(PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        this.checkConfigInfoQueryVo(configInfoQueryVo);
        LoadConfigInfoContext context = this.loadConfigInfoContext(configInfoQueryVo);
        List orderProductInfos = configInfoQueryVo.getOrderProductInfos();
        for (PromotionPolicyConfigInfoQueryVo.ProductOrderInfo info : orderProductInfos) {
            if (StringUtils.isBlank((CharSequence)info.getPromotionPolicyId()) || context.getProductMapPromotionPolicy() == null || !context.getProductMapPromotionPolicy().containsKey(info.getProductCode())) continue;
            List<Object> dataVos = context.getProductMapPromotionPolicy().get(info.getProductCode());
            dataVos = dataVos.stream().filter(d -> info.getPromotionPolicyId().contains(d.getId())).collect(Collectors.toList());
            context.getProductMapPromotionPolicy().put(info.getProductCode(), dataVos);
        }
        this.filterPromotionPolicy(context);
        HashMap result = Maps.newHashMap();
        context.getProductMapPromotionPolicy().forEach((productCode, promotionPolicyInfoVos) -> {
            for (PromotionPolicyInfoDataVo infoVo : promotionPolicyInfoVos) {
                PromotionPolicyConfigInfo promotionPolicyConfigInfo = this.loadPromotionPolicyRuleInfo(infoVo);
                this.buildProductInfoGiftY(promotionPolicyConfigInfo, context);
                this.countingPromotionPolicyToProduct(context, promotionPolicyConfigInfo, result);
            }
        });
        this.calculateRuleExecute(result, configInfoQueryVo);
        result.forEach((k, v) -> {
            if (CollectionUtil.listNotEmptyNotSizeZero((List)v)) {
                List n = v.stream().filter(s -> s.getPromotionPolicyInfoVo() == null || s.getPromotionPolicyInfoVo().getCalculateRuleResponse() == null || s.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData() == null).collect(Collectors.toList());
                if (CollectionUtil.listNotEmptyNotSizeZero(n)) {
                    v.removeAll(n);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)v)) {
                    v.forEach(item -> item.setProductModulus(item.getPromotionPolicyInfoVo().getCalculateRuleResponse().getProductModulus()));
                }
            }
        });
        return result;
    }

    private void calculateRuleExecute(Map<String, List<PromotionPolicyConfigInfo>> result, PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        if (null == result) {
            return;
        }
        List orderProductInfos = configInfoQueryVo.getOrderProductInfos();
        if (CollectionUtils.isEmpty((Collection)orderProductInfos)) {
            return;
        }
        result.forEach((s, promotionPolicyConfigInfos) -> {
            if (null == promotionPolicyConfigInfos) {
                return;
            }
            promotionPolicyConfigInfos.forEach(v -> {
                RuleExecuteParam ruleExecuteParam = new RuleExecuteParam();
                ruleExecuteParam.setPromotionPolicyConfigInfo((PromotionPolicyConfigInfo)v);
                ArrayList productOrderBuy = Lists.newArrayList();
                for (PromotionPolicyConfigInfoQueryVo.ProductOrderInfo productOrderInfo : orderProductInfos) {
                    if (!s.contains(productOrderInfo.getProductCode())) continue;
                    productOrderBuy.add(new RuleExecuteParam.ProductOrderBuy(productOrderInfo));
                }
                if (CollectionUtils.isEmpty((Collection)productOrderBuy)) {
                    return;
                }
                ruleExecuteParam.setProductOrderBuy(productOrderBuy);
                ruleExecuteParam.setCusCode(configInfoQueryVo.getCustCode());
                ruleExecuteParam.setCusTypeCode(configInfoQueryVo.getCusTypeCode());
                ruleExecuteParam.setCusOrgCode(configInfoQueryVo.getOrgCode());
                Object ruleResponse = this.defaultRuleExecutor.execute(ruleExecuteParam);
                PromotionPolicyInfoDataVo configInfo = v.getPromotionPolicyInfoVo();
                if (null != configInfo) {
                    configInfo.setCalculateRuleResponse(ruleResponse);
                }
            });
        });
    }

    @Override
    public List<PromotionPolicyConfigInfo> loadPromotionPolicyConfigInfoByProductCode(QueryProductPolicyParamVo productPolicyParamVo) {
        List<PromotionPolicyInfoDataVo> promotionPolicyInfoVos;
        if (StringUtils.isBlank((CharSequence)productPolicyParamVo.getProductCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1\u7f16\u7801");
        }
        if (StringUtils.isEmpty((CharSequence)productPolicyParamVo.getSearchTime())) {
            productPolicyParamVo.setSearchTime(DateUtil.dateNowHms());
        }
        if (CollectionUtils.isEmpty(promotionPolicyInfoVos = this.loadPromotionPolicyInfos(productPolicyParamVo))) {
            return Lists.newArrayList();
        }
        LoadConfigInfoContext context = new LoadConfigInfoContext();
        context.setPromotionPolicyIds(promotionPolicyInfoVos.stream().map(UuidVo::getId).collect(Collectors.toSet()));
        this.promotionPolicyProductService.selectGiftByPromotionPolicyId(context, CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        this.promotionPolicyProductService.selectGiftByPromotionPolicyId(context, CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        this.loadProductInfo(context);
        ArrayList configInfos = Lists.newArrayList();
        for (PromotionPolicyInfoDataVo infoVo : promotionPolicyInfoVos) {
            PromotionPolicyConfigInfo promotionPolicyConfigInfo = this.loadPromotionPolicyRuleInfo(infoVo);
            this.buildProductInfoGiftY(promotionPolicyConfigInfo, context);
            configInfos.add(promotionPolicyConfigInfo);
        }
        return configInfos;
    }

    @Override
    public PromotionPolicyVo findById(String promotionPolicyId) {
        if (StringUtils.isBlank((CharSequence)promotionPolicyId)) {
            return null;
        }
        PromotionPolicyEntity entity = (PromotionPolicyEntity)this.promotionPolicyMapper.selectOne((Wrapper)Wrappers.query().in((Object)"id", new Object[]{promotionPolicyId}));
        return (PromotionPolicyVo)CrmBeanUtil.copy((Object)entity, PromotionPolicyVo.class);
    }

    @Override
    public List<PromotionPolicyVo> findByIds(ArrayList<String> promotionPolicyIds) {
        if (CollectionUtil.listEmpty(promotionPolicyIds)) {
            return Lists.newArrayList();
        }
        List entitys = this.promotionPolicyMapper.selectList((Wrapper)Wrappers.query().in((Object)"id", promotionPolicyIds));
        return CrmBeanUtil.copyList((List)entitys, PromotionPolicyVo.class);
    }

    @Override
    public Map<String, List<PromotionPolicyConfigInfo>> loadPromotionPolicyConfigInfoForSelect(PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        ValidateUtils.validate((Object)configInfoQueryVo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.notEmpty((Collection)configInfoQueryVo.getOrderProductInfos(), (String)"\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        List orderInfos = configInfoQueryVo.getOrderProductInfos();
        TreeMap result = Maps.newTreeMap();
        TreeMap productMap = Maps.newTreeMap();
        Map<String, List<PromotionPolicyConfigInfo>> orderResult = this.loadPromotionPolicyConfigInfoForOrder(configInfoQueryVo);
        if (StringUtils.isEmpty((CharSequence)configInfoQueryVo.getSearchTime())) {
            configInfoQueryVo.setSearchTime(DateUtil.dateNowHms());
        }
        result.putAll(orderResult);
        orderInfos.forEach(info -> {
            QueryProductPolicyParamVo productParam = new QueryProductPolicyParamVo();
            productParam.setCustCode(configInfoQueryVo.getCustCode());
            productParam.setOrgCode(configInfoQueryVo.getOrgCode());
            productParam.setProductCode(info.getProductCode());
            productParam.setTerminalCode(configInfoQueryVo.getTerminalCode());
            productParam.setSearchTime(configInfoQueryVo.getSearchTime());
            List<PromotionPolicyConfigInfo> productResult = this.loadPromotionPolicyConfigInfoByProductCode(productParam);
            productMap.put(info.getProductCode(), productResult);
            List infoList = (List)orderResult.get(info.getProductCode());
            if (CollectionUtil.listEmpty((List)infoList)) {
                productResult.forEach(p -> p.setHit(false));
            } else {
                Set<String> orderPromotionCodes = infoList.stream().collect(Collectors.groupingBy(i -> i.getPromotionPolicyInfoVo().getPromotionPolicyCode())).keySet();
                productResult.stream().forEach(p -> {
                    if (!orderPromotionCodes.contains(p.getPromotionPolicyInfoVo().getPromotionPolicyCode())) {
                        p.setHit(false);
                    } else {
                        PromotionPolicyConfigInfo configInfo = (PromotionPolicyConfigInfo)infoList.stream().filter(i -> Objects.equals(i.getPromotionPolicyInfoVo().getPromotionPolicyCode(), p.getPromotionPolicyInfoVo().getPromotionPolicyCode())).collect(Collectors.toList()).get(0);
                        productResult.remove(p);
                        productResult.add(configInfo);
                    }
                });
            }
        });
        result.putAll(productMap);
        return result;
    }

    @Override
    public Map<String, List<PromotionPolicyConfigInfo>> findProductMapByCusCode(String cusCode) {
        if (StringUtils.isBlank((CharSequence)cusCode)) {
            return Maps.newHashMap();
        }
        String searchTime = DateUtil.dateNowHms();
        Set<String> promotionIds = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(cusCode, Sets.newHashSet(), searchTime, null);
        if (!CollectionUtil.collectionNotEmpty(promotionIds)) {
            return Maps.newHashMap();
        }
        List<PromotionPolicyVo> promotionPolicyVos = this.findByIds(Lists.newArrayList(promotionIds));
        Map<String, PromotionPolicyVo> promotionPolicyVoMap = promotionPolicyVos.stream().collect(Collectors.toMap(UuidVo::getId, a -> a));
        Map<String, List<PromotionPolicyProductEntity>> productMap = this.promotionPolicyProductService.findProductsByPromotionIds(Lists.newArrayList(promotionIds), CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        HashMap result = Maps.newHashMap();
        productMap.values().forEach(products -> products.forEach(p -> {
            List promotions = (List)result.get(p.getProductCode());
            if (promotions == null) {
                promotions = Lists.newArrayList();
            }
            PromotionPolicyInfoDataVo promotionPolicyInfoDataVo = (PromotionPolicyInfoDataVo)CrmBeanUtil.copy(promotionPolicyVoMap.get(p.getPromotionPolicyId()), PromotionPolicyInfoDataVo.class);
            PromotionPolicyConfigInfo info = new PromotionPolicyConfigInfo();
            info.setPromotionPolicyInfoVo(promotionPolicyInfoDataVo);
            promotions.add(info);
            result.put(p.getProductCode(), promotions);
        }));
        return result;
    }

    @Override
    public PromotionPolicyVo findByCode(String promotionPolicyCode) {
        if (StringUtils.isBlank((CharSequence)promotionPolicyCode)) {
            return null;
        }
        PromotionPolicyEntity entity = (PromotionPolicyEntity)this.promotionPolicyMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"promotion_policy_code", (Object)promotionPolicyCode));
        PromotionPolicyVo vo = (PromotionPolicyVo)CrmBeanUtil.copy((Object)entity, PromotionPolicyVo.class);
        if (vo == null) {
            return null;
        }
        PromotionPolicyTemplateVo templateVo = this.promotionPolicyTemplateService.findByCode(vo.getTemplateCode());
        vo.setPromotionPolicyTemplateVo(templateVo);
        return vo;
    }

    @Override
    public PromotionPolicyEditReqVo buildImportPromotion(PromotionImportVo importVo) {
        ValidateUtils.validate((Object)importVo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)importVo.getTemplateCode(), (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)importVo.getPromotionName(), (String)"\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((Objects.equals(importVo.getScopeType(), "\u7ecf\u9500\u5546") || Objects.equals(importVo.getScopeType(), "\u7ec8\u7aef") ? 1 : 0) != 0, (String)"\u4fc3\u9500\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e76\u4e14\u53ea\u80fd\u662f'\u7ecf\u9500\u5546'\u6216'\u7ec8\u7aef'", (Object[])new Object[0]);
        PromotionPolicyTemplateVo templateVo = this.promotionPolicyTemplateService.findByCode(importVo.getTemplateCode());
        ValidateUtils.validate((Object)templateVo, (String)"\u4fc3\u9500\u5f15\u64ce\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5f15\u64ce\u7f16\u7801\u662f\u5426\u6b63\u786e\u8f93\u5165");
        PromotionPolicyTemplateEditVo templateEditVo = this.promotionPolicyTemplateService.loadTemplateInfo(templateVo.getId());
        ValidateUtils.validate((Object)templateEditVo, (String)"\u4fc3\u9500\u5f15\u64ce\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5f15\u64ce\u7f16\u7801\u662f\u5426\u6b63\u786e\u8f93\u5165");
        importVo.setPromotionProductType(templateEditVo.getPromotionProduct());
        importVo.setPromotionType(templateEditVo.getPromotionType());
        PromotionPolicyEditReqVo editReqVo = new PromotionPolicyEditReqVo();
        if (Objects.equals(importVo.getScopeType(), "\u7ec8\u7aef")) {
            editReqVo.setScopeType("terminal");
            importVo.setScopeType("terminal");
        } else {
            importVo.setScopeType("customer");
        }
        editReqVo.setPromotionPolicyCode(importVo.getPromotionCode());
        editReqVo.setPromotionPolicyName(importVo.getPromotionName());
        editReqVo.setDescription(importVo.getDescription());
        editReqVo.setBeginTime(importVo.getStartTime());
        editReqVo.setEndTime(importVo.getEndTime());
        editReqVo.setFirstOrder(StringUtils.isEmpty((CharSequence)importVo.getFirstOrder()) ? "N" : importVo.getFirstOrder());
        editReqVo.setMultipleable(StringUtils.isEmpty((CharSequence)importVo.getMultipleable()) ? "Y" : importVo.getMultipleable());
        editReqVo.setProductsOrderQty(importVo.getProductsOrderQty());
        editReqVo.setProductsOrderQtyType(importVo.getProductsOrderQtyType());
        editReqVo.setSaleCompanyCode(importVo.getSaleCompanyCode());
        editReqVo.setSaleCompanyName(importVo.getSaleCompanyName());
        editReqVo.setTemplateCode(templateEditVo.getTemplateCode());
        editReqVo.setTemplateId(templateEditVo.getId());
        editReqVo.setTemplateName(templateEditVo.getTemplateName());
        PromotionPolicyProduct promotionPolicyProduct = this.buildImportProducts(importVo);
        editReqVo.setPromotionPolicyProduct(promotionPolicyProduct);
        PromotionPolicyScope promotionPolicyScope = this.buildImportScopes(importVo);
        editReqVo.setPromotionPolicyScope(promotionPolicyScope);
        PromotionPolicyRule promotionPolicyRule = this.buildImportRules(importVo, templateEditVo);
        editReqVo.setPromotionPolicyRule(promotionPolicyRule);
        return editReqVo;
    }

    @Override
    @Transactional
    public void saveBatch(List<PromotionPolicyEditReqVo> editReqVos) {
        editReqVos.forEach(vo -> this.addOrUpdate((PromotionPolicyEditReqVo)vo));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refreshPolicy() {
        String numberReg = "\\d+(.\\d+)?";
        String prefixOfGitLadder = "[{\"text\":\"\u672c\u5355\u4e2d\u672c\u54c1\u6570\u91cf\u8d2d\u4e70\u6ee1\",\"controlKey\":\"control_key\",\"controls\":[{\"key\":\"buyNo\",\"value\":\"";
        String middleOfGitLadder = "\",\"label\":\"\",\"labelPostfix\":\"\",\"description\":\"\u8bf7\u8f93\u5165\u672c\u54c1\u6570\u91cf\",\"controlType\":\"input\",\"selectOptions\":[]},{\"key\":\"giftNo\",\"value\":\"";
        String suffixOfGitLadder = "\",\"label\":\"\uff0c\u9001\u8d60\u54c1\",\"labelPostfix\":\"\",\"description\":\"\u8bf7\u8f93\u5165\u8d60\u54c1\u6570\u91cf\",\"controlType\":\"input\",\"selectOptions\":[]}]}]";
        String prefixOfGitA1002 = "[{\"text\":\"\",\"controlKey\":\"control_key\",\"controls\":[{\"key\":\"giftNo\",\"value\":\"";
        String suffixOfGitA1002 = "\",\"label\":\"\u7279\u4ef7\",\"labelPostfix\":\"\",\"description\":\"\u8bf7\u8f93\u5165\u7279\u4ef7\",\"controlType\":\"input\",\"selectOptions\":[]}]}]";
        String prefixOfGitA1003 = "[{\"text\":\"\u672c\u5355\u4e2d\u672c\u54c1\u6570\u91cf\u8d2d\u4e70\u6ee1\",\"controlKey\":\"control_key\",\"controls\":[{\"key\":\"buyNo\",\"value\":\"";
        String middleOfGitA1003 = "\",\"label\":\"\",\"labelPostfix\":\"\",\"description\":\"\u8bf7\u8f93\u5165\u672c\u54c1\u6570\u91cf\",\"controlType\":\"input\",\"selectOptions\":[]},{\"key\":\"giftNo\",\"value\":\"";
        String suffixOfGitA1003 = "\",\"label\":\"\uff0c\u9001\u8d60\u54c1\",\"labelPostfix\":\"\",\"description\":\"\u8bf7\u8f93\u5165\u8d60\u54c1\u6570\u91cf\",\"controlType\":\"input\",\"selectOptions\":[]}]}]";
        List<PromotionPolicyRuleEntity> policyRuleEntityList = this.promotionPolicyRuleService.listRule();
        List gitLadderOfCondition = policyRuleEntityList.stream().filter(entity -> "condition".equals(entity.getRuleType()) && "gitladder0318".equals(entity.getPromotionPolicyTemplateCode())).collect(Collectors.toList());
        List A1002OfCondition = policyRuleEntityList.stream().filter(entity -> "condition".equals(entity.getRuleType()) && "A1002".equals(entity.getPromotionPolicyTemplateCode())).collect(Collectors.toList());
        List A1003OfCondition = policyRuleEntityList.stream().filter(entity -> "condition".equals(entity.getRuleType()) && "A1003".equals(entity.getPromotionPolicyTemplateCode())).collect(Collectors.toList());
        gitLadderOfCondition = gitLadderOfCondition.stream().map(entity -> {
            List<String> listByReg = PromotionPolicyServiceImpl.findListByReg(entity.getParams(), numberReg);
            if (listByReg.size() == 2) {
                String s = prefixOfGitLadder + listByReg.get(0) + middleOfGitLadder + listByReg.get(1) + suffixOfGitLadder;
                entity.setParams(s);
            }
            return entity;
        }).collect(Collectors.toList());
        A1002OfCondition = A1002OfCondition.stream().map(entity -> {
            List<String> listByReg = PromotionPolicyServiceImpl.findListByReg(entity.getParams(), numberReg);
            if (listByReg.size() == 2) {
                String s = prefixOfGitA1002 + listByReg.get(1) + suffixOfGitA1002;
                entity.setParams(s);
            }
            return entity;
        }).collect(Collectors.toList());
        A1003OfCondition = A1003OfCondition.stream().map(entity -> {
            List<String> listByReg = PromotionPolicyServiceImpl.findListByReg(entity.getParams(), numberReg);
            if (listByReg.size() == 2) {
                String s = prefixOfGitA1003 + listByReg.get(0) + middleOfGitA1003 + listByReg.get(1) + suffixOfGitA1003;
                entity.setParams(s);
            }
            return entity;
        }).collect(Collectors.toList());
        ArrayList<PromotionPolicyRuleEntity> collect = new ArrayList<PromotionPolicyRuleEntity>();
        collect.addAll(gitLadderOfCondition);
        collect.addAll(A1002OfCondition);
        collect.addAll(A1003OfCondition);
        this.promotionPolicyRuleService.refresh(collect);
    }

    private PromotionPolicyRule buildImportRules(PromotionImportVo importVo, PromotionPolicyTemplateEditVo templateEditVo) {
        PromotionPolicyRule rule = new PromotionPolicyRule();
        List templateConditions = templateEditVo.getCondition().stream().filter(c -> c.getSelected()).collect(Collectors.toList());
        List templateCalculates = templateEditVo.getCalculate().stream().filter(c -> c.getSelected()).collect(Collectors.toList());
        List templateLimits = templateEditVo.getLimited().stream().filter(c -> c.getSelected()).collect(Collectors.toList());
        ValidateUtils.isTrue((CollectionUtil.listNotEmpty(templateConditions) && templateConditions.size() == 1 ? 1 : 0) != 0, (String)"\u6a21\u677f\u6761\u4ef6\u89c4\u5219\u4e0d\u6b63\u786e\uff0c\u5e94\u5f53\u6709\u4e14\u4ec5\u6709\u4e00\u6761\u751f\u6548\u6761\u4ef6\u89c4\u5219", (Object[])new Object[0]);
        ValidateUtils.isTrue((CollectionUtil.listNotEmpty(templateCalculates) && templateCalculates.size() == 1 ? 1 : 0) != 0, (String)"\u6a21\u677f\u8ba1\u7b97\u89c4\u5219\u4e0d\u6b63\u786e\uff0c\u5e94\u5f53\u6709\u4e14\u4ec5\u6709\u4e00\u6761\u751f\u6548\u8ba1\u7b97\u89c4\u5219", (Object[])new Object[0]);
        PromotionRuleSelectionVo templateCondition = (PromotionRuleSelectionVo)templateConditions.get(0);
        PromotionRuleSelectionVo templateCalculate = (PromotionRuleSelectionVo)templateCalculates.get(0);
        ArrayList conditions = Lists.newArrayList();
        ArrayList calculates = Lists.newArrayList();
        ArrayList limits = Lists.newArrayList();
        PromotionPolicyRuleEditVo condition = new PromotionPolicyRuleEditVo();
        condition.setPromotionPolicyTemplateCode(templateEditVo.getTemplateCode());
        condition.setPromotionPolicyTemplateId(templateEditVo.getId());
        condition.setPromotionRuleId(templateCondition.getId());
        condition.setRuleCode(templateCondition.getRuleCode());
        condition.setRuleName(templateCondition.getRuleName());
        condition.setRuleType(templateCondition.getRuleType());
        condition.setSelected(templateCondition.getSelected());
        List<PromotionRuleEditVo.ControlRow> controlRows = this.buildImportControlRows(importVo, templateCondition);
        condition.setControlRows(controlRows);
        PromotionPolicyRuleEditVo calculate = new PromotionPolicyRuleEditVo();
        calculate.setPromotionPolicyTemplateCode(templateEditVo.getTemplateCode());
        calculate.setPromotionPolicyTemplateId(templateEditVo.getId());
        calculate.setPromotionRuleId(templateCalculate.getId());
        calculate.setRuleCode(templateCalculate.getRuleCode());
        calculate.setRuleName(templateCalculate.getRuleName());
        calculate.setRuleType(templateCalculate.getRuleType());
        calculate.setSelected(templateCalculate.getSelected());
        if (CollectionUtil.listNotEmptyNotSizeZero(templateLimits) && StringUtils.isNotBlank((CharSequence)importVo.getLimitContext())) {
            List<PromotionRuleEditVo.KeyValParamControl> importControls;
            List<String> numbers;
            ArrayList<PromotionRuleEditVo.ControlRow> controlLimitRows = new ArrayList<PromotionRuleEditVo.ControlRow>();
            Map<String, PromotionRuleSelectionVo> templateLimitMap = templateLimits.stream().collect(Collectors.toMap(PromotionRuleSelectionVo::getRuleCode, vo -> vo));
            String limitQty = "^\u6570\u91cf\u9650\\d+(.\\d+)?$";
            String limitAmount = "\u91d1\u989d\u9650\\d*(.\\d{1,2})?$";
            String numberReg = "\\d+(.\\d+)?";
            String limitContext = importVo.getLimitContext();
            ArrayList tempRows = Lists.newArrayList();
            List<String> texts = Arrays.asList(limitContext.split(";"));
            if (texts.size() > 1) {
                throw new BusinessException("\u9650\u91cf\u89c4\u5219\u6587\u672c\u6570\u91cf\u548c\u91d1\u989d\u6700\u591a\u9650\u4e00\u79cd");
            }
            limitContext = texts.get(0);
            String ruleCode = "";
            PromotionRuleEditVo.ControlRow controlRow = new PromotionRuleEditVo.ControlRow();
            controlRow.setControlKey("control_key");
            if (this.match(limitContext, limitQty)) {
                controlRow.setText("\u6570\u91cf\u4e0a\u9650");
                numbers = PromotionPolicyServiceImpl.findListByReg(limitContext, numberReg);
                importControls = this.getImportLimitControls(numbers.get(0), "\u6570\u91cf\u4e0a\u9650");
                ruleCode = "C1001";
            } else if (this.match(limitContext, limitAmount)) {
                controlRow.setText("\u91d1\u989d\u4e0a\u9650");
                numbers = PromotionPolicyServiceImpl.findListByReg(limitContext, numberReg);
                importControls = this.getImportLimitControls(numbers.get(0), "\u91d1\u989d\u4e0a\u9650");
                ruleCode = "C1002";
            } else {
                throw new BusinessException("\u9650\u91cf\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
            controlRow.setControls(importControls);
            controlLimitRows.add(controlRow);
            PromotionRuleSelectionVo templateLimited = templateLimitMap.get(ruleCode);
            PromotionPolicyRuleEditVo limit = new PromotionPolicyRuleEditVo();
            limit.setPromotionPolicyTemplateCode(templateEditVo.getTemplateCode());
            limit.setPromotionPolicyTemplateId(templateEditVo.getId());
            limit.setPromotionRuleId(templateLimited.getId());
            limit.setRuleCode(templateLimited.getRuleCode());
            limit.setRuleName(templateLimited.getRuleName());
            limit.setRuleType(templateLimited.getRuleType());
            limit.setSelected(Boolean.valueOf(true));
            limit.setControlRows(controlLimitRows);
            limits.add(limit);
            rule.setRulesAsLimited((List)limits);
        }
        conditions.add(condition);
        calculates.add(calculate);
        rule.setRulesAsCondition((List)conditions);
        rule.setRulesAsCalculate((List)calculates);
        return rule;
    }

    private List<PromotionRuleEditVo.ControlRow> buildImportControlRows(PromotionImportVo importVo, PromotionRuleSelectionVo templateCondition) {
        String countCount = "^\u6ee1\\d+(.\\d+)?\u6570\u91cf(,|\uff0c)(\u8d60|\u9001)\\d+(.\\d+)?\u6570\u91cf$";
        String countAmount = "^\u6ee1\\d+(.\\d+)?\u6570\u91cf(,|\uff0c)(\u8d60|\u9001)\\d+(.\\d+)?\u91d1\u989d$";
        String amountCount = "^\u6ee1\\d+(.\\d+)?\u91d1\u989d(,|\uff0c)(\u8d60|\u9001)\\d+(.\\d+)?\u6570\u91cf$";
        String amountAmount = "^\u6ee1\\d+(.\\d+)?\u91d1\u989d(,|\uff0c)(\u8d60|\u9001)\\d+(.\\d+)?\u91d1\u989d$";
        String special = "\u7279\u4ef7\\d*(.\\d*)?\u4ef7\u683c$";
        String numberReg = "\\d+(.\\d+)?";
        String context = importVo.getCalculateContext();
        if (StringUtils.isBlank((CharSequence)context)) {
            PromotionRuleEditVo.TestParam testParam = (PromotionRuleEditVo.TestParam)JSONObject.parseObject((String)templateCondition.getTestParam(), PromotionRuleEditVo.TestParam.class);
            return Lists.newArrayList((Object[])new PromotionRuleEditVo.ControlRow[]{testParam.getControlRow()});
        }
        ArrayList controlRows = Lists.newArrayList();
        List<String> texts = Arrays.asList(context.split(";"));
        HashSet regResult = Sets.newHashSet();
        for (String t : texts) {
            List<PromotionRuleEditVo.KeyValParamControl> importControls;
            List<String> numbers;
            PromotionRuleEditVo.ControlRow controlRow = new PromotionRuleEditVo.ControlRow();
            controlRow.setControlKey("control_key");
            if (this.match(t, countCount)) {
                controlRow.setText("\u672c\u5355\u4e2d\u672c\u54c1\u8d2d\u4e70\u6ee1");
                numbers = PromotionPolicyServiceImpl.findListByReg(t, numberReg);
                importControls = this.getImportControls(numbers.get(0), numbers.get(1), "count", "count");
                regResult.add(1);
            } else if (this.match(t, countAmount)) {
                controlRow.setText("\u672c\u5355\u4e2d\u672c\u54c1\u8d2d\u4e70\u6ee1");
                numbers = PromotionPolicyServiceImpl.findListByReg(t, numberReg);
                importControls = this.getImportControls(numbers.get(0), numbers.get(1), "count", "amount");
                regResult.add(2);
            } else if (this.match(t, amountCount)) {
                controlRow.setText("\u672c\u5355\u4e2d\u672c\u54c1\u8d2d\u4e70\u6ee1");
                numbers = PromotionPolicyServiceImpl.findListByReg(t, numberReg);
                importControls = this.getImportControls(numbers.get(0), numbers.get(1), "amount", "count");
                regResult.add(3);
            } else if (this.match(t, amountAmount)) {
                controlRow.setText("\u672c\u5355\u4e2d\u672c\u54c1\u8d2d\u4e70\u6ee1");
                numbers = PromotionPolicyServiceImpl.findListByReg(t, numberReg);
                importControls = this.getImportControls(numbers.get(0), numbers.get(1), "amount", "amount");
                regResult.add(4);
            } else if (this.match(t, special)) {
                numbers = PromotionPolicyServiceImpl.findListByReg(t, numberReg);
                importControls = this.getImportControls("1", numbers.get(0), "price", "price");
                regResult.add(5);
            } else {
                throw new BusinessException("\u9636\u68af\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
            controlRow.setControls(importControls);
            controlRows.add(controlRow);
        }
        ValidateUtils.isTrue((regResult.size() == 1 ? 1 : 0) != 0, (String)"\u5982\u679c\u6709\u591a\u4e2a\u9636\u68af\uff0c\u6bcf\u4e2a\u9636\u68af\u53ea\u80fd\u662f\u4e00\u79cd\u7c7b\u578b", (Object[])new Object[0]);
        return controlRows;
    }

    private List<PromotionRuleEditVo.ControlRow> buildImportLimitControlRows(PromotionImportVo importVo, PromotionRuleSelectionVo templateLimited, PromotionPolicyTemplateEditVo templateEditVo) {
        String limitQty = "^\u6570\u91cf\u9650\\d+(.\\d+)?$";
        String limitAmount = "\u91d1\u989d\u9650\\d*(.\\d{1,2})?$";
        String numberReg = "\\d+(.\\d+)?";
        String limitContext = importVo.getLimitContext();
        if (Objects.isNull(templateLimited)) {
            if (StringUtils.isNotEmpty((CharSequence)limitContext)) {
                throw new BusinessException("\u4fc3\u9500\u6a21\u677f\u3010" + templateEditVo.getTemplateCode() + "\u3011\u6ca1\u6709\u9650\u91cf\u914d\u7f6e");
            }
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank((CharSequence)limitContext)) {
            PromotionRuleEditVo.TestParam testParam = (PromotionRuleEditVo.TestParam)JSONObject.parseObject((String)templateLimited.getTestParam(), PromotionRuleEditVo.TestParam.class);
            return Lists.newArrayList((Object[])new PromotionRuleEditVo.ControlRow[]{testParam.getControlRow()});
        }
        ArrayList controlRows = Lists.newArrayList();
        List<String> texts = Arrays.asList(limitContext.split(";"));
        if (texts.size() > 1) {
            throw new BusinessException("\u9650\u91cf\u89c4\u5219\u6587\u672c\u6570\u91cf\u548c\u91d1\u989d\u6700\u591a\u9650\u4e00\u79cd");
        }
        for (String t : texts) {
            List<PromotionRuleEditVo.KeyValParamControl> importControls;
            List<String> numbers;
            PromotionRuleEditVo.ControlRow controlRow = new PromotionRuleEditVo.ControlRow();
            controlRow.setControlKey("control_key");
            if (this.match(t, limitQty)) {
                controlRow.setText("\u6570\u91cf\u4e0a\u9650");
                numbers = PromotionPolicyServiceImpl.findListByReg(t, numberReg);
                importControls = this.getImportLimitControls(numbers.get(0), "\u6570\u91cf\u4e0a\u9650");
            } else if (this.match(t, limitAmount)) {
                controlRow.setText("\u91d1\u989d\u4e0a\u9650");
                numbers = PromotionPolicyServiceImpl.findListByReg(t, numberReg);
                importControls = this.getImportLimitControls(numbers.get(0), "\u91d1\u989d\u4e0a\u9650");
            } else {
                throw new BusinessException("\u9636\u68af\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
            controlRow.setControls(importControls);
            controlRows.add(controlRow);
        }
        return controlRows;
    }

    private static List<String> findListByReg(String text, String reg) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(text);
        ArrayList result = Lists.newArrayList();
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    private List<PromotionRuleEditVo.KeyValParamControl> getImportControls(String firstValue, String secondValue, String firstType, String secondType) {
        boolean specialPrice = "price".equals(firstType) && "price".equals(secondType);
        PromotionRuleEditVo.KeyValParamControl input_base = new PromotionRuleEditVo.KeyValParamControl();
        input_base.setDescription("\u8bf7\u8f93\u5165\u672c\u54c1" + (Objects.equals(firstType, "count") ? "\u6570\u91cf" : "\u91d1\u989d"));
        input_base.setControlType(PromotionRuleEditVo.KeyValParam.ControlType.input.name());
        input_base.setKey("buyNo");
        input_base.setValue((Object)firstValue);
        input_base.setSelectOptions((List)Lists.newArrayList());
        PromotionRuleEditVo.KeyValParamControl input_gift = new PromotionRuleEditVo.KeyValParamControl();
        input_gift.setDescription("\u8bf7\u8f93\u5165\u8d60\u54c1" + (Objects.equals(secondType, "count") ? "\u6570\u91cf" : "\u91d1\u989d"));
        input_gift.setControlType(PromotionRuleEditVo.KeyValParam.ControlType.input.name());
        input_gift.setKey("giftNo");
        input_gift.setValue((Object)secondValue);
        input_gift.setSelectOptions((List)Lists.newArrayList());
        if (specialPrice) {
            input_gift.setLabel("\u7279\u4ef7");
        }
        ArrayList controls = Lists.newArrayList();
        if (!specialPrice) {
            controls.add(input_base);
        }
        if (secondValue != null) {
            controls.add(input_gift);
        }
        return controls;
    }

    private List<PromotionRuleEditVo.KeyValParamControl> getImportLimitControls(String value, String desc) {
        PromotionRuleEditVo.KeyValParamControl input_base = new PromotionRuleEditVo.KeyValParamControl();
        input_base.setDescription(desc);
        input_base.setControlType(PromotionRuleEditVo.KeyValParam.ControlType.input.name());
        input_base.setKey("limited");
        input_base.setValue((Object)value);
        input_base.setSelectOptions((List)Lists.newArrayList());
        ArrayList controls = Lists.newArrayList();
        controls.add(input_base);
        return controls;
    }

    private boolean match(String text, String reg) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }

    private PromotionPolicyScope buildImportScopes(PromotionImportVo importVo) {
        PromotionPolicyScopeEditVo scopeEditVo;
        int i;
        PromotionPolicyScope scope = new PromotionPolicyScope();
        PromotionPolicyScopeGroup cusOrgGroup = new PromotionPolicyScopeGroup();
        PromotionPolicyScopeGroup cusGroup = new PromotionPolicyScopeGroup();
        PromotionPolicyScopeGroup terminalGroup = new PromotionPolicyScopeGroup();
        PromotionPolicyScopeGroup terminalOrgGroup = new PromotionPolicyScopeGroup();
        ArrayList cusList = Lists.newArrayList();
        ArrayList cusOrgList = Lists.newArrayList();
        ArrayList terminalList = Lists.newArrayList();
        ArrayList terminalOrgList = Lists.newArrayList();
        List<Object> cusCodes = Lists.newArrayList();
        List<Object> cusNames = Lists.newArrayList();
        List<Object> orgCodes = Lists.newArrayList();
        List<Object> orgNames = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)importVo.getCusCodes())) {
            cusCodes = Arrays.asList(importVo.getCusCodes().split(","));
        }
        if (StringUtils.isNotBlank((CharSequence)importVo.getCusNames())) {
            cusNames = Arrays.asList(importVo.getCusNames().split(","));
        }
        if (StringUtils.isNotBlank((CharSequence)importVo.getOrgCodes())) {
            orgCodes = Arrays.asList(importVo.getOrgCodes().split(","));
        }
        if (StringUtils.isNotBlank((CharSequence)importVo.getOrgNames())) {
            orgNames = Arrays.asList(importVo.getOrgNames().split(","));
        }
        ValidateUtils.isTrue((cusCodes.size() == cusNames.size() ? 1 : 0) != 0, (String)"\u5ba2\u6237/\u7ec8\u7aef\u7f16\u7801\u540d\u79f0\u5e94\u8be5\u4e00\u4e00\u5bf9\u5e94", (Object[])new Object[0]);
        ValidateUtils.isTrue((orgCodes.size() == orgNames.size() ? 1 : 0) != 0, (String)"\u5ba2\u6237/\u7ec8\u7aef\u7ec4\u7ec7\u7f16\u7801\u540d\u79f0\u5e94\u8be5\u4e00\u4e00\u5bf9\u5e94", (Object[])new Object[0]);
        for (i = 0; i < cusCodes.size(); ++i) {
            scopeEditVo = new PromotionPolicyScopeEditVo();
            if (Objects.equals(importVo.getScopeType(), "terminal")) {
                scopeEditVo.setContainable("Y");
                scopeEditVo.setScopeType(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL.getItemCode());
                scopeEditVo.setScopeCode((String)cusCodes.get(i));
                scopeEditVo.setScopeName((String)cusNames.get(i));
                terminalList.add(scopeEditVo);
                continue;
            }
            scopeEditVo.setContainable("Y");
            scopeEditVo.setScopeType(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode());
            scopeEditVo.setScopeCode((String)cusCodes.get(i));
            scopeEditVo.setScopeName((String)cusNames.get(i));
            cusList.add(scopeEditVo);
        }
        for (i = 0; i < orgCodes.size(); ++i) {
            scopeEditVo = new PromotionPolicyScopeEditVo();
            if (Objects.equals(importVo.getScopeType(), "terminal")) {
                scopeEditVo.setContainable("Y");
                scopeEditVo.setScopeType(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL_ORG.getItemCode());
                scopeEditVo.setScopeCode((String)orgCodes.get(i));
                scopeEditVo.setScopeName((String)orgNames.get(i));
                terminalOrgList.add(scopeEditVo);
                continue;
            }
            scopeEditVo.setContainable("Y");
            scopeEditVo.setScopeType(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode());
            scopeEditVo.setScopeCode((String)orgCodes.get(i));
            scopeEditVo.setScopeName((String)orgNames.get(i));
            cusOrgList.add(scopeEditVo);
        }
        cusOrgGroup.setContainY((List)cusOrgList);
        cusGroup.setContainY((List)cusList);
        terminalGroup.setContainY((List)terminalList);
        terminalOrgGroup.setContainY((List)terminalOrgList);
        if (Objects.equals(importVo.getScopeType(), "terminal")) {
            scope.setScopesAsTerminal(terminalGroup);
            scope.setScopesAsTerminalOrg(terminalOrgGroup);
        } else {
            scope.setScopesAsCust(cusGroup);
            scope.setScopesAsOrg(cusOrgGroup);
        }
        return scope;
    }

    private PromotionPolicyProduct buildImportProducts(PromotionImportVo importVo) {
        PromotionPolicyProductEditVo productEditVo;
        int i;
        PromotionPolicyProduct policyProduct = new PromotionPolicyProduct();
        ArrayList currents = Lists.newArrayList();
        ArrayList gifts = Lists.newArrayList();
        List<Object> currentCodes = Lists.newArrayList();
        List<Object> currentSapCodes = Lists.newArrayList();
        List<Object> currentNames = Lists.newArrayList();
        List<Object> giftCodes = Lists.newArrayList();
        List<Object> giftSapCodes = Lists.newArrayList();
        List<Object> giftNames = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)importVo.getCurrentProductCode())) {
            currentCodes = Arrays.asList(importVo.getCurrentProductCode().split(","));
            currentSapCodes = Arrays.asList(importVo.getCurrentProductSapCode().split(","));
        }
        if (StringUtils.isNotBlank((CharSequence)importVo.getCurrentProductName())) {
            currentNames = Arrays.asList(importVo.getCurrentProductName());
        }
        ValidateUtils.isTrue((currentCodes.size() == currentNames.size() ? 1 : 0) != 0, (String)"\u672c\u54c1\u7f16\u7801\u548c\u540d\u79f0\u5e94\u8be5\u4e00\u4e00\u5bf9\u5e94", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)importVo.getGiftProductCodes())) {
            giftCodes = Arrays.asList(importVo.getGiftProductCodes().split(","));
            giftSapCodes = Arrays.asList(importVo.getGiftProductSapCodes().split(","));
        }
        if (StringUtils.isNotBlank((CharSequence)importVo.getGiftProductNames())) {
            giftNames = Arrays.asList(importVo.getGiftProductNames().split(","));
        }
        ValidateUtils.isTrue((giftCodes.size() == giftNames.size() ? 1 : 0) != 0, (String)"\u8d60\u54c1\u7f16\u7801\u548c\u540d\u79f0\u5e94\u8be5\u4e00\u4e00\u5bf9\u5e94", (Object[])new Object[0]);
        for (i = 0; i < currentCodes.size(); ++i) {
            productEditVo = new PromotionPolicyProductEditVo();
            productEditVo.setProductCode((String)currentCodes.get(i));
            productEditVo.setExt1((String)currentSapCodes.get(i));
            productEditVo.setProductName((String)currentNames.get(i));
            productEditVo.setCurrentProduct("Y");
            if (Objects.equals(importVo.getPromotionProductType(), PromotionPolicyEunm.PromotionProductTypeEunm.CURRENT_RELATIONAL_GIFT.getCode()) && !Objects.equals(importVo.getPromotionType(), PromotionPolicyEunm.PromotionTypeEunm.SPECIALPRICE.getCode())) {
                productEditVo.setProductCodeGift((String)giftCodes.get(i));
                productEditVo.setExt11((String)giftSapCodes.get(i));
                productEditVo.setProductNameGift((String)giftNames.get(i));
            }
            currents.add(productEditVo);
        }
        if (!Objects.equals(importVo.getPromotionProductType(), PromotionPolicyEunm.PromotionProductTypeEunm.CURRENT_RELATIONAL_GIFT.getCode()) && !Objects.equals(importVo.getPromotionType(), PromotionPolicyEunm.PromotionTypeEunm.SPECIALPRICE.getCode())) {
            for (i = 0; i < giftCodes.size(); ++i) {
                productEditVo = new PromotionPolicyProductEditVo();
                productEditVo.setProductCode((String)giftCodes.get(i));
                productEditVo.setExt1((String)giftSapCodes.get(i));
                productEditVo.setProductName((String)giftNames.get(i));
                productEditVo.setCurrentProduct("N");
                gifts.add(productEditVo);
            }
        }
        policyProduct.setProductsCurrentY((List)currents);
        policyProduct.setProductsCurrentN((List)gifts);
        return policyProduct;
    }

    private PromotionPolicyConfigInfo loadPromotionPolicyRuleInfo(PromotionPolicyInfoDataVo infoVo) {
        List<PromotionPolicyRuleEntity> promotionPolicyRules = this.promotionPolicyRuleService.getRuleByPromotionPolicyIdOrCode(infoVo.getId(), null);
        Map<String, List<PromotionPolicyRuleEntity>> rulesMapAsPolicyRules = promotionPolicyRules.stream().collect(Collectors.groupingBy(PromotionPolicyRuleEntity::getRuleType));
        PromotionPolicyRuleEntity conditionAsPolicyRules = rulesMapAsPolicyRules.get(PromotionRuleVo.RULE_TYPE.condition.name()).get(0);
        PromotionPolicyRuleEntity calculateAsPolicyRules = rulesMapAsPolicyRules.get(PromotionRuleVo.RULE_TYPE.calculate.name()).get(0);
        List<PromotionPolicyRuleEntity> limitedAsPolicyRules = rulesMapAsPolicyRules.get(PromotionRuleVo.RULE_TYPE.limit.name());
        Set<String> ruleIds = promotionPolicyRules.stream().map(PromotionPolicyRuleEntity::getPromotionRuleId).collect(Collectors.toSet());
        Map<String, List<PromotionRuleEntity>> rulesMap = this.promotionRuleService.getListByIds(ruleIds).stream().collect(Collectors.groupingBy(PromotionRuleEntity::getRuleType));
        PromotionRuleEntity condition = rulesMap.get(PromotionRuleVo.RULE_TYPE.condition.name()).get(0);
        PromotionRuleEntity calculate = rulesMap.get(PromotionRuleVo.RULE_TYPE.calculate.name()).get(0);
        PromotionPolicyRuleVo calculateRuleVo = (PromotionPolicyRuleVo)CrmBeanUtil.copy((Object)calculateAsPolicyRules, PromotionPolicyRuleVo.class);
        calculateRuleVo.setFuncBody(calculate.getFuncBody());
        PromotionPolicyRuleVo conditionRuleVo = (PromotionPolicyRuleVo)CrmBeanUtil.copy((Object)conditionAsPolicyRules, PromotionPolicyRuleVo.class);
        conditionRuleVo.setFuncBody(condition.getFuncBody());
        List limitedRuleVo = CrmBeanUtil.copyList(limitedAsPolicyRules, PromotionPolicyRuleVo.class);
        List<PromotionRuleEntity> limitedTemp = rulesMap.get(PromotionRuleVo.RULE_TYPE.limit.name());
        HashMap limited = null == limitedTemp ? Maps.newHashMap() : limitedTemp.stream().collect(Collectors.toMap(PromotionRuleEntity::getRuleCode, v -> v, (t, t2) -> t2));
        limitedRuleVo.forEach(v -> {
            PromotionRuleEntity temp = (PromotionRuleEntity)limited.get(v.getRuleCode());
            if (null != temp) {
                v.setFuncBody(temp.getFuncBody());
            }
        });
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = new PromotionPolicyConfigInfo();
        promotionPolicyConfigInfo.setPromotionPolicyInfoVo(infoVo);
        promotionPolicyConfigInfo.setCalculate(calculateRuleVo);
        promotionPolicyConfigInfo.setCondition(conditionRuleVo);
        promotionPolicyConfigInfo.setLimited(limitedRuleVo);
        return promotionPolicyConfigInfo;
    }

    private void countingPromotionPolicyToProduct(LoadConfigInfoContext context, PromotionPolicyConfigInfo promotionPolicyConfigInfo, Map<String, List<PromotionPolicyConfigInfo>> result) {
        Map<String, PromotionPolicyProductEntity> currentProduct = context.getCurrentProductY().get(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getId());
        if (CollectionUtils.isEmpty(currentProduct)) {
            return;
        }
        String productCodes = currentProduct.keySet().stream().collect(Collectors.joining(","));
        if (StringUtils.isBlank((CharSequence)productCodes)) {
            return;
        }
        ArrayList configInfos = result.get(productCodes);
        if (null == configInfos) {
            configInfos = Lists.newArrayList();
        }
        if (context.isDuplicationPromotionPolicy(productCodes, promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getId())) {
            return;
        }
        configInfos.add(promotionPolicyConfigInfo);
        result.put(productCodes, configInfos);
    }

    private void buildProductInfoGiftY(PromotionPolicyConfigInfo promotionPolicyConfigInfo, LoadConfigInfoContext context) {
        Map<String, MdmProductRespVo> currentProductInfoNMap = context.getCurrentProductInfoNMap();
        String promotionPolicyId = promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getId();
        Map<String, PromotionPolicyProductEntity> currentProductN = context.getCurrentProductN().get(promotionPolicyId);
        HashMap gitProductModulus = new HashMap(currentProductN.size());
        ArrayList productsGift = Lists.newArrayList();
        currentProductN.forEach((productCode, entity) -> {
            gitProductModulus.put(productCode, entity.getProductOrderQty());
            MdmProductRespVo productRespVo = (MdmProductRespVo)currentProductInfoNMap.get(productCode);
            if (null != productRespVo) {
                productsGift.add(productRespVo);
            }
        });
        promotionPolicyConfigInfo.setGitProductModulus(gitProductModulus);
        promotionPolicyConfigInfo.setProductsGift((List)productsGift);
    }

    private void checkConfigInfoQueryVo(PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        if (null == configInfoQueryVo) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)configInfoQueryVo.getCustCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u7f16\u7801");
        }
        if (StringUtils.isBlank((CharSequence)configInfoQueryVo.getSearchTime())) {
            configInfoQueryVo.setSearchTime(DateUtil.dateNowHms());
        }
        if (CollectionUtils.isEmpty((Collection)configInfoQueryVo.getOrderProductInfos())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        }
        configInfoQueryVo.getOrderProductInfos().forEach(v -> {
            if (StringUtils.isBlank((CharSequence)v.getProductCode())) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1\u7f16\u7801");
            }
            if (null == v.getProductBuyNo()) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1[" + v.getProductCode() + "]\u8d2d\u4e70\u6570\u91cf");
            }
            if (null == v.getProductBuyAmount()) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1[" + v.getProductCode() + "]\u8d2d\u4e70\u91d1\u989d");
            }
        });
    }
}

