/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAndOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.promotion.service.ExcelHandleService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@ConditionalOnMissingBean(name={"excelHandleServiceImpl"})
@Service(value="excelHandleService")
public class ExcelHandleServiceImpl
implements ExcelHandleService {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    public void downloadUncludeCusTemplate(HttpServletResponse response) {
        org.springframework.core.io.Resource resource = this.applicationContext.getResource("classpath:template/unclude_cus_import_template.xlsx");
        try (InputStream inputStream = resource.getInputStream();
             ServletOutputStream outputStream = response.getOutputStream();){
            int len;
            response.setContentType("application/vnd..ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u975e\u5305\u542b\u5ba2\u6237\u5bfc\u5165\u6a21\u677f.xls", "utf-8"));
            byte[] bytes = new byte[1024];
            while ((len = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<MdmCustomerMsgRespVo> analysisUncludeExcel(HttpServletRequest request) {
        try (ServletInputStream inputStream = request.getInputStream();){
            String orgCodeStr = request.getParameter("orgs");
            ExcelReaderBuilder excelReaderBuilder = EasyExcel.read((InputStream)inputStream);
            excelReaderBuilder.autoCloseStream(Boolean.valueOf(true));
            excelReaderBuilder.excelType(ExcelTypeEnum.XLSX);
            ExcelReaderSheetBuilder sheet = excelReaderBuilder.sheet(Integer.valueOf(0));
            List list2 = sheet.doReadSync();
            ValidateUtils.notEmpty((Collection)list2, (String)"excel\u8868\u683c\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u662f\u5426\u6b63\u786e", (String[])new String[0]);
            ArrayList cusList = Lists.newArrayList();
            list2.forEach(li -> cusList.add(li.get(0)));
            MdmCustomerAndOrgReqVo mdmCustomerAndOrgReqVo = new MdmCustomerAndOrgReqVo();
            mdmCustomerAndOrgReqVo.setCustomerCodeList((List)cusList);
            List listResult = (List)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.findSubCustomerList(mdmCustomerAndOrgReqVo), (boolean)true);
            String msg = this.validateCusList(listResult, orgCodeStr);
            ValidateUtils.isTrue((boolean)StringUtils.isEmpty((String)msg), (String)msg, (Object[])new Object[0]);
            List list = listResult;
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Lists.newArrayList();
        }
    }

    private String validateCusList(List<MdmCustomerMsgRespVo> listResult, String orgCodeStr) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtil.listEmpty(listResult)) {
            return new String();
        }
        if (StringUtils.isEmpty((String)orgCodeStr)) {
            return new String();
        }
        ArrayList orgCodeList = Lists.newArrayList(Arrays.asList(orgCodeStr.split(",")));
        List allOrgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf((List)orgCodeList);
        for (MdmCustomerMsgRespVo cus : listResult) {
            if (StringUtils.isEmpty((String)cus.getOrgCode())) continue;
            ArrayList orgCodes = Lists.newArrayList(Arrays.asList(cus.getOrgCode().split(",")));
            List childrenOrg = OrgUtil.getChildrenOrgCodeListIncludeSelf((List)orgCodes);
            if (CollectionUtil.listEmpty((List)childrenOrg)) {
                builder.append(";\u5ba2\u6237".concat(cus.getCustomerCode()).concat("\u4e0d\u6b63\u786e,\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u5305\u542b\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7"));
                continue;
            }
            boolean flag = false;
            for (String org : childrenOrg) {
                if (!allOrgCodeList.contains(org)) continue;
                flag = true;
            }
            if (flag) continue;
            builder.append(";\u5ba2\u6237".concat(cus.getCustomerCode()).concat("\u4e0d\u6b63\u786e,\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u5305\u542b\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7"));
        }
        return builder.length() > 0 ? builder.substring(1) : new String();
    }
}

