/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.util;

import com.biz.crm.nebular.dms.salecontract.ContractTemplateTupleMappingVo;
import com.biz.crm.nebular.dms.salecontract.ContractTemplateVo;
import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContractTemplateUtil {
    public static void validateAdd(ContractTemplateVo contractTemplateVo) {
        ValidateUtils.validate((Object)contractTemplateVo, (String)"\u5408\u540c\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.notEmpty((Collection)contractTemplateVo.getTuples(), (String)"\u5143\u7ec4\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        ValidateUtils.validate((Object)contractTemplateVo.getName(), (String)"\u5408\u540c\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        contractTemplateVo.getTuples().forEach(tuple -> {
            ValidateUtils.validate((Object)tuple.getCode(), (String)"\u5143\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            ValidateUtils.validate((Object)tuple.getTupleIndex(), (String)"\u5143\u7ec4\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            ValidateUtils.validate((Object)tuple.getJsonName(), (String)"\u5143\u7ec4\u5bf9\u8c61\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }

    public static List<ContractTemplateTupleMappingVo> buildTemplateTupleMappingVo(List<ContractTupleVo> tupleVos, String templateCode) {
        if (CollectionUtil.listEmpty(tupleVos)) {
            return Lists.newArrayList();
        }
        ValidateUtils.validate((Object)templateCode, (String)"\u6784\u5efa\u6a21\u677f\u548c\u5143\u7ec4\u6620\u5c04\u65b0\u589e/\u7f16\u8f91\u53c2\u6570\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList result = Lists.newArrayList();
        tupleVos.forEach(tuple -> {
            ContractTemplateTupleMappingVo mappingVo = new ContractTemplateTupleMappingVo();
            mappingVo.setTemplateCode(templateCode);
            mappingVo.setTupleIndex(tuple.getTupleIndex());
            mappingVo.setJsonName(tuple.getJsonName());
            mappingVo.setTupleCode(tuple.getCode());
            result.add(mappingVo);
        });
        return result;
    }

    public static void validateEdit(ContractTemplateVo contractTemplateVo) {
        ContractTemplateUtil.validateAdd(contractTemplateVo);
        ValidateUtils.validate((Object)contractTemplateVo.getId(), (String)"\u7f16\u8f91\u6a21\u677f\u65f6\uff0c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)contractTemplateVo.getCode(), (String)"\u7f16\u8f91\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

