/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.orderfeerate.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderFeeRateEunm;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepProductVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateVo;
import com.biz.crm.orderfeerate.entity.OrderFeeRateEntity;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="orderFeeRateUtil")
@ConditionalOnMissingBean(name={"orderFeeRateUtilExpand"})
public class OrderFeeRateUtil {
    public static final String patternDicCode = "order_fee_rate_pattern";
    public static final String useTotalDicCode = "useTotal";

    public void validate(OrderFeeRateVo vo) {
        ValidateUtils.validate((Object)vo.getRate(), (String)"\u4f7f\u7528\u6bd4\u4f8b\u4e3a\u7a7a!");
        if (vo.getRate().compareTo(BigDecimal.ZERO) < 0 || vo.getRate().compareTo(new BigDecimal(100)) > 0) {
            throw new BusinessException("\u4f7f\u7528\u6bd4\u4f8b\u5e94\u8be5\u5728 0 ~ 100\u4e4b\u95f4\uff0c\u5305\u62ec0\u548c100");
        }
        ValidateUtils.validate((Object)vo.getFeeType(), (String)"\u8d39\u7528\u6c60\u7c7b\u578b\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getDemension(), (String)"\u7ef4\u5ea6\u4e3a\u7a7a!");
        this.validateDemension(vo);
    }

    public void validateDemension(OrderFeeRateVo vo) {
        if (vo.getDemension().equals(OrderFeeRateEunm.demension.PRODUCT.getCode())) {
            ValidateUtils.validate((Object)vo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a!");
        } else if (vo.getDemension().equals(OrderFeeRateEunm.demension.PRODUCTLEVEL.getCode())) {
            ValidateUtils.validate((Object)vo.getProductLevelCode(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e3a\u7a7a!");
        } else if (vo.getDemension().equals(OrderFeeRateEunm.demension.CUS.getCode())) {
            ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getCusName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a!");
        } else if (vo.getDemension().equals(OrderFeeRateEunm.demension.ORG.getCode())) {
            ValidateUtils.validate((Object)vo.getOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getOrgName(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a!");
        } else if (vo.getDemension().equals(OrderFeeRateEunm.demension.ORGPRODUCT.getCode())) {
            ValidateUtils.validate((Object)vo.getOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getOrgName(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a!");
        } else if (vo.getDemension().equals(OrderFeeRateEunm.demension.ORGPRODUCTLEVEL.getCode())) {
            ValidateUtils.validate((Object)vo.getOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getOrgName(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductLevelCode(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e3a\u7a7a!");
        } else if (vo.getDemension().equals(OrderFeeRateEunm.demension.CUSPRODUCT.getCode())) {
            ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getCusName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a!");
        } else if (vo.getDemension().equals(OrderFeeRateEunm.demension.CUSPRODUCTLEVEL.getCode())) {
            ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getCusName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductLevelCode(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e3a\u7a7a!");
        }
    }

    public String packageOnlyKey(OrderFeeRateEntity entity) {
        StringBuilder stb = new StringBuilder();
        stb.append(entity.getFeeType());
        if (entity.getDemension().equals(OrderFeeRateEunm.demension.PRODUCT.getCode())) {
            stb.append(entity.getProductCode());
        } else if (entity.getDemension().equals(OrderFeeRateEunm.demension.PRODUCTLEVEL.getCode())) {
            stb.append(entity.getProductLevelCode());
        } else if (entity.getDemension().equals(OrderFeeRateEunm.demension.CUS.getCode())) {
            stb.append(entity.getCusCode());
        } else if (entity.getDemension().equals(OrderFeeRateEunm.demension.ORG.getCode())) {
            stb.append(entity.getOrgCode());
        } else if (entity.getDemension().equals(OrderFeeRateEunm.demension.ORGPRODUCT.getCode())) {
            stb.append(entity.getOrgCode()).append(",").append(entity.getProductCode());
        } else if (entity.getDemension().equals(OrderFeeRateEunm.demension.ORGPRODUCTLEVEL.getCode())) {
            stb.append(entity.getOrgCode()).append(",").append(entity.getProductLevelCode());
        } else if (entity.getDemension().equals(OrderFeeRateEunm.demension.CUSPRODUCT.getCode())) {
            stb.append(entity.getCusCode()).append(",").append(entity.getProductCode());
        } else if (entity.getDemension().equals(OrderFeeRateEunm.demension.CUSPRODUCTLEVEL.getCode())) {
            stb.append(entity.getCusCode()).append(",").append(entity.getProductLevelCode());
        }
        return stb.toString();
    }

    public static void validatePattern(OrderFeeRateVo orderFeeRateVo, String useTotal) {
        if (StringUtils.isEmpty((String)useTotal) || YesNoEnum.yesNoEnum.NO.getValue().equals(useTotal)) {
            if (orderFeeRateVo.getFeeType().equals(OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode())) {
                throw new BusinessException("\u6682\u65f6\u4e0d\u652f\u6301\u6c47\u603b\u6a21\u5f0f\uff01");
            }
        } else if (!orderFeeRateVo.getFeeType().equals(OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode())) {
            throw new BusinessException("\u6682\u65f6\u53ea\u652f\u6301\u6c47\u603b\u6a21\u5f0f\uff01");
        }
    }

    public static void validateForCalToRep(OrderFeeRateCalToRepVo vo) {
        ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getOrderMoney(), (String)"\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
        for (OrderFeeRateCalToRepProductVo productVo : vo.getProducts()) {
            if (!StringUtils.isEmpty((String)productVo.getProductCode()) && !StringUtils.isEmpty((String)productVo.getProductLevelCode())) continue;
            throw new BusinessException("\u4ea7\u54c1\u4fe1\u606f\u4e0d\u5b8c\u6574!");
        }
    }

    public static List<OrderFeeRateEntity> filterRate(List<OrderFeeRateEntity> rates, OrderFeeRateCalToRepProductVo product) {
        if (CollectionUtils.isEmpty(rates)) {
            return new ArrayList<OrderFeeRateEntity>();
        }
        ArrayList<OrderFeeRateEntity> reList = new ArrayList<OrderFeeRateEntity>();
        for (OrderFeeRateEntity entity : rates) {
            if (StringUtils.isEmpty((String)entity.getProductCode()) && StringUtils.isEmpty((String)entity.getProductLevelCode())) {
                reList.add(entity);
            }
            if ((StringUtils.isEmpty((String)entity.getProductCode()) || !entity.getProductCode().equals(product.getProductCode())) && (StringUtils.isEmpty((String)entity.getProductLevelCode()) || !entity.getProductLevelCode().equals(product.getProductLevelCode()))) continue;
            reList.add(entity);
        }
        return reList;
    }
}

