/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionAvailableResp;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeSourceVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.promotion.enums.AccountTypeDynamicEnum;
import com.biz.crm.promotion.service.npromotion.PromotionComputeService;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u4fc3\u9500\u653f\u7b56\uff08\u65b0\uff09", tags={""})
@RestController
@RequestMapping(value={"/promotion/v2"})
public class PromotionController {
    @Resource
    private PromotionService promotionService;
    @Resource
    private PromotionComputeService promotionComputeService;

    @CrmLog
    @ApiOperation(value="\u901a\u8fc7\u53c2\u6570\u67e5\u8be2\u4fc3\u9500\u653f\u7b56\u96c6\u5408(\u76ee\u524d\u9700\u8981\u652f\u6301\u901a\u8fc7\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u96c6\u5408promotionCodes\u548c\u662f\u5426\u662f\u67e5\u8be2\u6709\u6548\u7684\u653f\u7b56\u7684\u6807\u8bc6queryEffectiveFlag)")
    @PostMapping(value={"/findPromotionsByParam"})
    public Result<PageResult<PromotionInfoRespVo>> findPromotionsByParam(@RequestBody PromotionPolicyQueryVo reqVo) {
        return Result.ok(this.promotionService.findPromotionsByParam(reqVo));
    }

    @CrmLog
    @ApiOperation(value="\u521b\u5efa\u4fc3\u9500\u653f\u7b56")
    @PostMapping(value={"/create"})
    public Result<PromotionEditVo> create(@RequestBody PromotionEditVo promotionEditVo) {
        PromotionEditVo result = this.promotionService.create(promotionEditVo);
        return Result.ok((Object)result);
    }

    @CrmLog
    @ApiOperation(value="\u66f4\u65b0\u4fc3\u9500\u653f\u7b56")
    @PostMapping(value={"/update"})
    public Result<PromotionEditVo> update(@RequestBody PromotionEditVo promotionEditVo) {
        PromotionEditVo result = this.promotionService.update(promotionEditVo);
        return Result.ok((Object)result);
    }

    @CrmLog
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/findDetailsById/{id}"})
    public Result<PromotionEditVo> findDetailsById(@PathVariable(name="id") String id) {
        PromotionEditVo result = this.promotionService.findDetailsById(id);
        return Result.ok((Object)result);
    }

    @CrmLog
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4fc3\u9500\u8303\u56f4\u6570\u636e\u6e90")
    @PostMapping(value={"/findScopeSourcePage"})
    public Result<PageResult<PromotionScopeSourceVo>> findScopeSourcePage(@RequestBody PromotionScopeSourceVo param) {
        PageResult<PromotionScopeSourceVo> result = this.promotionService.findScopeSourcePage(param);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4fc3\u9500\u653f\u7b56")
    @PostMapping(value={"/findPromotionPageByConditions"})
    public Result<PageResult<PromotionEditVo>> findPromotionPageByConditions(@RequestBody PromotionEditVo param) {
        PageResult<PromotionEditVo> result = this.promotionService.findPromotionPageByConditions(param);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u4ee5\u53ca\u5546\u54c1\uff08\u672c\u54c1\uff09\u67e5\u8be2\u53ef\u7528\u7684\u6240\u6709\u4fc3\u9500\u653f\u7b56")
    @PostMapping(value={"/findAvailablePromotionsByAccount"})
    public Result<List<PromotionAvailableResp>> findAvailablePromotionsByAccount(@RequestBody PromotionQueryReq param) {
        List<PromotionAvailableResp> result = this.promotionComputeService.findAvailablePromotionsByAccount(param);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value="\u6839\u636e\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u5217\u8868\u67e5\u8be2\u4fc3\u9500\u653f\u7b56\u547d\u4e2d\u60c5\u51b5")
    @PostMapping(value={"/findHitPromotionsByPromotionCodes"})
    public Result<List<PromotionEditVo>> findHitPromotionsByPromotionCodes(@RequestBody PromotionQueryReq param) {
        List<PromotionEditVo> result = this.promotionComputeService.findHitPromotionsByPromotionCodes(param);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value="\u6839\u636e\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u5217\u8868\u67e5\u8be2\u4fc3\u9500\u653f\u7b56\u547d\u4e2d\u60c5\u51b5")
    @PostMapping(value={"findHitPromotionMapByPromotionCodes"})
    public Result<Map<String, PromotionEditVo>> findHitPromotionMapByPromotionCodes(@RequestBody ArrayList<PromotionQueryReq> params) {
        Map<String, PromotionEditVo> result = this.promotionComputeService.findHitPromotionMapByPromotionCodes(params);
        return Result.ok(result);
    }

    public static void main(String[] args) {
        PromotionQueryReq req = new PromotionQueryReq();
        req.setAccountCode("2020110802test");
        req.setAccountType(AccountTypeDynamicEnum.CUSTOMER.getCode());
        ArrayList productVos = Lists.newArrayList();
        PromotionSaleProductVo pr = new PromotionSaleProductVo();
        pr.setProductCode("1wztXHGg");
        productVos.add(pr);
        req.setSaleProductVos((List)productVos);
        System.out.println(JSONObject.toJSONString((Object)req));
    }
}

