/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.impl;

import com.biz.crm.promotion.enums.AccountTypeDynamicEnum;
import com.biz.crm.promotion.service.npromotion.PromotionComputeService;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.promotion.service.npromotion.beans.AbstractProductFilter;
import com.biz.crm.promotion.service.npromotion.beans.AbstractScopeFilter;
import com.biz.crm.promotion.service.npromotion.vo.PromotionEditVo;
import com.biz.crm.promotion.service.npromotion.vo.PromotionHitReq;
import com.biz.crm.promotion.service.npromotion.vo.PromotionHitResp;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"promotionComputeServiceExtendImpl"})
public class PromotionComputeServiceImpl
implements PromotionComputeService {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private PromotionService promotionService;
    @Resource
    private AbstractProductFilter productFilter;

    @Override
    public List<PromotionHitResp> findAvailablePromotionsByAccount(PromotionHitReq param) {
        AccountTypeDynamicEnum accountTypeDynamicEnum;
        if (param == null || StringUtils.isEmpty((String)param.getAccountCode())) {
            return Lists.newArrayList();
        }
        if (StringUtils.isEmpty((String)param.getAccountType())) {
            param.setAccountType(AccountTypeDynamicEnum.CUSTOMER.getCode());
        }
        if ((accountTypeDynamicEnum = AccountTypeDynamicEnum.getAccountTypeEnumsByCode(param.getAccountType())) == null || accountTypeDynamicEnum.getFilerBeanCls() == null) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        Object filterObject = this.applicationContext.getAutowireCapableBeanFactory().autowire(accountTypeDynamicEnum.getFilerBeanCls(), 2, true);
        if (filterObject == null) {
            return Lists.newArrayList();
        }
        AbstractScopeFilter filter = (AbstractScopeFilter)filterObject;
        List<String> promotionCodes = filter.apply(param);
        if (CollectionUtil.listEmpty(promotionCodes)) {
            return Lists.newArrayList();
        }
        Map<String, List<String>> productPromotionsMap = this.productFilter.apply(param);
        productPromotionsMap.forEach((productCode, promotionCodeList) -> {
            promotionCodeList.retainAll(promotionCodes);
            if (CollectionUtil.listNotEmpty(param.getPromotionCodes())) {
                promotionCodeList.retainAll(param.getPromotionCodes());
            }
        });
        productPromotionsMap.forEach((k, v) -> {
            PromotionHitResp promotionHitResp = new PromotionHitResp();
            promotionHitResp.setProductCode((String)k);
            List<PromotionEditVo> promotionEditVos = PromotionUtil.getCacheList(v, this.promotionService);
            promotionHitResp.setPromotions(promotionEditVos);
            result.add(promotionHitResp);
        });
        return result;
    }

    @Override
    public List<PromotionHitResp> findHitPromotionsByPromotionCodes(PromotionHitReq param) {
        if (param == null || CollectionUtil.listEmpty(param.getSaleProductVos()) || StringUtils.isEmpty((String)param.getAccountCode()) || StringUtils.isEmpty((String)param.getAccountType())) {
            return Lists.newArrayList();
        }
        ValidateUtils.notEmpty(param.getPromotionCodes(), (String)"\u67e5\u8be2\u547d\u4e2d\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u5fc5\u987b\u4f20\u5165", (String[])new String[0]);
        ValidateUtils.isTrue((param.getPromotionCodes().size() == 1 ? 1 : 0) != 0, (String)"\u53ea\u652f\u6301\u540c\u65f6\u67e5\u4e00\u4e2a\u4fc3\u9500\u653f\u7b56", (Object[])new Object[0]);
        List<PromotionHitResp> availableResult = this.findAvailablePromotionsByAccount(param);
        Map<String, List> availableMap = availableResult.stream().collect(Collectors.toMap(PromotionHitResp::getProductCode, PromotionHitResp::getPromotions));
        ArrayList availableList = Lists.newArrayList();
        availableResult.forEach(hitResp -> availableList.addAll(hitResp.getPromotions()));
        Map<String, PromotionEditVo> promotionEditVoMap = availableList.stream().collect(Collectors.toMap(PromotionEditVo::getPromotionPolicyCode, a -> a, (a, b) -> a));
        return null;
    }
}

