/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.promotion.entity.PromotionPolicyRuleEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyRuleMapper;
import com.biz.crm.promotion.service.npromotion.PromotionRuleService;
import com.biz.crm.promotion.service.npromotion.vo.PromotionRuleVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonFieldUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"promotionRuleServiceExtend"})
public class PromotionRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyRuleMapper, PromotionPolicyRuleEntity>
implements PromotionRuleService {
    @Resource
    private PromotionPolicyRuleMapper promotionPolicyRuleMapper;

    @Override
    @Transactional
    public List<PromotionRuleVo> saveBatch(List<PromotionRuleVo> ruleVos, String promotionPolicyCode) {
        if (CollectionUtil.listEmpty(ruleVos)) {
            return Lists.newArrayList();
        }
        List<PromotionRuleVo> oldRules = this.findByPromotionCode(promotionPolicyCode);
        List createRules = ruleVos.stream().filter(r -> StringUtils.isEmpty((String)r.getId())).collect(Collectors.toList());
        List createEntities = CrmBeanUtil.copyList(createRules, PromotionPolicyRuleEntity.class);
        boolean createFlag = this.saveBatch(createEntities);
        ValidateUtils.isTrue((boolean)createFlag, (String)"\u65b0\u589e\u4fc3\u9500\u89c4\u5219\u5931\u8d25", (Object[])new Object[0]);
        ruleVos.removeAll(createRules);
        ruleVos.addAll(CrmBeanUtil.copyList((List)createEntities, PromotionRuleVo.class));
        List updateRules = ruleVos.stream().filter(r -> StringUtils.isNotEmpty((String)r.getId())).collect(Collectors.toList());
        List updateEntities = CrmBeanUtil.copyList(updateRules, PromotionPolicyRuleEntity.class);
        boolean updateFlag = this.updateBatchById(updateEntities);
        ValidateUtils.isTrue((boolean)updateFlag, (String)"\u66f4\u65b0\u4fc3\u9500\u89c4\u5219\u5931\u8d25", (Object[])new Object[0]);
        List deleteIds = CommonFieldUtil.difference(oldRules, ruleVos, (String[])new String[]{"id"});
        this.removeByIds(deleteIds);
        return ruleVos;
    }

    @Override
    public List<PromotionRuleVo> findByPromotionCode(String promotionPolicyCode) {
        if (StringUtils.isEmpty((String)promotionPolicyCode)) {
            return Lists.newArrayList();
        }
        List entities = this.promotionPolicyRuleMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(PromotionPolicyRuleEntity::getPromotionPolicyCode, (Object)promotionPolicyCode));
        return CrmBeanUtil.copyList((List)entities, PromotionRuleVo.class);
    }
}

