/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.handler;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseBackAllReqVo;
import com.biz.crm.order.entity.OrderEntity;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderBackFeeHandlerExpand"})
@Component(value="orderBackFeeHandler")
public class OrderBackFeeHandler {
    @Autowired
    private FeePoolFeign feePoolFeign;

    public void hand(List<OrderEntity> orderEntities) {
        ArrayList<FeePoolUseBackAllReqVo> params = new ArrayList<FeePoolUseBackAllReqVo>();
        for (OrderEntity order : orderEntities) {
            if (!order.getTemporaryFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) continue;
            FeePoolUseBackAllReqVo feePoolUseBackAllReqVo = new FeePoolUseBackAllReqVo();
            feePoolUseBackAllReqVo.setFromCode(order.getOrderCode());
            feePoolUseBackAllReqVo.setOperationType(FeePoolOperationTypeEnum.ORDER_BACK.getValue());
            params.add(feePoolUseBackAllReqVo);
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        if (!this.feePoolFeign.backAllUseByFromCodeBatch(params).isSuccess()) {
            throw new BusinessException("\u8d39\u7528\u56de\u9000\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u8d39\u7528\u6c60");
        }
    }
}

