/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyProductMapper;
import com.biz.crm.promotion.service.npromotion.PromotionProductService;
import com.biz.crm.promotion.service.npromotion.vo.PromotionProductVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CommonFieldUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"promotionProductServiceExtend"})
public class PromotionProductServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyProductMapper, PromotionPolicyProductEntity>
implements PromotionProductService {
    @Resource
    private PromotionPolicyProductMapper promotionPolicyProductMapper;

    @Override
    @Transactional
    public List<PromotionProductVo> saveBatch(List<PromotionProductVo> productVos, String promotionPolicyCode) {
        if (CollectionUtil.listEmpty(productVos)) {
            return Lists.newArrayList();
        }
        List<PromotionProductVo> oldProducts = this.findByPromotionCode(promotionPolicyCode);
        List createProducts = productVos.stream().filter(r -> StringUtils.isEmpty((String)r.getId())).collect(Collectors.toList());
        List createEntities = CrmBeanUtil.copyList(createProducts, PromotionPolicyProductEntity.class);
        boolean createFlag = this.saveBatch(createEntities);
        ValidateUtils.isTrue((boolean)createFlag, (String)"\u65b0\u589e\u4fc3\u9500\u89c4\u5219\u5931\u8d25", (Object[])new Object[0]);
        productVos.removeAll(createProducts);
        productVos.addAll(CrmBeanUtil.copyList((List)createEntities, PromotionProductVo.class));
        List updateProducts = productVos.stream().filter(r -> StringUtils.isNotEmpty((String)r.getId())).collect(Collectors.toList());
        List updateEntities = CrmBeanUtil.copyList(updateProducts, PromotionPolicyProductEntity.class);
        boolean updateFlag = this.updateBatchById(updateEntities);
        ValidateUtils.isTrue((boolean)updateFlag, (String)"\u66f4\u65b0\u4fc3\u9500\u89c4\u5219\u5931\u8d25", (Object[])new Object[0]);
        List deleteIds = CommonFieldUtil.difference(oldProducts, productVos, (String[])new String[]{"id"});
        this.removeByIds(deleteIds);
        return productVos;
    }

    @Override
    public List<PromotionProductVo> findByPromotionCode(String promotionPolicyCode) {
        if (StringUtils.isEmpty((String)promotionPolicyCode)) {
            return Lists.newArrayList();
        }
        List entities = this.promotionPolicyProductMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(PromotionPolicyProductEntity::getPromotionPolicyCode, (Object)promotionPolicyCode));
        return CrmBeanUtil.copyList((List)entities, PromotionProductVo.class);
    }

    @Override
    public List<String> findPromotionCodesByProductCode(String productCode) {
        if (StringUtils.isEmpty((String)productCode)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PromotionPolicyProductEntity::getCurrentProduct, (Object)CommonConstant.GLOBAL.YesOrNo.Y.getItemCode())).eq(PromotionPolicyProductEntity::getProductCode, (Object)productCode);
        List entities = this.promotionPolicyProductMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        Set promotionCodes = entities.stream().map(PromotionPolicyProductEntity::getProductCode).collect(Collectors.toSet());
        if (!CollectionUtil.collectionNotEmpty(promotionCodes)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(promotionCodes);
    }
}

