/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.listener.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.contractdetails.service.ContractDetailsService;
import com.biz.crm.nebular.dms.contractdetails.ContractDetailsVo;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="contractDetailsListener")
@ConditionalOnMissingBean(name={"contractDetailsListenerExtend"})
public class ContractDetailsListener
implements AbstractContractModelListener {
    @Resource
    private ContractDetailsService contractDetailsService;

    @Override
    @Transactional
    public JSONArray add(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        if (CollectionUtil.jsonArrayEmpty((JSONArray)data)) {
            return new JSONArray();
        }
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)saleContractVo, (String)"\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a");
        List<ContractDetailsVo> vos = BeanCopyUtil.parseByJSONArray(data, ContractDetailsVo.class);
        List<ContractDetailsVo> result = this.contractDetailsService.addBatch(vos, contractCode);
        return BeanCopyUtil.formatJSONArray(result);
    }

    @Override
    @Transactional
    public JSONArray edit(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)saleContractVo, (String)"\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a");
        List<ContractDetailsVo> vos = BeanCopyUtil.parseByJSONArray(data, ContractDetailsVo.class);
        List<ContractDetailsVo> result = this.contractDetailsService.editBatch(vos, contractCode);
        return BeanCopyUtil.formatJSONArray(result);
    }

    @Override
    public JSONArray findByContractCode(String contractCode, String jsonName, String indexCode) {
        ContractDetailsVo contractDetailsVo = new ContractDetailsVo();
        contractDetailsVo.setSaleContractCode(contractCode);
        ContractDetailsVo result = this.contractDetailsService.findByContractCode(contractDetailsVo);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)result);
        return jsonArray;
    }
}

