/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.utils;

import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.entity.OrderDetailEntity;
import com.biz.crm.order.entity.OrderEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class OrderDetailUtil {
    public static List<OrderDetailEntity> packageOrderDetails(OrderVo orderVo, OrderEntity orderEntity, boolean removeZreoFlag) {
        ArrayList<OrderDetailEntity> detailEntities = new ArrayList<OrderDetailEntity>();
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            OrderDetailEntity detailEntity;
            String groupCode = group.getGroupCode();
            if (!CollectionUtils.isEmpty((Collection)group.getNormalList())) {
                for (OrderDetailVo itemVo : group.getNormalList()) {
                    if (removeZreoFlag && itemVo.getProductNum().intValue() == 0) continue;
                    detailEntity = OrderDetailUtil.packageSingleOrderDetails(itemVo, orderEntity, groupCode);
                    detailEntity.setLineType(OrderEunm.LineTypeEnum.SOURCE_PRODUCT.getCode());
                    detailEntities.add(detailEntity);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)group.getGiftList())) {
                for (OrderDetailVo itemVo : group.getGiftList()) {
                    if (removeZreoFlag && itemVo.getProductNum().intValue() == 0) continue;
                    detailEntity = OrderDetailUtil.packageSingleOrderDetails(itemVo, orderEntity, groupCode);
                    detailEntity.setLineType(OrderEunm.LineTypeEnum.GIFT_PRODUCT.getCode());
                    detailEntities.add(detailEntity);
                }
            }
            if (CollectionUtils.isEmpty((Collection)group.getBackList())) continue;
            for (OrderDetailVo itemVo : group.getBackList()) {
                if (removeZreoFlag && itemVo.getProductNum().intValue() == 0) continue;
                detailEntity = OrderDetailUtil.packageSingleOrderDetails(itemVo, orderEntity, groupCode);
                detailEntity.setLineType(OrderEunm.LineTypeEnum.REP_PRODUCT.getCode());
                detailEntities.add(detailEntity);
            }
        }
        return detailEntities;
    }

    public static OrderDetailEntity packageSingleOrderDetails(OrderDetailVo itemVo, OrderEntity orderEntity, String groupCode) {
        OrderDetailEntity detailEntity = new OrderDetailEntity();
        BeanUtils.copyProperties((Object)itemVo, (Object)((Object)detailEntity));
        detailEntity.setId(null);
        detailEntity.setOrderCode(orderEntity.getOrderCode());
        detailEntity.setGroupCode(groupCode);
        return detailEntity;
    }
}

