/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.beans;

import com.biz.crm.eunm.dms.ControlTypeDynamicEnum;
import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import com.biz.crm.nebular.dms.npromotion.bo.LimitedParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.LimitedResultBo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.List;

public abstract class AbstractLimitedComputer
implements RuleFunction<CalculateRuleParam, CalculateRuleResponse> {
    public LimitedResultBo limitedApply(LimitedParamBo param) {
        LimitedResultBo result = new LimitedResultBo();
        if (param == null || CollectionUtil.listEmpty((List)param.getLadder())) {
            result.setMatchMsg("\u9650\u91cf\u53c2\u6570\u53c2\u6570\u4e0d\u5408\u6cd5");
            return result;
        }
        LadderParseBo ladderParseBo = this.parseLadder((PromotionRuleEditVo.ControlRow)param.getLadder().get(0));
        BigDecimal value = param.getGiftValue() == null ? BigDecimal.ZERO : param.getGiftValue();
        BigDecimal redisValue = PromotionUtil.getGift(param.getAccountCode(), param.getPromotionCode());
        BigDecimal totalValue = value.add(redisValue);
        BigDecimal targetValue = ladderParseBo.getTargetValue();
        targetValue = targetValue == null ? BigDecimal.ZERO : targetValue;
        boolean flag = targetValue.compareTo(totalValue) > -1;
        BigDecimal availableValue = targetValue.subtract(redisValue);
        result.setMaxGiftValue(availableValue);
        result.setValue(flag);
        result.setRuleCode(param.getRuleCode());
        result.setRuleName(param.getRuleName());
        if (flag) {
            result.setMatchMsg(new String());
        } else {
            availableValue = availableValue.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : availableValue;
            result.setMatchMsg(String.format("\u9650\u91cf\u89c4\u5219\u5339\u914d\u5931\u8d25\uff0c\u5f53\u524d\u8d60\u9001\u6570\u91cf\uff1a%s\uff0c\u5386\u53f2\u8d60\u9001\u6570\u91cf:%s, \u53ef\u8d60\u9001\u6570\u91cf\uff1a%s", value.toString(), redisValue.toString(), availableValue.toString()));
        }
        return result;
    }

    public LadderParseBo parseLadder(PromotionRuleEditVo.ControlRow ladder) {
        List controls = ladder.getControls();
        LadderParseBo ladderParseBo = this.parseLadderByType(controls, ControlTypeDynamicEnum.LIMITED_COUNT.getCode());
        return ladderParseBo;
    }

    protected LadderParseBo parseLadderByType(List<PromotionRuleEditVo.KeyValParamControl> controls, String type) {
        if (CollectionUtil.listEmpty(controls)) {
            return null;
        }
        return PromotionUtil.parseLadderByType(controls, type);
    }

    @Override
    public CalculateRuleResponse apply(CalculateRuleParam p) {
        return new CalculateRuleResponse();
    }

    @Override
    public CalculateRuleResponse test(TestRuleParam testRuleParam) {
        return new CalculateRuleResponse();
    }
}

